/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.common.discovery;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.ow2.jasmine.agent.common.discovery.ApplicationProperty;
import org.ow2.jasmine.agent.common.discovery.ApplicationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
implements Serializable {
    private static final long serialVersionUID = -9182558372622788839L;
    private ApplicationState state;
    private String rootLocation;
    private List<ApplicationProperty> applicationProperties;
    private String id = UUID.randomUUID().toString();
    private String applicationType;

    public Application() {
    }

    public Application(ApplicationState state, String rootLocation, List<ApplicationProperty> applicationProperties, String type) {
        this.state = state;
        this.rootLocation = rootLocation;
        this.applicationProperties = applicationProperties;
        this.applicationType = type;
    }

    public int getState() {
        return this.state.ordinal();
    }

    public ApplicationState stateAsApplicationState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = ApplicationState.values()[state];
    }

    public void setState(ApplicationState state) {
        this.state = state;
    }

    public String getRootLocation() {
        return this.rootLocation;
    }

    public void setRootLocation(String rootLocation) {
        this.rootLocation = rootLocation;
    }

    public List<ApplicationProperty> getApplicationProperties() {
        return this.applicationProperties;
    }

    public void setApplicationProperties(List<ApplicationProperty> applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public String getProperty(String key) {
        for (ApplicationProperty prop : this.applicationProperties) {
            if (!prop.getPropertyName().equals(key)) continue;
            return prop.getPropertyValue();
        }
        return null;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

