/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.common.discovery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ow2.jasmine.agent.common.discovery.Interface;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemProperties
implements Serializable {
    private static final long serialVersionUID = 8881901462673499785L;
    private static Log logger = LogFactory.getLog(SystemProperties.class);
    String osName;
    String osVersion;
    String osArchitecture;
    int nbProc;
    String distribution;
    String ip;
    String hostname;
    String instanceName;
    List<Interface> networkInterfaces;

    public SystemProperties() {
        this.osName = "";
        this.osVersion = "";
        this.osArchitecture = "";
        this.nbProc = 0;
        this.distribution = "";
        this.ip = "";
        this.networkInterfaces = new ArrayList<Interface>();
        this.hostname = "";
        this.instanceName = "";
    }

    public SystemProperties(String name, String version, String architecture, int nbProc, String distribution, String ip, List<Interface> networkInterfaces, String hostname, String instanceName) {
        this.osName = name;
        this.osVersion = version;
        this.osArchitecture = architecture;
        this.nbProc = nbProc;
        this.distribution = distribution;
        this.ip = ip;
        this.networkInterfaces = networkInterfaces;
        this.hostname = hostname;
        this.instanceName = instanceName;
    }

    public void printSystemConfiguration() {
        logger.info((Object)"OS Name : {0}", new Object[]{this.osName});
        logger.info((Object)"OS Architecture : {0}", new Object[]{this.osArchitecture});
        logger.info((Object)"OS Version : {0}", new Object[]{this.osVersion});
        logger.info((Object)"Number of processors : {0}", new Object[]{this.nbProc});
        logger.info((Object)"Distribution : {0}", new Object[]{this.distribution});
        logger.info((Object)"IP Address : {0}", new Object[]{this.ip});
        logger.info((Object)"Hostname : {0}", new Object[]{this.hostname});
        logger.info((Object)"Logical Name : {0}", new Object[]{this.instanceName});
        logger.info((Object)"Network interfaces :", new Object[0]);
        for (Interface n : this.networkInterfaces) {
            logger.info((Object)"\t Interface {0}", new Object[]{n.getName()});
            logger.info((Object)"\t\t IP Address : {0}", new Object[]{n.getIpAddress()});
            logger.info((Object)"\t\t MAC Address : {0}", new Object[]{n.getMacAddress()});
        }
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsArchitecture() {
        return this.osArchitecture;
    }

    public void setOsArchitecture(String osArchitecture) {
        this.osArchitecture = osArchitecture;
    }

    public int getNbProc() {
        return this.nbProc;
    }

    public void setNbProc(int nbProc) {
        this.nbProc = nbProc;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public static Log getLogger() {
        return logger;
    }

    public static void setLogger(Log logger) {
        SystemProperties.logger = logger;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public List<Interface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(List<Interface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }
}

