/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.common.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static String getStringInFile(String search, File file) {
        try {
            String ligne;
            FileInputStream ips = new FileInputStream(file);
            InputStreamReader ipsr = new InputStreamReader(ips);
            BufferedReader br = new BufferedReader(ipsr);
            while ((ligne = br.readLine()) != null) {
                if (!ligne.contains(search) || ligne.startsWith("#")) continue;
                br.close();
                return ligne;
            }
            br.close();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File convertStreamToFile(InputStream inputStream) {
        try {
            int len;
            File f = new File("outFile");
            FileOutputStream out = new FileOutputStream(f);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            inputStream.close();
            return f;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> readFile(File f) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String ligne;
            FileInputStream ips = new FileInputStream(f);
            InputStreamReader ipsr = new InputStreamReader(ips);
            BufferedReader br = new BufferedReader(ipsr);
            while ((ligne = br.readLine()) != null) {
                list.add(ligne);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public static boolean scan(int port, InetAddress host) {
        try {
            Socket s = new Socket(host, port);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void writeInFile(String s, File f) {
        try {
            FileWriter fw = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter outputFile = new PrintWriter(bw);
            outputFile.println(s);
            outputFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        if (!localHost.isLoopbackAddress()) {
            return localHost;
        }
        InetAddress[] addrs = Utilities.getAllLocalUsingNetworkInterface();
        for (int i = 0; i < addrs.length; ++i) {
            if (addrs[i].isLoopbackAddress() || addrs[i].getHostAddress().contains(":")) continue;
            return addrs[i];
        }
        return localHost;
    }

    public static InetAddress[] getAllLocal() throws UnknownHostException {
        InetAddress[] iAddresses = InetAddress.getAllByName("127.0.0.1");
        if (iAddresses.length != 1) {
            return iAddresses;
        }
        if (!iAddresses[0].isLoopbackAddress()) {
            return iAddresses;
        }
        return Utilities.getAllLocalUsingNetworkInterface();
    }

    private static InetAddress[] getAllLocalUsingNetworkInterface() throws UnknownHostException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new UnknownHostException("127.0.0.1");
        }
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            Enumeration<InetAddress> e2 = ni.getInetAddresses();
            while (e2.hasMoreElements()) {
                addresses.add(e2.nextElement());
            }
        }
        InetAddress[] iAddresses = new InetAddress[addresses.size()];
        for (int i = 0; i < iAddresses.length; ++i) {
            iAddresses[i] = (InetAddress)addresses.get(i);
        }
        return iAddresses;
    }
}

