/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.jkmanager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.agent.common.jk.JkManagerService;
import org.ow2.jasmine.agent.remote.RemoteService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(propagation=true)
@Provides
public class JkManagerImpl
extends RemoteService
implements JkManagerService,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(JkManagerImpl.class);
    private static final String JKMANAGER_PROPERTY_FILE_NAME = "jkmanager.properties";
    private static final String WORKERS_PROPERTY_FILE_LOCATION_PROPERTY = "workers.properties.location";
    private static final String JK_CONF_FILE_LOCATION_PROPERTY = "jk.conf.location";
    private static final String CMD_RELOAD_NAME_PROPERTY = "apache.cmd.reload.name";
    private static final String CMD_RELOAD_ARG_PROPERTY = "apache.cmd.reload.arg";
    private boolean __FworkersConfigurationFile;
    private String workersConfigurationFile;
    private boolean __FjkConfigurationFile;
    private String jkConfigurationFile;
    private boolean __FreloadCmd;
    private String reloadCmd;
    private boolean __Mstart;
    private boolean __MaddWorker$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MremoveNamedWorker$java_lang_String;
    private boolean __MdisableNamedWorker$java_lang_String;
    private boolean __MenableNamedWorker$java_lang_String;
    private boolean __MstopNamedWorker$java_lang_String;
    private boolean __MmodifyStateNamedWorker$java_lang_String$java_lang_String;
    private boolean __Mreload;
    private boolean __Minit$java_lang_String$java_lang_String;
    private boolean __Mmount$java_lang_String$java_lang_String;
    private boolean __Munmount;
    private boolean __Munmount$java_lang_String;
    private boolean __Munmount$java_lang_String$java_lang_String;
    private boolean __MisConfigured$java_lang_String;
    private boolean __MisEnabled$java_lang_String;
    private boolean __MgetJkPropertyFileLocation;
    private boolean __MgetJkConfigurationFileLocation;
    private boolean __MgetPropertyApacheReloadCmdName;
    private boolean __MgetPropertyApacheReloadOptArg;
    private boolean __MloadConfigurationFile$java_lang_String;
    private boolean __MflushConfigurationFile$java_lang_String$java_util_List;
    private boolean __MgetWorkersConfigurationFile;
    private boolean __MsetWorkersConfigurationFile$java_lang_String;
    private boolean __MsetJkConfigurationFile$java_lang_String;
    private boolean __MgetReloadCmd;
    private boolean __MsetReloadCmd$java_lang_String;

    String __getworkersConfigurationFile() {
        if (!this.__FworkersConfigurationFile) {
            return this.workersConfigurationFile;
        }
        return (String)this.__IM.onGet((Object)this, "workersConfigurationFile");
    }

    void __setworkersConfigurationFile(String string) {
        if (!this.__FworkersConfigurationFile) {
            this.workersConfigurationFile = string;
            return;
        }
        this.__IM.onSet((Object)this, "workersConfigurationFile", (Object)string);
    }

    String __getjkConfigurationFile() {
        if (!this.__FjkConfigurationFile) {
            return this.jkConfigurationFile;
        }
        return (String)this.__IM.onGet((Object)this, "jkConfigurationFile");
    }

    void __setjkConfigurationFile(String string) {
        if (!this.__FjkConfigurationFile) {
            this.jkConfigurationFile = string;
            return;
        }
        this.__IM.onSet((Object)this, "jkConfigurationFile", (Object)string);
    }

    String __getreloadCmd() {
        if (!this.__FreloadCmd) {
            return this.reloadCmd;
        }
        return (String)this.__IM.onGet((Object)this, "reloadCmd");
    }

    void __setreloadCmd(String string) {
        if (!this.__FreloadCmd) {
            this.reloadCmd = string;
            return;
        }
        this.__IM.onSet((Object)this, "reloadCmd", (Object)string);
    }

    public JkManagerImpl() {
        this(null);
    }

    private JkManagerImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        logger.info((Object)"Load default configuration", new Object[0]);
        String workersConfigurationFile = this.getJkPropertyFileLocation();
        this.setWorkersConfigurationFile(workersConfigurationFile);
        String jkConfFile = this.getJkConfigurationFileLocation();
        this.setJkConfigurationFile(jkConfFile);
        String command = this.getPropertyApacheReloadCmdName();
        String arg = this.getPropertyApacheReloadOptArg();
        command = command == null || arg == null ? "/etc/init.d/apache2 reload" : command + " " + arg;
        this.setReloadCmd(command);
        logger.info((Object)("workersConfigurationFile=" + workersConfigurationFile), new Object[0]);
        logger.info((Object)("jkConfigurationFile=" + this.__getjkConfigurationFile()), new Object[0]);
        logger.info((Object)("reloadCmd=" + command), new Object[0]);
    }

    public void addWorker(String string, String string2, String string3) {
        if (!this.__MaddWorker$java_lang_String$java_lang_String$java_lang_String) {
            this.__addWorker(string, string2, string3);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addWorker$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            this.__addWorker(string, string2, string3);
            this.__IM.onExit((Object)this, "addWorker$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addWorker$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addWorker(String loadbalancer, String host, String port) {
        String workerName = "worker";
        workerName = workerName + (Math.round(Math.random() * 100000.0) + 100L);
        this.addNamedWorker(workerName, loadbalancer, host, port, "1");
    }

    public void addWorker(String string, String string2, String string3, String string4) {
        if (!this.__MaddWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addWorker(string, string2, string3, string4);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4});
            this.__addWorker(string, string2, string3, string4);
            this.__IM.onExit((Object)this, "addWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addWorker(String loadbalancer, String host, String port, String lbFactor) {
        String workerName = "worker";
        workerName = workerName + (Math.round(Math.random() * 100000.0) + 100L);
        this.addNamedWorker(workerName, loadbalancer, host, port, lbFactor);
    }

    public void addNamedWorker(String string, String string2, String string3, String string4) {
        if (!this.__MaddNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addNamedWorker(string, string2, string3, string4);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4});
            this.__addNamedWorker(string, string2, string3, string4);
            this.__IM.onExit((Object)this, "addNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addNamedWorker(String name, String loadbalancer, String host, String port) {
        this.addNamedWorker(name, loadbalancer, host, port, "1");
    }

    public void addNamedWorker(String string, String string2, String string3, String string4, String string5) {
        if (!this.__MaddNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addNamedWorker(string, string2, string3, string4, string5);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4, string5});
            this.__addNamedWorker(string, string2, string3, string4, string5);
            this.__IM.onExit((Object)this, "addNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addNamedWorker(String name, String loadbalancer, String host, String port, String lbFactor) {
        logger.info((Object)("addNamedWorker (" + name + "," + loadbalancer + "," + host + "," + port + ", " + lbFactor + ")"), new Object[0]);
        String confFileLocation = this.getWorkersConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean alreadyConfigured = false;
        boolean inLoadBalancer = false;
        for (String string : fileStringList) {
            if (string.contains("worker." + loadbalancer + ".balance_workers=") && !string.contains(name)) {
                string = string + ",";
                string = string + name;
                inLoadBalancer = true;
            } else if (string.contains("worker." + name + ".host")) {
                alreadyConfigured = true;
            }
            newFileStringList.add(string);
        }
        if (!alreadyConfigured) {
            newFileStringList.add("worker." + name + ".port=" + port);
            newFileStringList.add("worker." + name + ".host=" + host);
            newFileStringList.add("worker." + name + ".type=ajp13");
            newFileStringList.add("worker." + name + ".lbfactor=" + lbFactor);
            newFileStringList.add("worker." + name + ".activation=" + "a");
        }
        if (!inLoadBalancer) {
            newFileStringList.add("worker." + loadbalancer + ".type=lb");
            newFileStringList.add("worker." + loadbalancer + ".balance_workers=" + name);
            for (int i = 0; i < newFileStringList.size(); ++i) {
                String string;
                string = (String)newFileStringList.get(i);
                if (!string.contains("worker.list=")) continue;
                if (string.split("=")[1].split(",").length > 0) {
                    string = string + ",";
                }
                string = string + loadbalancer;
                newFileStringList.set(i, string);
                break;
            }
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeNamedWorker(String string) {
        if (!this.__MremoveNamedWorker$java_lang_String) {
            this.__removeNamedWorker(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeNamedWorker$java_lang_String", new Object[]{string});
            this.__removeNamedWorker(string);
            this.__IM.onExit((Object)this, "removeNamedWorker$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeNamedWorker$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeNamedWorker(String name) {
        boolean first;
        logger.info((Object)("removeNamedWorker (" + name + ")"), new Object[0]);
        String confFileLocation = this.getWorkersConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean loadBalancerIsEmpty = false;
        String lbToDelete = null;
        for (String string : fileStringList) {
            if (string.contains("balance_workers=")) {
                String[] balancerString = string.split("=");
                String[] balancedString = balancerString[1].split(",");
                if (balancedString.length == 1) {
                    loadBalancerIsEmpty = true;
                    lbToDelete = balancerString[0].split("\\.")[1];
                    continue;
                }
                String newBalancerString = balancerString[0] + "=";
                first = true;
                for (int i = 0; i < balancedString.length; ++i) {
                    if (balancedString[i].equals(name)) continue;
                    if (!first) {
                        newBalancerString = newBalancerString + ",";
                    } else {
                        first = false;
                    }
                    newBalancerString = newBalancerString + balancedString[i];
                }
                newFileStringList.add(newBalancerString);
                continue;
            }
            if (string.contains(name)) continue;
            newFileStringList.add(string);
        }
        if (loadBalancerIsEmpty && lbToDelete != null) {
            for (int i = 0; i < newFileStringList.size(); ++i) {
                String string;
                string = (String)newFileStringList.get(i);
                if (string.contains("worker.list=")) {
                    String[] listString = string.split("=");
                    String[] workerListString = listString[1].split(",");
                    String newWorkerString = listString[0] + "=";
                    first = true;
                    for (int j = 0; j < workerListString.length; ++j) {
                        if (workerListString[j].equals(lbToDelete)) continue;
                        if (!first) {
                            newWorkerString = newWorkerString + ",";
                        } else {
                            first = false;
                        }
                        newWorkerString = newWorkerString + workerListString[j];
                    }
                    newFileStringList.set(i, newWorkerString);
                    continue;
                }
                if (!string.contains("worker." + lbToDelete)) continue;
                newFileStringList.remove(string);
            }
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void disableNamedWorker(String string) {
        if (!this.__MdisableNamedWorker$java_lang_String) {
            this.__disableNamedWorker(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "disableNamedWorker$java_lang_String", new Object[]{string});
            this.__disableNamedWorker(string);
            this.__IM.onExit((Object)this, "disableNamedWorker$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "disableNamedWorker$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __disableNamedWorker(String name) {
        logger.info((Object)("disableNamedWorker (" + name + ")"), new Object[0]);
        this.modifyStateNamedWorker(name, "d");
    }

    public void enableNamedWorker(String string) {
        if (!this.__MenableNamedWorker$java_lang_String) {
            this.__enableNamedWorker(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "enableNamedWorker$java_lang_String", new Object[]{string});
            this.__enableNamedWorker(string);
            this.__IM.onExit((Object)this, "enableNamedWorker$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "enableNamedWorker$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __enableNamedWorker(String name) {
        logger.info((Object)("enableNamedWorker (" + name + ")"), new Object[0]);
        this.modifyStateNamedWorker(name, "a");
    }

    public void stopNamedWorker(String string) {
        if (!this.__MstopNamedWorker$java_lang_String) {
            this.__stopNamedWorker(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopNamedWorker$java_lang_String", new Object[]{string});
            this.__stopNamedWorker(string);
            this.__IM.onExit((Object)this, "stopNamedWorker$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopNamedWorker$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __stopNamedWorker(String name) {
        logger.info((Object)("stopNamedWorker (" + name + ")"), new Object[0]);
        this.modifyStateNamedWorker(name, "s");
    }

    private void modifyStateNamedWorker(String string, String string2) {
        if (!this.__MmodifyStateNamedWorker$java_lang_String$java_lang_String) {
            this.__modifyStateNamedWorker(string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "modifyStateNamedWorker$java_lang_String$java_lang_String", new Object[]{string, string2});
            this.__modifyStateNamedWorker(string, string2);
            this.__IM.onExit((Object)this, "modifyStateNamedWorker$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "modifyStateNamedWorker$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __modifyStateNamedWorker(String name, String state) {
        String confFileLocation = this.getWorkersConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean found = false;
        for (String string : fileStringList) {
            if (!string.contains("balance_workers=") && string.contains(name) && string.contains("activation")) {
                String newBalancedString = "worker." + name + ".activation=" + state;
                newFileStringList.add(newBalancedString);
                found = true;
                continue;
            }
            newFileStringList.add(string);
        }
        if (!found) {
            String activationBalancedString = "worker." + name + ".activation=" + state;
            newFileStringList.add(activationBalancedString);
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void reload() {
        if (!this.__Mreload) {
            this.__reload();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reload", new Object[0]);
            this.__reload();
            this.__IM.onExit((Object)this, "reload", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reload", throwable);
            throw throwable;
        }
    }

    private void __reload() {
        String command = this.getReloadCmd();
        try {
            logger.info((Object)"Execute command {0}", new Object[]{command});
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            logger.error((Object)"Cannot reload Apache HTTP configuration : {0}", new Object[]{e.getMessage()});
        }
    }

    public void init(String string, String string2) {
        if (!this.__Minit$java_lang_String$java_lang_String) {
            this.__init(string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "init$java_lang_String$java_lang_String", new Object[]{string, string2});
            this.__init(string, string2);
            this.__IM.onExit((Object)this, "init$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "init$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __init(String workersConfigurationFile, String reloadCmd) {
        this.setWorkersConfigurationFile(workersConfigurationFile);
        this.setReloadCmd(reloadCmd);
        logger.info((Object)("workersConfigurationFile=" + workersConfigurationFile), new Object[0]);
        logger.info((Object)("reloadCmd=" + reloadCmd), new Object[0]);
    }

    public void mount(String string, String string2) {
        if (!this.__Mmount$java_lang_String$java_lang_String) {
            this.__mount(string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "mount$java_lang_String$java_lang_String", new Object[]{string, string2});
            this.__mount(string, string2);
            this.__IM.onExit((Object)this, "mount$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "mount$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __mount(String loadbalancer, String path) {
        logger.info((Object)("mountWorker (" + path + ", " + loadbalancer + ")"), new Object[0]);
        String jkConfFileLocation = this.getJkConfigurationFileLocation();
        List<String> fileStringList = this.loadConfigurationFile(jkConfFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean alreadyConfigured = false;
        for (String string : fileStringList) {
            if (string.contains("JkMountCopy")) continue;
            if (string.contains("JkMount") && string.contains(path)) {
                alreadyConfigured = true;
            }
            newFileStringList.add(string);
        }
        if (!alreadyConfigured) {
            newFileStringList.add("JkMount " + path + " " + loadbalancer);
        }
        newFileStringList.add("");
        newFileStringList.add("JkMountCopy  All");
        this.flushConfigurationFile(jkConfFileLocation, newFileStringList);
    }

    public void unmount() {
        if (!this.__Munmount) {
            this.__unmount();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unmount", new Object[0]);
            this.__unmount();
            this.__IM.onExit((Object)this, "unmount", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unmount", throwable);
            throw throwable;
        }
    }

    private void __unmount() {
        logger.info((Object)"unmount()", new Object[0]);
        String jkConfFileLocation = this.getJkConfigurationFileLocation();
        List<String> fileStringList = this.loadConfigurationFile(jkConfFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean alreadyConfigured = false;
        for (String string : fileStringList) {
            if (string.contains("JkMount") && !string.contains("JkMountCopy")) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(jkConfFileLocation, newFileStringList);
    }

    public void unmount(String string) {
        if (!this.__Munmount$java_lang_String) {
            this.__unmount(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unmount$java_lang_String", new Object[]{string});
            this.__unmount(string);
            this.__IM.onExit((Object)this, "unmount$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unmount$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unmount(String loadbalancer) {
        logger.info((Object)("unmount(" + loadbalancer + ")"), new Object[0]);
        String jkConfFileLocation = this.getJkConfigurationFileLocation();
        List<String> fileStringList = this.loadConfigurationFile(jkConfFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean alreadyConfigured = false;
        for (String string : fileStringList) {
            if (string.contains("JkMount") && string.contains(loadbalancer)) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(jkConfFileLocation, newFileStringList);
    }

    public void unmount(String string, String string2) {
        if (!this.__Munmount$java_lang_String$java_lang_String) {
            this.__unmount(string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unmount$java_lang_String$java_lang_String", new Object[]{string, string2});
            this.__unmount(string, string2);
            this.__IM.onExit((Object)this, "unmount$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unmount$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unmount(String loadbalancer, String path) {
        logger.info((Object)("unmount(" + loadbalancer + ", " + path + ")"), new Object[0]);
        String jkConfFileLocation = this.getJkConfigurationFileLocation();
        List<String> fileStringList = this.loadConfigurationFile(jkConfFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean alreadyConfigured = false;
        for (String string : fileStringList) {
            if (string.contains("JkMount") && string.contains(loadbalancer) && string.contains(path)) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(jkConfFileLocation, newFileStringList);
    }

    public boolean isConfigured(String string) {
        boolean bl;
        if (!this.__MisConfigured$java_lang_String) {
            return this.__isConfigured(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isConfigured$java_lang_String", new Object[]{string});
            bl = this.__isConfigured(string);
            this.__IM.onExit((Object)this, "isConfigured$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isConfigured$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isConfigured(String name) {
        List<String> fileStringList = this.loadConfigurationFile(this.getWorkersConfigurationFile());
        logger.info((Object)("name=" + name), new Object[0]);
        boolean isConfiguredInBalancer = false;
        boolean isConfiguredInWorker = false;
        for (String string : fileStringList) {
            if (string.contains("balance_workers=") && string.contains(name)) {
                logger.info((Object)"isConfiguredInBalancer=true", new Object[0]);
                isConfiguredInBalancer = true;
            }
            if (!string.contains("worker." + name + ".host")) continue;
            logger.info((Object)"isConfiguredInWorker=true", new Object[0]);
            isConfiguredInWorker = true;
        }
        if (isConfiguredInBalancer && isConfiguredInWorker) {
            logger.info((Object)"-> is configured", new Object[0]);
        } else {
            logger.info((Object)"-> is not configured", new Object[0]);
        }
        return isConfiguredInBalancer && isConfiguredInWorker;
    }

    public boolean isEnabled(String string) {
        boolean bl;
        if (!this.__MisEnabled$java_lang_String) {
            return this.__isEnabled(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isEnabled$java_lang_String", new Object[]{string});
            bl = this.__isEnabled(string);
            this.__IM.onExit((Object)this, "isEnabled$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isEnabled$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isEnabled(String name) {
        logger.info((Object)("name=" + name), new Object[0]);
        boolean isConfiguredFlag = this.isConfigured(name);
        if (!isConfiguredFlag) {
            return false;
        }
        List<String> fileStringList = this.loadConfigurationFile(this.getWorkersConfigurationFile());
        for (String string : fileStringList) {
            if (!string.contains("worker." + name + ".activation")) continue;
            logger.info((Object)("worker." + name + ".activation detected"), new Object[0]);
            String[] prop = string.split("=");
            if (prop[1].trim().toLowerCase().equals("a")) {
                logger.info((Object)("worker." + name + ".activation = a -> enabled"), new Object[0]);
                return true;
            }
            logger.info((Object)("worker." + name + ".activation != a -> disabled"), new Object[0]);
            return false;
        }
        logger.info((Object)("worker." + name + " -> enabled"), new Object[0]);
        return true;
    }

    private String getJkPropertyFileLocation() {
        String string;
        if (!this.__MgetJkPropertyFileLocation) {
            return this.__getJkPropertyFileLocation();
        }
        try {
            this.__IM.onEntry((Object)this, "getJkPropertyFileLocation", new Object[0]);
            string = this.__getJkPropertyFileLocation();
            this.__IM.onExit((Object)this, "getJkPropertyFileLocation", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJkPropertyFileLocation", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getJkPropertyFileLocation() {
        JProp prop = JProp.getInstance((String)JKMANAGER_PROPERTY_FILE_NAME);
        return prop.getValue(WORKERS_PROPERTY_FILE_LOCATION_PROPERTY);
    }

    private String getJkConfigurationFileLocation() {
        String string;
        if (!this.__MgetJkConfigurationFileLocation) {
            return this.__getJkConfigurationFileLocation();
        }
        try {
            this.__IM.onEntry((Object)this, "getJkConfigurationFileLocation", new Object[0]);
            string = this.__getJkConfigurationFileLocation();
            this.__IM.onExit((Object)this, "getJkConfigurationFileLocation", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJkConfigurationFileLocation", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getJkConfigurationFileLocation() {
        JProp prop = JProp.getInstance((String)JKMANAGER_PROPERTY_FILE_NAME);
        return prop.getValue(JK_CONF_FILE_LOCATION_PROPERTY);
    }

    private String getPropertyApacheReloadCmdName() {
        String string;
        if (!this.__MgetPropertyApacheReloadCmdName) {
            return this.__getPropertyApacheReloadCmdName();
        }
        try {
            this.__IM.onEntry((Object)this, "getPropertyApacheReloadCmdName", new Object[0]);
            string = this.__getPropertyApacheReloadCmdName();
            this.__IM.onExit((Object)this, "getPropertyApacheReloadCmdName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPropertyApacheReloadCmdName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getPropertyApacheReloadCmdName() {
        JProp prop = JProp.getInstance((String)JKMANAGER_PROPERTY_FILE_NAME);
        return prop.getValue(CMD_RELOAD_NAME_PROPERTY);
    }

    private String getPropertyApacheReloadOptArg() {
        String string;
        if (!this.__MgetPropertyApacheReloadOptArg) {
            return this.__getPropertyApacheReloadOptArg();
        }
        try {
            this.__IM.onEntry((Object)this, "getPropertyApacheReloadOptArg", new Object[0]);
            string = this.__getPropertyApacheReloadOptArg();
            this.__IM.onExit((Object)this, "getPropertyApacheReloadOptArg", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPropertyApacheReloadOptArg", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getPropertyApacheReloadOptArg() {
        JProp prop = JProp.getInstance((String)JKMANAGER_PROPERTY_FILE_NAME);
        return prop.getValue(CMD_RELOAD_ARG_PROPERTY);
    }

    private List<String> loadConfigurationFile(String string) {
        List<String> list;
        if (!this.__MloadConfigurationFile$java_lang_String) {
            return this.__loadConfigurationFile(string);
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfigurationFile$java_lang_String", new Object[]{string});
            list = this.__loadConfigurationFile(string);
            this.__IM.onExit((Object)this, "loadConfigurationFile$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfigurationFile$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __loadConfigurationFile(String filePath) {
        LinkedList<String> fileStringList = new LinkedList<String>();
        try {
            String line;
            FileInputStream ips = new FileInputStream(filePath);
            InputStreamReader ipsr = new InputStreamReader(ips);
            BufferedReader br = new BufferedReader(ipsr);
            while ((line = br.readLine()) != null) {
                fileStringList.add(line);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileStringList;
    }

    private void flushConfigurationFile(String string, List<String> list) {
        if (!this.__MflushConfigurationFile$java_lang_String$java_util_List) {
            this.__flushConfigurationFile(string, list);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "flushConfigurationFile$java_lang_String$java_util_List", new Object[]{string, list});
            this.__flushConfigurationFile(string, list);
            this.__IM.onExit((Object)this, "flushConfigurationFile$java_lang_String$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "flushConfigurationFile$java_lang_String$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __flushConfigurationFile(String filePath, List<String> fileStringList) {
        try {
            FileWriter fw = new FileWriter(filePath);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter pw = new PrintWriter(bw);
            for (String string : fileStringList) {
                logger.info((Object)("flush : " + string), new Object[0]);
                pw.println(string);
            }
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getWorkersConfigurationFile() {
        String string;
        if (!this.__MgetWorkersConfigurationFile) {
            return this.__getWorkersConfigurationFile();
        }
        try {
            this.__IM.onEntry((Object)this, "getWorkersConfigurationFile", new Object[0]);
            string = this.__getWorkersConfigurationFile();
            this.__IM.onExit((Object)this, "getWorkersConfigurationFile", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getWorkersConfigurationFile", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getWorkersConfigurationFile() {
        return this.__getworkersConfigurationFile();
    }

    private void setWorkersConfigurationFile(String string) {
        if (!this.__MsetWorkersConfigurationFile$java_lang_String) {
            this.__setWorkersConfigurationFile(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setWorkersConfigurationFile$java_lang_String", new Object[]{string});
            this.__setWorkersConfigurationFile(string);
            this.__IM.onExit((Object)this, "setWorkersConfigurationFile$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setWorkersConfigurationFile$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setWorkersConfigurationFile(String workersConfigurationFile) {
        this.__setworkersConfigurationFile(workersConfigurationFile);
    }

    private void setJkConfigurationFile(String string) {
        if (!this.__MsetJkConfigurationFile$java_lang_String) {
            this.__setJkConfigurationFile(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJkConfigurationFile$java_lang_String", new Object[]{string});
            this.__setJkConfigurationFile(string);
            this.__IM.onExit((Object)this, "setJkConfigurationFile$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJkConfigurationFile$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setJkConfigurationFile(String jkConfigurationFile) {
        this.__setjkConfigurationFile(jkConfigurationFile);
    }

    private String getReloadCmd() {
        String string;
        if (!this.__MgetReloadCmd) {
            return this.__getReloadCmd();
        }
        try {
            this.__IM.onEntry((Object)this, "getReloadCmd", new Object[0]);
            string = this.__getReloadCmd();
            this.__IM.onExit((Object)this, "getReloadCmd", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getReloadCmd", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getReloadCmd() {
        return this.__getreloadCmd();
    }

    private void setReloadCmd(String string) {
        if (!this.__MsetReloadCmd$java_lang_String) {
            this.__setReloadCmd(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setReloadCmd$java_lang_String", new Object[]{string});
            this.__setReloadCmd(string);
            this.__IM.onExit((Object)this, "setReloadCmd$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setReloadCmd$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setReloadCmd(String reloadCmd) {
        this.__setreloadCmd(reloadCmd);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("workersConfigurationFile")) {
                this.__FworkersConfigurationFile = true;
            }
            if (set.contains("jkConfigurationFile")) {
                this.__FjkConfigurationFile = true;
            }
            if (set.contains("reloadCmd")) {
                this.__FreloadCmd = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("addWorker$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddWorker$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddNamedWorker$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeNamedWorker$java_lang_String")) {
                this.__MremoveNamedWorker$java_lang_String = true;
            }
            if (set.contains("disableNamedWorker$java_lang_String")) {
                this.__MdisableNamedWorker$java_lang_String = true;
            }
            if (set.contains("enableNamedWorker$java_lang_String")) {
                this.__MenableNamedWorker$java_lang_String = true;
            }
            if (set.contains("stopNamedWorker$java_lang_String")) {
                this.__MstopNamedWorker$java_lang_String = true;
            }
            if (set.contains("modifyStateNamedWorker$java_lang_String$java_lang_String")) {
                this.__MmodifyStateNamedWorker$java_lang_String$java_lang_String = true;
            }
            if (set.contains("reload")) {
                this.__Mreload = true;
            }
            if (set.contains("init$java_lang_String$java_lang_String")) {
                this.__Minit$java_lang_String$java_lang_String = true;
            }
            if (set.contains("mount$java_lang_String$java_lang_String")) {
                this.__Mmount$java_lang_String$java_lang_String = true;
            }
            if (set.contains("unmount")) {
                this.__Munmount = true;
            }
            if (set.contains("unmount$java_lang_String")) {
                this.__Munmount$java_lang_String = true;
            }
            if (set.contains("unmount$java_lang_String$java_lang_String")) {
                this.__Munmount$java_lang_String$java_lang_String = true;
            }
            if (set.contains("isConfigured$java_lang_String")) {
                this.__MisConfigured$java_lang_String = true;
            }
            if (set.contains("isEnabled$java_lang_String")) {
                this.__MisEnabled$java_lang_String = true;
            }
            if (set.contains("getJkPropertyFileLocation")) {
                this.__MgetJkPropertyFileLocation = true;
            }
            if (set.contains("getJkConfigurationFileLocation")) {
                this.__MgetJkConfigurationFileLocation = true;
            }
            if (set.contains("getPropertyApacheReloadCmdName")) {
                this.__MgetPropertyApacheReloadCmdName = true;
            }
            if (set.contains("getPropertyApacheReloadOptArg")) {
                this.__MgetPropertyApacheReloadOptArg = true;
            }
            if (set.contains("loadConfigurationFile$java_lang_String")) {
                this.__MloadConfigurationFile$java_lang_String = true;
            }
            if (set.contains("flushConfigurationFile$java_lang_String$java_util_List")) {
                this.__MflushConfigurationFile$java_lang_String$java_util_List = true;
            }
            if (set.contains("getWorkersConfigurationFile")) {
                this.__MgetWorkersConfigurationFile = true;
            }
            if (set.contains("setWorkersConfigurationFile$java_lang_String")) {
                this.__MsetWorkersConfigurationFile$java_lang_String = true;
            }
            if (set.contains("setJkConfigurationFile$java_lang_String")) {
                this.__MsetJkConfigurationFile$java_lang_String = true;
            }
            if (set.contains("getReloadCmd")) {
                this.__MgetReloadCmd = true;
            }
            if (set.contains("setReloadCmd$java_lang_String")) {
                this.__MsetReloadCmd$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

