/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.discovery.application.apache2;

import java.util.ArrayList;
import java.util.List;
import org.ow2.jasmine.agent.common.discovery.ApplicationProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Apache2ApplicationPropertiesMap {
    public static final String LISTENING_PORT_KEY = "Listening port";
    public static final String LISTENING_ADDRESS = "Listening address";
    String listeningAddress;
    int listeningPort;

    public Apache2ApplicationPropertiesMap() {
    }

    public Apache2ApplicationPropertiesMap(List<ApplicationProperty> props) {
        this.setListeningPort(Integer.parseInt(this.getPropFromList(LISTENING_PORT_KEY, props)));
        this.setListeningAddress(this.getPropFromList(LISTENING_ADDRESS, props));
    }

    private String getPropFromList(String key, List<ApplicationProperty> props) {
        for (ApplicationProperty prop : props) {
            if (!prop.getPropertyName().equals(key)) continue;
            return prop.getPropertyValue();
        }
        return null;
    }

    public List<ApplicationProperty> getPropertiesList() {
        ArrayList<ApplicationProperty> props = new ArrayList<ApplicationProperty>();
        props.add(new ApplicationProperty(LISTENING_PORT_KEY, String.valueOf(this.listeningPort)));
        props.add(new ApplicationProperty(LISTENING_ADDRESS, this.listeningAddress));
        return props;
    }

    public int getListeningPort() {
        return this.listeningPort;
    }

    public void setListeningPort(int listeningPort) {
        this.listeningPort = listeningPort;
    }

    public String getListeningAddress() {
        return this.listeningAddress;
    }

    public void setListeningAddress(String listeningAddress) {
        this.listeningAddress = listeningAddress;
    }
}

