/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.discovery.application.apache2;

import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.ow2.jasmine.agent.common.discovery.Application;
import org.ow2.jasmine.agent.common.discovery.ApplicationDiscoveryService;
import org.ow2.jasmine.agent.common.discovery.ApplicationState;
import org.ow2.jasmine.agent.common.utils.Utilities;
import org.ow2.jasmine.agent.remote.RemoteService;
import org.ow2.jasmine.agent.remote.discovery.application.apache2.Apache2ApplicationPropertiesMap;
import org.ow2.jasmine.agent.utils.filesystem.discovery.FileSystemDiscovery;
import org.ow2.jasmine.agent.utils.pattern.DiscoveryPattern;
import org.ow2.jasmine.agent.utils.pattern.PatternUtility;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="JASMINe Agent Apache2 Discovery", propagation=true)
@Provides
public class Apache2Discovery
extends RemoteService
implements ApplicationDiscoveryService,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(Apache2Discovery.class);
    private static final String TYPE = "Apache 2";
    private static final String APACHE2_PATTERN_FILE_V1 = "/apache2v1.xml";
    private static final String APACHE2_PATTERN_FILE_V2 = "/apache2v2.xml";
    private boolean __FfsService;
    @Requires
    private FileSystemDiscovery fsService;
    private boolean __MdiscoverApplications;
    private boolean __MdiscoverApplications_dynamic$java_util_List;
    private boolean __MdiscoverApplications_static;
    private boolean __MgetType;

    FileSystemDiscovery __getfsService() {
        if (!this.__FfsService) {
            return this.fsService;
        }
        return (FileSystemDiscovery)this.__IM.onGet((Object)this, "fsService");
    }

    void __setfsService(FileSystemDiscovery fileSystemDiscovery) {
        if (!this.__FfsService) {
            this.fsService = fileSystemDiscovery;
            return;
        }
        this.__IM.onSet((Object)this, "fsService", (Object)fileSystemDiscovery);
    }

    public Apache2Discovery() {
        this(null);
    }

    private Apache2Discovery(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public synchronized List<Application> discoverApplications() {
        List<Application> list;
        if (!this.__MdiscoverApplications) {
            return this.__discoverApplications();
        }
        try {
            this.__IM.onEntry((Object)this, "discoverApplications", new Object[0]);
            list = this.__discoverApplications();
            this.__IM.onExit((Object)this, "discoverApplications", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "discoverApplications", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Application> __discoverApplications() {
        return this.discoverApplications_dynamic(this.discoverApplications_static());
    }

    private List<Application> discoverApplications_dynamic(List<Application> list) {
        List<Application> list2;
        if (!this.__MdiscoverApplications_dynamic$java_util_List) {
            return this.__discoverApplications_dynamic(list);
        }
        try {
            this.__IM.onEntry((Object)this, "discoverApplications_dynamic$java_util_List", new Object[]{list});
            list2 = this.__discoverApplications_dynamic(list);
            this.__IM.onExit((Object)this, "discoverApplications_dynamic$java_util_List", list2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "discoverApplications_dynamic$java_util_List", throwable);
            throw throwable;
        }
        return list2;
    }

    private List<Application> __discoverApplications_dynamic(List<Application> discoverApplicationsStatic) {
        for (Application application : discoverApplicationsStatic) {
            try {
                boolean portIsOpen = Utilities.scan((int)Integer.parseInt(application.getProperty("Listening port")), (InetAddress)InetAddress.getLocalHost());
                if (portIsOpen) {
                    application.setState(ApplicationState.MAYBE_RUNNING);
                    continue;
                }
                application.setState(ApplicationState.STOPPED);
            }
            catch (Exception e) {
                System.out.println("Exception");
                application.setState(ApplicationState.STOPPED);
            }
        }
        return discoverApplicationsStatic;
    }

    private List<Application> discoverApplications_static() {
        List<Application> list;
        if (!this.__MdiscoverApplications_static) {
            return this.__discoverApplications_static();
        }
        try {
            this.__IM.onEntry((Object)this, "discoverApplications_static", new Object[0]);
            list = this.__discoverApplications_static();
            this.__IM.onExit((Object)this, "discoverApplications_static", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "discoverApplications_static", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Application> __discoverApplications_static() {
        ArrayList<Application> applicationList = new ArrayList<Application>();
        DiscoveryPattern apache2Patternv1 = PatternUtility.convertFileToPattern((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(APACHE2_PATTERN_FILE_V1));
        DiscoveryPattern apache2Patternv2 = PatternUtility.convertFileToPattern((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(APACHE2_PATTERN_FILE_V2));
        logger.info((Object)"Starting discovering Apache2", new Object[0]);
        List fileList = this.__getfsService().searchPattern(apache2Patternv1);
        for (File file : fileList) {
            String port;
            String ip;
            Application application = new Application();
            application.setRootLocation(file.getAbsolutePath());
            application.setState(ApplicationState.UNKNOWN);
            application.setApplicationType(TYPE);
            Apache2ApplicationPropertiesMap properties = new Apache2ApplicationPropertiesMap();
            File conf = new File(application.getRootLocation() + "/ports.conf");
            String listenConf = Utilities.getStringInFile((String)"Listen", (File)conf);
            listenConf = listenConf.replaceAll("Listen", "");
            if (listenConf.contains(":")) {
                StringTokenizer tokenizer = new StringTokenizer(listenConf.replace(" ", ""), ":");
                ip = tokenizer.nextToken();
                port = tokenizer.nextToken();
            } else {
                port = listenConf.replaceAll(" ", "");
                ip = "";
            }
            properties.setListeningAddress(ip);
            properties.setListeningPort(Integer.parseInt(port));
            application.setApplicationProperties(properties.getPropertiesList());
            applicationList.add(application);
        }
        List fileList2 = this.__getfsService().searchPattern(apache2Patternv2);
        for (File file : fileList2) {
            String port;
            Application application = new Application();
            application.setRootLocation(file.getAbsolutePath());
            application.setState(ApplicationState.UNKNOWN);
            application.setApplicationType(TYPE);
            Apache2ApplicationPropertiesMap properties = new Apache2ApplicationPropertiesMap();
            File conf = new File(application.getRootLocation() + "/conf/httpd.conf");
            String listenConf = Utilities.getStringInFile((String)"Listen", (File)conf);
            listenConf = listenConf.replaceAll("Listen", "");
            String ip = null;
            if (listenConf.contains(":")) {
                StringTokenizer tokenizer = new StringTokenizer(listenConf.replace(" ", ""), ":");
                ip = tokenizer.nextToken();
                port = tokenizer.nextToken();
            } else {
                port = listenConf.replaceAll(" ", "");
            }
            if (ip != null) {
                properties.setListeningAddress(ip);
            }
            properties.setListeningPort(Integer.parseInt(port));
            application.setApplicationProperties(properties.getPropertiesList());
            applicationList.add(application);
        }
        return applicationList;
    }

    public String getType() {
        String string;
        if (!this.__MgetType) {
            return this.__getType();
        }
        try {
            this.__IM.onEntry((Object)this, "getType", new Object[0]);
            string = this.__getType();
            this.__IM.onExit((Object)this, "getType", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getType", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getType() {
        return TYPE;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("fsService")) {
            this.__FfsService = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("discoverApplications")) {
                this.__MdiscoverApplications = true;
            }
            if (set.contains("discoverApplications_dynamic$java_util_List")) {
                this.__MdiscoverApplications_dynamic$java_util_List = true;
            }
            if (set.contains("discoverApplications_static")) {
                this.__MdiscoverApplications_static = true;
            }
            if (set.contains("getType")) {
                this.__MgetType = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

