#!/bin/sh
# ---------------------------------------------------------------------------
# JASMINe
# Copyright (C) 2010 Bull S.A.S.
# Contact: jasmine@ow2.org
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
#
# ---------------------------------------------------------------------------
# $Id: jasmine-agent.sh 9171 2011-10-13 14:30:56Z richardd $
# ---------------------------------------------------------------------------

export JONAS_ROOT=${JASMINE_AGENT_PATH}

# Check if $JONAS_ROOT is set.
if [ -z "$JONAS_ROOT" ]; then
    echo Please set the JASMINE_AGENT_PATH variable.
    exit
fi

export JONAS_BASE=$JONAS_ROOT
export PATH=$JONAS_ROOT/bin:$PATH

#export OPTS=-Dhttp.proxyHost=
#export OPTS=$OPTS -Dhttp.proxyPort=8080
#export OPTS=$OPTS -Dhttp.nonProxyHosts="localhost|127.0.0.1"

# ---------------------------------------------
# Get arguments
# ---------------------------------------------
ARGS=

case "$1" in
  start)
    jonas start -tui -n jasmine-agent -clean -fg -Djava.net.preferIPv4Stack=true -Djava.util.logging.config.file=$JONAS_BASE/conf/dosgi-logging.properties $OPTS
    ;;
  stop)
    jonas stop -n jasmine-agent
    ;;
  *)
    echo "usage : jasmine-agent start | stop"
esac
