/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.remote.jkmanager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.agent.common.jk.AjpBalancerManagerService;
import org.ow2.jasmine.agent.remote.RemoteService;
import org.ow2.jasmine.agent.remote.jkmanager.JkManagerImpl;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(propagation=true)
@Provides
public class AjpBalancerManagerImpl
extends RemoteService
implements AjpBalancerManagerService,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(JkManagerImpl.class);
    private static final String PROXY_BALANCER_CONF_FILE_LOCATION_PROPERTY = "proxy_balancer.conf.location";
    private boolean __FproxyBalancerConfigurationFile;
    private String proxyBalancerConfigurationFile;
    private static final String AJP_BALANCER_MANAGER_PROPERTY_FILE_NAME = "ajpbalancermanager.properties";
    private boolean __Mstart;
    private boolean __MaddBalancerMember$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MremoveBalancerMember$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MremoveProxyBalancer$java_lang_String;
    private boolean __Minit$java_lang_String;
    private boolean __Mmount$java_lang_String$java_lang_String;
    private boolean __Munmount$java_lang_String;
    private boolean __Munmount;
    private boolean __MloadConfigurationFile$java_lang_String;
    private boolean __MflushConfigurationFile$java_lang_String$java_util_List;
    private boolean __MgetProxyBalancerConfigurationFile;
    private boolean __MsetProxyBalancerConfigurationFile$java_lang_String;
    private boolean __MgetAjpBalancerPropertyFileLocation;

    String __getproxyBalancerConfigurationFile() {
        if (!this.__FproxyBalancerConfigurationFile) {
            return this.proxyBalancerConfigurationFile;
        }
        return (String)this.__IM.onGet((Object)this, "proxyBalancerConfigurationFile");
    }

    void __setproxyBalancerConfigurationFile(String string) {
        if (!this.__FproxyBalancerConfigurationFile) {
            this.proxyBalancerConfigurationFile = string;
            return;
        }
        this.__IM.onSet((Object)this, "proxyBalancerConfigurationFile", (Object)string);
    }

    public AjpBalancerManagerImpl() {
        this(null);
    }

    private AjpBalancerManagerImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        logger.info((Object)"Load default configuration", new Object[0]);
        String proxyBalancerConfigurationFile = this.getAjpBalancerPropertyFileLocation();
        this.setProxyBalancerConfigurationFile(proxyBalancerConfigurationFile);
        logger.info((Object)("proxyBalancerConfigurationFile=" + proxyBalancerConfigurationFile), new Object[0]);
    }

    public void addBalancerMember(String string, String string2, String string3, String string4) {
        if (!this.__MaddBalancerMember$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addBalancerMember(string, string2, string3, string4);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addBalancerMember$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4});
            this.__addBalancerMember(string, string2, string3, string4);
            this.__IM.onExit((Object)this, "addBalancerMember$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addBalancerMember$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addBalancerMember(String proxyBalancer, String host, String port, String lbFactor) {
        logger.info((Object)("addBalancerMember (" + proxyBalancer + "," + host + "," + port + ", " + lbFactor + ")"), new Object[0]);
        String confFileLocation = this.getProxyBalancerConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean proxyBalancerAlreadyCreated = false;
        boolean inProxyBalancer = false;
        boolean balancerMemberAlreadyPresent = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Proxy balancer://" + proxyBalancer + ">")) {
                proxyBalancerAlreadyCreated = true;
                inProxyBalancer = true;
            }
            if (string.contains("</Proxy>")) {
                if (inProxyBalancer && !balancerMemberAlreadyPresent) {
                    newFileStringList.add("BalancerMember ajp://" + host + ":" + port + " loadfactor=" + lbFactor);
                    balancerMemberAlreadyPresent = true;
                }
                inProxyBalancer = false;
            }
            if (!balancerMemberAlreadyPresent && inProxyBalancer && string.contains("BalancerMember ajp://" + host + ":" + port + " loadfactor=")) {
                newFileStringList.add("BalancerMember ajp://" + host + ":" + port + " loadfactor=" + lbFactor);
                balancerMemberAlreadyPresent = true;
                continue;
            }
            newFileStringList.add(string);
        }
        if (!proxyBalancerAlreadyCreated) {
            newFileStringList.add("<Proxy balancer://" + proxyBalancer + ">");
            newFileStringList.add("Allow from all");
            newFileStringList.add("BalancerMember ajp://" + host + ":" + port + " loadfactor=" + lbFactor);
            newFileStringList.add("</Proxy>");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeBalancerMember(String string, String string2, String string3) {
        if (!this.__MremoveBalancerMember$java_lang_String$java_lang_String$java_lang_String) {
            this.__removeBalancerMember(string, string2, string3);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeBalancerMember$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            this.__removeBalancerMember(string, string2, string3);
            this.__IM.onExit((Object)this, "removeBalancerMember$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeBalancerMember$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeBalancerMember(String proxyBalancer, String host, String port) {
        logger.info((Object)("removeBalancerMember (" + proxyBalancer + "," + host + "," + port + ")"), new Object[0]);
        String confFileLocation = this.getProxyBalancerConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean inProxyBalancer = false;
        ListIterator<String> iterator = fileStringList.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.contains("<Proxy balancer://" + proxyBalancer + ">")) {
                inProxyBalancer = true;
            }
            if (string.contains("</Proxy>")) {
                inProxyBalancer = false;
            }
            if (string.contains("BalancerMember ajp://" + host + ":" + port) && inProxyBalancer) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void removeProxyBalancer(String string) {
        if (!this.__MremoveProxyBalancer$java_lang_String) {
            this.__removeProxyBalancer(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeProxyBalancer$java_lang_String", new Object[]{string});
            this.__removeProxyBalancer(string);
            this.__IM.onExit((Object)this, "removeProxyBalancer$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeProxyBalancer$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeProxyBalancer(String proxyBalancer) {
        logger.info((Object)("removeProxyBalancer(" + proxyBalancer + ")"), new Object[0]);
        String confFileLocation = this.getProxyBalancerConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean inProxyBalancer = false;
        for (String string : fileStringList) {
            if (string.contains("<Proxy balancer://" + proxyBalancer + ">")) {
                inProxyBalancer = true;
            }
            if (!(inProxyBalancer || string.contains("ProxyPass") && string.contains("balancer://" + proxyBalancer + "/"))) {
                newFileStringList.add(string);
            }
            if (!string.contains("</Proxy>")) continue;
            inProxyBalancer = false;
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void init(String string) {
        if (!this.__Minit$java_lang_String) {
            this.__init(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "init$java_lang_String", new Object[]{string});
            this.__init(string);
            this.__IM.onExit((Object)this, "init$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "init$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __init(String proxyBalancerConfigurationFile) {
        this.setProxyBalancerConfigurationFile(proxyBalancerConfigurationFile);
        logger.info((Object)("proxyBalancerConfigurationFile=" + proxyBalancerConfigurationFile), new Object[0]);
    }

    public void mount(String string, String string2) {
        if (!this.__Mmount$java_lang_String$java_lang_String) {
            this.__mount(string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "mount$java_lang_String$java_lang_String", new Object[]{string, string2});
            this.__mount(string, string2);
            this.__IM.onExit((Object)this, "mount$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "mount$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __mount(String proxyBalancer, String path) {
        logger.info((Object)("mountWorker (" + proxyBalancer + ", " + path + ")"), new Object[0]);
        String confFileLocation = this.getProxyBalancerConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        boolean alreadyMount = false;
        for (String string : fileStringList) {
            if (string.contains("ProxyPass") && string.contains("balancer://" + proxyBalancer + "/")) {
                alreadyMount = true;
            }
            newFileStringList.add(string);
        }
        if (!alreadyMount) {
            newFileStringList.add("ProxyPass " + path + " " + "balancer://" + proxyBalancer + "/");
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void unmount(String string) {
        if (!this.__Munmount$java_lang_String) {
            this.__unmount(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unmount$java_lang_String", new Object[]{string});
            this.__unmount(string);
            this.__IM.onExit((Object)this, "unmount$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unmount$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unmount(String proxyBalancer) {
        logger.info((Object)("unmount(" + proxyBalancer + ")"), new Object[0]);
        String confFileLocation = this.getProxyBalancerConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        for (String string : fileStringList) {
            if (string.contains("ProxyPass") && string.contains("balancer://" + proxyBalancer + "/")) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    public void unmount() {
        if (!this.__Munmount) {
            this.__unmount();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unmount", new Object[0]);
            this.__unmount();
            this.__IM.onExit((Object)this, "unmount", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unmount", throwable);
            throw throwable;
        }
    }

    private void __unmount() {
        logger.info((Object)"unmount()", new Object[0]);
        String confFileLocation = this.getProxyBalancerConfigurationFile();
        List<String> fileStringList = this.loadConfigurationFile(confFileLocation);
        LinkedList<String> newFileStringList = new LinkedList<String>();
        for (String string : fileStringList) {
            if (string.contains("ProxyPass")) continue;
            newFileStringList.add(string);
        }
        this.flushConfigurationFile(confFileLocation, newFileStringList);
    }

    private List<String> loadConfigurationFile(String string) {
        List<String> list;
        if (!this.__MloadConfigurationFile$java_lang_String) {
            return this.__loadConfigurationFile(string);
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfigurationFile$java_lang_String", new Object[]{string});
            list = this.__loadConfigurationFile(string);
            this.__IM.onExit((Object)this, "loadConfigurationFile$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfigurationFile$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __loadConfigurationFile(String filePath) {
        LinkedList<String> fileStringList = new LinkedList<String>();
        try {
            String line;
            FileInputStream ips = new FileInputStream(filePath);
            InputStreamReader ipsr = new InputStreamReader(ips);
            BufferedReader br = new BufferedReader(ipsr);
            while ((line = br.readLine()) != null) {
                fileStringList.add(line);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileStringList;
    }

    private void flushConfigurationFile(String string, List<String> list) {
        if (!this.__MflushConfigurationFile$java_lang_String$java_util_List) {
            this.__flushConfigurationFile(string, list);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "flushConfigurationFile$java_lang_String$java_util_List", new Object[]{string, list});
            this.__flushConfigurationFile(string, list);
            this.__IM.onExit((Object)this, "flushConfigurationFile$java_lang_String$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "flushConfigurationFile$java_lang_String$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __flushConfigurationFile(String filePath, List<String> fileStringList) {
        try {
            FileWriter fw = new FileWriter(filePath);
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter pw = new PrintWriter(bw);
            for (String string : fileStringList) {
                logger.info((Object)("flush : " + string), new Object[0]);
                pw.println(string);
            }
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getProxyBalancerConfigurationFile() {
        String string;
        if (!this.__MgetProxyBalancerConfigurationFile) {
            return this.__getProxyBalancerConfigurationFile();
        }
        try {
            this.__IM.onEntry((Object)this, "getProxyBalancerConfigurationFile", new Object[0]);
            string = this.__getProxyBalancerConfigurationFile();
            this.__IM.onExit((Object)this, "getProxyBalancerConfigurationFile", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProxyBalancerConfigurationFile", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getProxyBalancerConfigurationFile() {
        return this.__getproxyBalancerConfigurationFile();
    }

    public void setProxyBalancerConfigurationFile(String string) {
        if (!this.__MsetProxyBalancerConfigurationFile$java_lang_String) {
            this.__setProxyBalancerConfigurationFile(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setProxyBalancerConfigurationFile$java_lang_String", new Object[]{string});
            this.__setProxyBalancerConfigurationFile(string);
            this.__IM.onExit((Object)this, "setProxyBalancerConfigurationFile$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setProxyBalancerConfigurationFile$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setProxyBalancerConfigurationFile(String proxyBalancerConfigurationFile) {
        this.__setproxyBalancerConfigurationFile(proxyBalancerConfigurationFile);
    }

    private String getAjpBalancerPropertyFileLocation() {
        String string;
        if (!this.__MgetAjpBalancerPropertyFileLocation) {
            return this.__getAjpBalancerPropertyFileLocation();
        }
        try {
            this.__IM.onEntry((Object)this, "getAjpBalancerPropertyFileLocation", new Object[0]);
            string = this.__getAjpBalancerPropertyFileLocation();
            this.__IM.onExit((Object)this, "getAjpBalancerPropertyFileLocation", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAjpBalancerPropertyFileLocation", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getAjpBalancerPropertyFileLocation() {
        JProp prop = JProp.getInstance((String)AJP_BALANCER_MANAGER_PROPERTY_FILE_NAME);
        return prop.getValue(PROXY_BALANCER_CONF_FILE_LOCATION_PROPERTY);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("proxyBalancerConfigurationFile")) {
            this.__FproxyBalancerConfigurationFile = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("addBalancerMember$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddBalancerMember$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeBalancerMember$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MremoveBalancerMember$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("removeProxyBalancer$java_lang_String")) {
                this.__MremoveProxyBalancer$java_lang_String = true;
            }
            if (set.contains("init$java_lang_String")) {
                this.__Minit$java_lang_String = true;
            }
            if (set.contains("mount$java_lang_String$java_lang_String")) {
                this.__Mmount$java_lang_String$java_lang_String = true;
            }
            if (set.contains("unmount$java_lang_String")) {
                this.__Munmount$java_lang_String = true;
            }
            if (set.contains("unmount")) {
                this.__Munmount = true;
            }
            if (set.contains("loadConfigurationFile$java_lang_String")) {
                this.__MloadConfigurationFile$java_lang_String = true;
            }
            if (set.contains("flushConfigurationFile$java_lang_String$java_util_List")) {
                this.__MflushConfigurationFile$java_lang_String$java_util_List = true;
            }
            if (set.contains("getProxyBalancerConfigurationFile")) {
                this.__MgetProxyBalancerConfigurationFile = true;
            }
            if (set.contains("setProxyBalancerConfigurationFile$java_lang_String")) {
                this.__MsetProxyBalancerConfigurationFile$java_lang_String = true;
            }
            if (set.contains("getAjpBalancerPropertyFileLocation")) {
                this.__MgetAjpBalancerPropertyFileLocation = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

