/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: RemoteServiceTracker.java 6921 2010-09-23 07:52:57Z veyjul $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.server.discovery;

import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.ow2.jasmine.agent.common.discovery.ApplicationDiscoveryService;
import org.ow2.jasmine.agent.common.jk.JkManagerService;

import java.util.UUID;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Tracker of Remote Services
 * 
 * @author Julien Vey
 */
@Component(name = "JASMINe Remote Service Tracker")
public class RemoteServiceTracker {

    /**
     * Logger
     */
    private static Log logger = LogFactory.getLog(DiscoveryManagerImpl.class);

    /**
     * bind each ApplicationDiscoveryService and add it to the corresponding Map of the agent
     * 
     * @param service
     *            the service binded
     * @param properties
     *            the properties of the service
     */
    @Bind(optional = true, aggregate = true)
    public void bindApplicationDiscoveryService(ApplicationDiscoveryService service) {
        DiscoveryManagerImpl.getInstance().getAgentFromUUID(UUID.fromString(service.getId()))
                .addApplicationDiscoveryService(service);
        logger.info("New ApplicationDiscoveryService detected : Type={0}, Id={1}", service.getType(), service.getId());
    }

    /**
     * Bind each JkManagerService and add it to the JkManagerService of the agent
     * 
     * @param service
     *            the service binded
     */
    @Bind(optional = true, aggregate = true)
    public void bindJkManagerService(JkManagerService service) {
        DiscoveryManagerImpl.getInstance().getAgentFromUUID(UUID.fromString(service.getId())).setJkManagerService(
                service);
        logger.info("New JkManagerService detected : Id={0}", service.getId());
    }

}
