/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.naming.InitialContext;
import org.ow2.jasmine.agent.common.discovery.Application;
import org.ow2.jasmine.agent.common.discovery.ApplicationDiscoveryService;
import org.ow2.jasmine.agent.common.discovery.SystemProperties;
import org.ow2.jasmine.agent.common.jk.JkManagerService;
import org.ow2.jasmine.agent.server.AgentState;
import org.ow2.jasmine.agent.server.discovery.DiscoveryManager;
import org.ow2.jasmine.agent.server.discovery.DiscoveryManagerImpl;
import org.ow2.jasmine.agent.server.discovery.DiscoveryServiceRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent
implements Serializable {
    private static final long serialVersionUID = 3670722052592266373L;
    private SystemProperties systemProperties;
    private List<ApplicationDiscoveryService> applicationDiscoveryServiceList = new ArrayList<ApplicationDiscoveryService>();
    private JkManagerService jkManagerService;
    private AgentState state = AgentState.RUNNING;
    private Date lastDiscovery = null;
    private List<Application> applicationList = new ArrayList<Application>();
    private List<Application> temp_applicationList = new ArrayList<Application>();
    private Boolean isDiscoveryRunning = false;
    private String agentId;

    public Agent() {
        this.systemProperties = new SystemProperties();
    }

    public Agent(SystemProperties props) {
        this.systemProperties = props;
    }

    public Agent(Agent clone) {
        this.applicationDiscoveryServiceList = new ArrayList<ApplicationDiscoveryService>();
        this.applicationList = clone.applicationList;
        this.agentId = clone.agentId;
        this.isDiscoveryRunning = clone.isDiscoveryRunning;
        this.lastDiscovery = clone.lastDiscovery;
        this.state = clone.state;
        this.systemProperties = clone.systemProperties;
    }

    public SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public JkManagerService getJkManagerService() {
        return this.jkManagerService;
    }

    public void setJkManagerService(JkManagerService jkManagerService) {
        this.jkManagerService = jkManagerService;
    }

    public void addApplicationDiscoveryService(ApplicationDiscoveryService service) {
        this.applicationDiscoveryServiceList.add(service);
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String id) {
        this.agentId = id;
    }

    public UUID getIdAsUUID() {
        return UUID.fromString(this.agentId);
    }

    public void setId(UUID id2) {
        this.agentId = id2.toString();
    }

    public List<ApplicationDiscoveryService> getApplicationDiscoveryServiceList() {
        return this.applicationDiscoveryServiceList;
    }

    public void setApplicationDiscoveryServiceList(List<ApplicationDiscoveryService> applicationDiscoveryServiceList) {
        this.applicationDiscoveryServiceList = applicationDiscoveryServiceList;
    }

    public int getState() {
        return this.state.ordinal();
    }

    public void setState(int state) {
        this.state = AgentState.values()[state];
    }

    public void setState(AgentState state) {
        this.state = state;
    }

    public String getLastDiscovery() {
        if (this.lastDiscovery != null) {
            return this.lastDiscovery.toString();
        }
        return null;
    }

    public void setLastDiscovery(String lastDiscovery) {
    }

    public void removeAllRegisteredServices() {
        this.jkManagerService = null;
        this.applicationDiscoveryServiceList = new ArrayList<ApplicationDiscoveryService>();
    }

    public List<Application> getApplicationList() {
        return this.applicationList;
    }

    public void setApplicationList(List<Application> applicationList) {
        this.applicationList = applicationList;
    }

    public synchronized void addDiscoveredApplication(List<Application> appList) {
        this.temp_applicationList.addAll(appList);
        for (Application discoveredApp : appList) {
            Boolean found = false;
            for (Application agentApp : this.applicationList) {
                if (!agentApp.getApplicationType().equals(discoveredApp.getApplicationType()) || !agentApp.getRootLocation().equals(discoveredApp.getRootLocation())) continue;
                agentApp.setApplicationProperties(discoveredApp.getApplicationProperties());
                agentApp.setState(discoveredApp.getState());
                found = true;
                break;
            }
            if (found.booleanValue()) continue;
            this.applicationList.add(discoveredApp);
        }
    }

    public synchronized void checkAppList() {
        ArrayList<Application> toRemove = new ArrayList<Application>();
        for (Application agentApp : this.applicationList) {
            Boolean found = false;
            for (Application tempApp : this.temp_applicationList) {
                if (!agentApp.getApplicationType().equals(tempApp.getApplicationType()) || !agentApp.getRootLocation().equals(tempApp.getRootLocation())) continue;
                found = true;
                break;
            }
            if (found.booleanValue()) continue;
            toRemove.add(agentApp);
        }
        for (Application agentAppR : toRemove) {
            this.applicationList.remove(agentAppR);
        }
    }

    public synchronized void discoverApplications() {
        this.temp_applicationList = new ArrayList<Application>();
        this.lastDiscovery = new Date();
        DiscoveryServiceRunner runner = new DiscoveryServiceRunner(this.applicationDiscoveryServiceList, this);
        this.isDiscoveryRunning = true;
        runner.start();
        this.sendUpdate();
    }

    public synchronized Boolean getIsDiscoveryRunning() {
        return this.isDiscoveryRunning;
    }

    public synchronized void setIsDiscoveryRunning(Boolean isDiscoveryRunning) {
        this.isDiscoveryRunning = isDiscoveryRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendUpdate() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(DiscoveryManagerImpl.class.getClassLoader());
        try {
            InitialContext ctx = new InitialContext();
            DiscoveryManager managerBean = (DiscoveryManager)ctx.lookup("agent/discoverymanager");
            managerBean.updateAgent(this.agentId);
            ctx.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public synchronized void endDiscovery() {
        this.setIsDiscoveryRunning(false);
        this.checkAppList();
        this.sendUpdate();
    }
}

