/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DiscoveryManagerImpl.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.server.discovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.ow2.jasmine.agent.server.Agent;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Implementation of the Discovery Service
 * 
 * @author Julien Vey
 */
public class DiscoveryManagerImpl {

    /**
     * instance
     */
    private static DiscoveryManagerImpl discImpl = null;

    /**
     * Private constructor
     */
    private DiscoveryManagerImpl() {
        agentList = new ArrayList<Agent>();
        serviceIdagentIdMatch = new HashMap<Long, UUID>();
    }

    /**
     * Get the unique instance
     * 
     * @return the unique instance
     */
    public static DiscoveryManagerImpl getInstance() {
        if (discImpl == null) {
            discImpl = new DiscoveryManagerImpl();
        }
        return discImpl;
    }

    /**
     * Map of the registered agent identified by their id
     */
    private List<Agent> agentList;

    /**
     * Map to match the agent discovery service id and the agent id himself
     */
    private Map<Long, UUID> serviceIdagentIdMatch;

    /**
     * Get an agent from its UUID
     * 
     * @param id
     *            the UUID of the agent
     * @return the agent whose UUID is id
     */
    public Agent getAgentFromUUID(UUID id) {
        for (Agent a : getInstance().getAgentList()) {
            if (a.getIdAsUUID().equals(id)) {
                return a;
            }
        }
        return null;
    }

    /**
     * @return the agentList
     */
    public List<Agent> getAgentList() {
        return agentList;
    }

    /**
     * @param agentList
     *            the agentList to set
     */
    public void setAgentList(List<Agent> list) {
        agentList = list;
    }

    /**
     * @return the serviceIdagentIdMatch
     */
    public Map<Long, UUID> getServiceIdagentIdMatch() {
        return serviceIdagentIdMatch;
    }

    /**
     * @param serviceIdagentIdMatch
     *            the serviceIdagentIdMatch to set
     */
    public void setServiceIdagentIdMatch(Map<Long, UUID> serviceIdagentIdMatch) {
        this.serviceIdagentIdMatch = serviceIdagentIdMatch;
    }

    /**
     * Launch discovery on an agent
     * 
     * @param agentId
     */
    public void launchDiscoveryOnAgent(String agentId) {
        getInstance().getAgentFromUUID(UUID.fromString(agentId)).discoverApplications();
    }

}
