/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.server.discovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ow2.jasmine.agent.server.Agent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryManagerImpl {
    private static DiscoveryManagerImpl discImpl = null;
    private List<Agent> agentList = new ArrayList<Agent>();
    private Map<Long, UUID> serviceIdagentIdMatch = new HashMap<Long, UUID>();

    private DiscoveryManagerImpl() {
    }

    public static DiscoveryManagerImpl getInstance() {
        if (discImpl == null) {
            discImpl = new DiscoveryManagerImpl();
        }
        return discImpl;
    }

    public Agent getAgentFromUUID(UUID id) {
        for (Agent a : DiscoveryManagerImpl.getInstance().getAgentList()) {
            if (!a.getIdAsUUID().equals(id)) continue;
            return a;
        }
        return null;
    }

    public List<Agent> getAgentList() {
        return this.agentList;
    }

    public void setAgentList(List<Agent> list) {
        this.agentList = list;
    }

    public Map<Long, UUID> getServiceIdagentIdMatch() {
        return this.serviceIdagentIdMatch;
    }

    public void setServiceIdagentIdMatch(Map<Long, UUID> serviceIdagentIdMatch) {
        this.serviceIdagentIdMatch = serviceIdagentIdMatch;
    }

    public void launchDiscoveryOnAgent(String agentId) {
        DiscoveryManagerImpl.getInstance().getAgentFromUUID(UUID.fromString(agentId)).discoverApplications();
    }
}

