/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.server.discovery;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Unbind;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.agent.common.discovery.AgentDiscoveryService;
import org.ow2.jasmine.agent.common.discovery.SystemProperties;
import org.ow2.jasmine.agent.server.Agent;
import org.ow2.jasmine.agent.server.AgentState;
import org.ow2.jasmine.agent.server.discovery.DiscoveryManager;
import org.ow2.jasmine.agent.server.discovery.DiscoveryManagerImpl;
import org.ow2.jasmine.agent.server.event.AgentEvent;
import org.ow2.jasmine.agent.server.event.AgentEventType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(mappedName="agent/discoverymanager")
@Remote(value={DiscoveryManager.class})
@Component(name="JASMINe Discovery Manager")
public class DiscoveryManagerSLSB
implements DiscoveryManager,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(DiscoveryManagerSLSB.class);
    private boolean __MgetAgentList;
    private boolean __MsetAgentList$java_util_List;
    private boolean __MlaunchDiscoveryOnAgent$java_lang_String;
    private boolean __MbindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference;
    private boolean __MunbindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference;
    private boolean __MagentToEvent$org_ow2_jasmine_agent_server_Agent$org_ow2_jasmine_agent_server_event_AgentEventType;
    private boolean __MupdateAgent$java_lang_String;
    private boolean __MupdateAgentListOnTopic$org_ow2_jasmine_agent_server_event_AgentEvent;

    public DiscoveryManagerSLSB() {
        this(null);
    }

    private DiscoveryManagerSLSB(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    @Override
    public List<Agent> getAgentList() {
        List<Agent> list;
        if (!this.__MgetAgentList) {
            return this.__getAgentList();
        }
        try {
            this.__IM.onEntry((Object)this, "getAgentList", new Object[0]);
            list = this.__getAgentList();
            this.__IM.onExit((Object)this, "getAgentList", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAgentList", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Agent> __getAgentList() {
        return DiscoveryManagerImpl.getInstance().getAgentList();
    }

    @Override
    public void setAgentList(List<Agent> list) {
        if (!this.__MsetAgentList$java_util_List) {
            this.__setAgentList(list);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setAgentList$java_util_List", new Object[]{list});
            this.__setAgentList(list);
            this.__IM.onExit((Object)this, "setAgentList$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setAgentList$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __setAgentList(List<Agent> list) {
        DiscoveryManagerImpl.getInstance().setAgentList(list);
    }

    @Override
    public void launchDiscoveryOnAgent(String string) {
        if (!this.__MlaunchDiscoveryOnAgent$java_lang_String) {
            this.__launchDiscoveryOnAgent(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "launchDiscoveryOnAgent$java_lang_String", new Object[]{string});
            this.__launchDiscoveryOnAgent(string);
            this.__IM.onExit((Object)this, "launchDiscoveryOnAgent$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "launchDiscoveryOnAgent$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __launchDiscoveryOnAgent(String idAgent) {
        DiscoveryManagerImpl.getInstance().launchDiscoveryOnAgent(idAgent);
    }

    public void bindAgentDiscoveryService(AgentDiscoveryService agentDiscoveryService, ServiceReference serviceReference) {
        if (!this.__MbindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference) {
            this.__bindAgentDiscoveryService(agentDiscoveryService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference", new Object[]{agentDiscoveryService, serviceReference});
            this.__bindAgentDiscoveryService(agentDiscoveryService, serviceReference);
            this.__IM.onExit((Object)this, "bindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Bind(optional=true, aggregate=true)
    private void __bindAgentDiscoveryService(AgentDiscoveryService service, ServiceReference reference) {
        Agent a = DiscoveryManagerImpl.getInstance().getAgentFromUUID(UUID.fromString(service.getId()));
        if (a != null) {
            a.setSystemProperties(service.getSystemProperties());
            a.setState(AgentState.RUNNING);
            a.setIsDiscoveryRunning(false);
            logger.info((Object)"Agent {0} re-registered with the following OS properties", new Object[]{a.getAgentId()});
            UUID id = UUID.fromString(service.getId());
            DiscoveryManagerImpl.getInstance().getServiceIdagentIdMatch().put((Long)reference.getProperty("service.id"), id);
            a.getSystemProperties().printSystemConfiguration();
            this.updateAgentListOnTopic(this.agentToEvent(a, AgentEventType.AGENT_UPDATE));
        } else {
            Agent agent = new Agent();
            UUID id = UUID.fromString(service.getId());
            SystemProperties props = service.getSystemProperties();
            agent.setId(id);
            agent.setSystemProperties(props);
            DiscoveryManagerImpl.getInstance().getServiceIdagentIdMatch().put((Long)reference.getProperty("service.id"), id);
            DiscoveryManagerImpl.getInstance().getAgentList().add(agent);
            System.out.println();
            logger.info((Object)"Agent {0} registered with the following OS properties", new Object[]{id});
            props.printSystemConfiguration();
            this.updateAgentListOnTopic(this.agentToEvent(agent, AgentEventType.AGENT_ADD));
        }
    }

    public void unbindAgentDiscoveryService(AgentDiscoveryService agentDiscoveryService, ServiceReference serviceReference) {
        if (!this.__MunbindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference) {
            this.__unbindAgentDiscoveryService(agentDiscoveryService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference", new Object[]{agentDiscoveryService, serviceReference});
            this.__unbindAgentDiscoveryService(agentDiscoveryService, serviceReference);
            this.__IM.onExit((Object)this, "unbindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Unbind(optional=true, aggregate=true)
    private void __unbindAgentDiscoveryService(AgentDiscoveryService service, ServiceReference reference) {
        UUID id = DiscoveryManagerImpl.getInstance().getServiceIdagentIdMatch().get(reference.getProperty("service.id"));
        Agent a = DiscoveryManagerImpl.getInstance().getAgentFromUUID(id);
        a.setState(AgentState.STOPPED);
        a.setIsDiscoveryRunning(false);
        DiscoveryManagerImpl.getInstance().getServiceIdagentIdMatch().remove(reference.getProperty("service.id"));
        a.removeAllRegisteredServices();
        logger.info((Object)"Agent {0} unregistered", new Object[]{id});
        this.updateAgentListOnTopic(this.agentToEvent(a, AgentEventType.AGENT_UPDATE));
    }

    public AgentEvent agentToEvent(Agent agent, AgentEventType agentEventType) {
        AgentEvent agentEvent;
        if (!this.__MagentToEvent$org_ow2_jasmine_agent_server_Agent$org_ow2_jasmine_agent_server_event_AgentEventType) {
            return this.__agentToEvent(agent, agentEventType);
        }
        try {
            this.__IM.onEntry((Object)this, "agentToEvent$org_ow2_jasmine_agent_server_Agent$org_ow2_jasmine_agent_server_event_AgentEventType", new Object[]{agent, agentEventType});
            agentEvent = this.__agentToEvent(agent, agentEventType);
            this.__IM.onExit((Object)this, "agentToEvent$org_ow2_jasmine_agent_server_Agent$org_ow2_jasmine_agent_server_event_AgentEventType", (Object)agentEvent);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "agentToEvent$org_ow2_jasmine_agent_server_Agent$org_ow2_jasmine_agent_server_event_AgentEventType", throwable);
            throw throwable;
        }
        return agentEvent;
    }

    private AgentEvent __agentToEvent(Agent a, AgentEventType type) {
        AgentEvent event = new AgentEvent();
        event.setAgent(new Agent(a));
        event.setType(type.ordinal());
        return event;
    }

    @Override
    public void updateAgent(String string) {
        if (!this.__MupdateAgent$java_lang_String) {
            this.__updateAgent(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateAgent$java_lang_String", new Object[]{string});
            this.__updateAgent(string);
            this.__IM.onExit((Object)this, "updateAgent$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateAgent$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __updateAgent(String id) {
        Agent a = DiscoveryManagerImpl.getInstance().getAgentFromUUID(UUID.fromString(id));
        this.updateAgentListOnTopic(this.agentToEvent(new Agent(a), AgentEventType.AGENT_UPDATE));
    }

    public void updateAgentListOnTopic(AgentEvent agentEvent) {
        if (!this.__MupdateAgentListOnTopic$org_ow2_jasmine_agent_server_event_AgentEvent) {
            this.__updateAgentListOnTopic(agentEvent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateAgentListOnTopic$org_ow2_jasmine_agent_server_event_AgentEvent", new Object[]{agentEvent});
            this.__updateAgentListOnTopic(agentEvent);
            this.__IM.onExit((Object)this, "updateAgentListOnTopic$org_ow2_jasmine_agent_server_event_AgentEvent", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateAgentListOnTopic$org_ow2_jasmine_agent_server_event_AgentEvent", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __updateAgentListOnTopic(AgentEvent event) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(DiscoveryManagerSLSB.class.getClassLoader());
        try {
            InitialContext ctx = new InitialContext();
            ConnectionFactory factory = (ConnectionFactory)ctx.lookup("JTCF");
            Topic topic = (Topic)ctx.lookup("jasmineAgent");
            Connection connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            ObjectMessage message = session.createObjectMessage((Serializable)event);
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send((Message)message);
            session.close();
            connection.close();
            ctx.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error : {0}", new Object[]{e.getMessage()});
            e.printStackTrace(System.err);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getAgentList")) {
                this.__MgetAgentList = true;
            }
            if (set.contains("setAgentList$java_util_List")) {
                this.__MsetAgentList$java_util_List = true;
            }
            if (set.contains("launchDiscoveryOnAgent$java_lang_String")) {
                this.__MlaunchDiscoveryOnAgent$java_lang_String = true;
            }
            if (set.contains("bindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference")) {
                this.__MbindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference")) {
                this.__MunbindAgentDiscoveryService$org_ow2_jasmine_agent_common_discovery_AgentDiscoveryService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("agentToEvent$org_ow2_jasmine_agent_server_Agent$org_ow2_jasmine_agent_server_event_AgentEventType")) {
                this.__MagentToEvent$org_ow2_jasmine_agent_server_Agent$org_ow2_jasmine_agent_server_event_AgentEventType = true;
            }
            if (set.contains("updateAgent$java_lang_String")) {
                this.__MupdateAgent$java_lang_String = true;
            }
            if (set.contains("updateAgentListOnTopic$org_ow2_jasmine_agent_server_event_AgentEvent")) {
                this.__MupdateAgentListOnTopic$org_ow2_jasmine_agent_server_event_AgentEvent = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

