/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Group.java 9171 2011-10-13 14:30:56Z richardd $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.server.groups;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;

import org.ow2.jasmine.agent.common.discovery.Application;

/**
 * A Group (of ressources) is a set of managed elements defined by the user
 * 
 * @author Julien Vey
 */
public class Group implements Serializable {

    /**
     * serial version UID
     */
    private static final long serialVersionUID = 1L;

    /**
     * ID of the group
     */
    private String id = UUID.randomUUID().toString();

    /**
     * Name of the group
     */
    private String name;

    /**
     * Color of the group
     */
    private int color;

    /**
     * List of applications in the group
     */
    private List<String> applicationList;

    /**
     * Default constructor
     */
    public Group() {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }

    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the color
     */
    public int getColor() {
        return color;
    }

    /**
     * @param color
     *            the color to set
     */
    public void setColor(int color) {
        this.color = color;
    }

    /**
     * @return the applicationList
     */
    public List<String> getApplicationList() {
        return applicationList;
    }

    /**
     * @param applicationList
     *            the applicationList to set
     */
    public void setApplicationList(List<String> applicationList) {
        this.applicationList = applicationList;
    }

    /**
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(String id) {
        this.id = id;
    }

}
