/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.server.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.ow2.jasmine.agent.server.groups.Group;
import org.ow2.jasmine.agent.server.groups.GroupsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsManagerImpl
implements GroupsManager {
    private static GroupsManagerImpl instance;
    private List<Group> groupList = new ArrayList<Group>();

    private GroupsManagerImpl() {
    }

    public static GroupsManagerImpl getInstance() {
        if (instance == null) {
            instance = new GroupsManagerImpl();
        }
        return instance;
    }

    @Override
    public List<Group> getGroupList() {
        return GroupsManagerImpl.getInstance().groupList;
    }

    @Override
    public void addGroup(Group g) {
        if (g.getId() == null) {
            g.setId(UUID.randomUUID().toString());
        }
        GroupsManagerImpl.getInstance().groupList.add(g);
    }

    public void setGroupList(List<Group> groupList) {
        GroupsManagerImpl.getInstance().groupList = groupList;
    }

    @Override
    public void removeGroup(Group g) {
        GroupsManagerImpl.getInstance().groupList.remove(GroupsManagerImpl.getInstance().getGroupFromID(g.getId()));
    }

    public Group getGroupFromID(String id) {
        for (Group g : GroupsManagerImpl.getInstance().groupList) {
            if (!g.getId().equals(id)) continue;
            return g;
        }
        return null;
    }

    @Override
    public void updateGroup(Group g) {
        Group inlist = GroupsManagerImpl.getInstance().getGroupFromID(g.getId());
        inlist.setApplicationList(g.getApplicationList());
        inlist.setColor(g.getColor());
        inlist.setName(g.getName());
    }
}

