/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.agent.server.groups;

import java.io.Serializable;
import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.ow2.jasmine.agent.server.groups.Group;
import org.ow2.jasmine.agent.server.groups.GroupsManager;
import org.ow2.jasmine.agent.server.groups.GroupsManagerImpl;
import org.ow2.jasmine.agent.server.groups.event.GroupEvent;
import org.ow2.jasmine.agent.server.groups.event.GroupEventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(mappedName="agent/groupsmanager")
@Remote(value={GroupsManager.class})
public class GroupsManagerSLSB
implements GroupsManager {
    @Override
    public void addGroup(Group g) {
        GroupsManagerImpl.getInstance().addGroup(g);
        this.updateGroupListOnTopic(this.groupToEvent(g, GroupEventType.GROUP_ADD));
    }

    @Override
    public List<Group> getGroupList() {
        return GroupsManagerImpl.getInstance().getGroupList();
    }

    @Override
    public void removeGroup(Group g) {
        GroupsManagerImpl.getInstance().removeGroup(g);
        this.updateGroupListOnTopic(this.groupToEvent(g, GroupEventType.GROUP_REMOVE));
    }

    @Override
    public void updateGroup(Group g) {
        GroupsManagerImpl.getInstance().updateGroup(g);
        this.updateGroupListOnTopic(this.groupToEvent(g, GroupEventType.GROUP_UPDATE));
    }

    public GroupEvent groupToEvent(Group g, GroupEventType type) {
        GroupEvent event = new GroupEvent();
        event.setGroup(g);
        event.setType(type.ordinal());
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroupListOnTopic(GroupEvent event) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(GroupsManagerSLSB.class.getClassLoader());
        try {
            InitialContext ctx = new InitialContext();
            ConnectionFactory factory = (ConnectionFactory)ctx.lookup("JTCF");
            Topic topic = (Topic)ctx.lookup("jasmineAgent");
            Connection connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            ObjectMessage message = session.createObjectMessage((Serializable)event);
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send((Message)message);
            session.close();
            connection.close();
            ctx.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

