/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JkManager.java 7029 2010-10-28 23:16:01Z pelletib $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.agent.server.jkmanager;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Requires;
import org.ow2.jasmine.agent.common.jk.JkManagerService;

/**
 * Exemple of a class using the JkManagerService
 *
 * @author Julien Vey
 */
@Component(name = "JASMINe JkManager")
public class JkManager {

    /**
     * the jkManagerService on the agent
     */
    @Requires
    private JkManagerService remoteJkService;

    /**
     * start method to test the service
     */
    public void start() {
        addWorker("192.168.100.100", "7777", "ajp13");
        reload();
    }

    /**
     * add a worker to the mod jk plugin
     *
     * @param host
     * @param port
     * @param type
     */
    public void addNamedWorker(String name, String host, String port, String type) {
        remoteJkService.addNamedWorker(name, host, port, type);
    }

    /**
     * add a worker on the mod_jk plugin
     *
     * @param host
     * @param port
     * @param type
     * @param lbFactor
     */
    public void addNamedWorker(String name, String host, String port, String type, String lbFactor) {
        remoteJkService.addNamedWorker(name, host, port, type, lbFactor);
    }

    /**
     * add a worker to the mod jk plugin
     *
     * @param host
     * @param port
     * @param type
     */
    public void addWorker(String host, String port, String type) {
        remoteJkService.addWorker(host, port, type);
    }

    /**
     * add a worker on the mod_jk plugin
     *
     * @param host
     * @param port
     * @param type
     * @param lbFactor
     */
    public void addWorker(String host, String port, String type, String lbFactor) {
        remoteJkService.addWorker(host, port, type, lbFactor);
    }

    /**
     * remove a worker on the mod_jk plugin
     *
     * @param name
     */
    public void removeNamedWorker(String name) {
        remoteJkService.removeNamedWorker(name);
    }

    /**
     * enable a worker on the mod_jk plugin
     *
     * @param name
     */
    public void enableNamedWorker(String name) {
        remoteJkService.enableNamedWorker(name);
    }

    /**
     * disable a worker on the mod_jk plugin
     *
     * @param name
     */
    public void disableNamedWorker(String name) {
        remoteJkService.disableNamedWorker(name);
    }

    /**
     * stop a worker on the mod_jk plugin
     *
     * @param name
     */
    public void stopNamedWorker(String name) {
        remoteJkService.stopNamedWorker(name);
    }

    /**
     * reload apache2 configuration
     */
    public void reload() {
        remoteJkService.reload();
    }

    /**
     * init configuration
     */
    public void init(String workersConfigurationFile, String reloadCmd) {
        remoteJkService.init(workersConfigurationFile, reloadCmd);
    }

    /**
     * @return true if configured
     */
    public boolean isConfigured(String name) {
    	return remoteJkService.isConfigured(name);
    }

    /**
     * @return true if enabled
     */
    public boolean isEnabled(String name) {
    	return remoteJkService.isEnabled(name);
    }
}
