/*
 * Decompiled with CFR 0.152.
 */
package thor.app;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import thor.net.DefaultTelnetTerminalHandler;
import thor.net.TelnetURLConnection;
import thor.net.URLStreamHandler;

public class BasicTelnet
extends Canvas
implements Runnable {
    static final boolean debug = false;
    static final int columns = 80;
    static final int lines = 24;
    static final int telnetPort = 23;
    int PTWidth;
    int PTHeight;
    int charOffset;
    int lineOffset;
    int topOffset;
    char[][] screen;
    Color[][] screenfg;
    Color[][] screenbg;
    boolean redraw = true;
    boolean[] lineRedraw;
    Color bgcolor = Color.white;
    Color fgcolor = Color.black;
    Color d_bgcolor = Color.white;
    Color d_fgcolor = Color.black;
    Font PTFont;
    boolean wrap = true;
    int xloc = 0;
    int yloc = 0;
    InputStream sIn;
    OutputStream sOut;
    Thread receive;
    int telnetState = 0;
    boolean[] option;
    DefaultTelnetTerminalHandler telnetHandler = new BasicTelnetTerminalHandler();
    Image backBuffer;

    public static void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 ? stringArray[0] : "graphics.nyu.edu";
            int n = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 23;
            BasicTelnet basicTelnet = new BasicTelnet(string, n);
            Frame frame = new Frame(string){

                public void update(Graphics graphics) {
                }

                public void paint(Graphics graphics) {
                }
            };
            frame.setLayout(new BorderLayout());
            frame.add((Component)basicTelnet, "Center");
            frame.setResizable(false);
            frame.pack();
            frame.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void openConnection(String string, int n) throws IOException {
        URL uRL = new URL("telnet", string, n, "", new URLStreamHandler());
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        ((TelnetURLConnection)uRLConnection).setTelnetTerminalHandler(this.telnetHandler);
        this.sOut = uRLConnection.getOutputStream();
        this.sIn = uRLConnection.getInputStream();
        this.telnetHandler.addWantedOption(1);
        ((TelnetURLConnection)uRLConnection).updateOptions();
        this.receive = new Thread(this);
        this.receive.start();
    }

    protected final void scrValid() {
        if (this.xloc >= 80) {
            if (this.wrap) {
                this.xloc = 0;
                ++this.yloc;
            } else {
                this.xloc = 79;
            }
        }
        if (this.yloc >= 24) {
            int n = 0;
            while (n < 23) {
                this.screen[n] = this.screen[n + 1];
                this.screenfg[n] = this.screenfg[n + 1];
                this.screenbg[n] = this.screenbg[n + 1];
                this.lineRedraw[n] = true;
                ++n;
            }
            this.screen[23] = new char[80];
            this.screenfg[23] = new Color[80];
            this.screenbg[23] = new Color[80];
            int n2 = 0;
            while (n2 < 80) {
                this.screen[23][n2] = 32;
                this.screenfg[23][n2] = this.fgcolor;
                this.screenbg[23][n2] = this.bgcolor;
                ++n2;
            }
            this.lineRedraw[23] = true;
            --this.yloc;
        }
    }

    public void initProcess() {
    }

    public void process(byte by) {
        this.normal(by);
    }

    protected final void normal(byte by) {
        this.lineRedraw[this.yloc] = true;
        this.screen[this.yloc][this.xloc] = (char)by;
        this.screenfg[this.yloc][this.xloc] = this.fgcolor;
        this.screenbg[this.yloc][this.xloc] = this.bgcolor;
        ++this.xloc;
        this.scrValid();
        this.repaint();
    }

    public void run() {
        try {
            while (true) {
                int n;
                if ((n = this.sIn.read()) < 0) {
                    System.exit(0);
                }
                this.process((byte)n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public BasicTelnet(String string) throws IOException {
        this(string, 23);
    }

    public BasicTelnet(String string, int n) throws IOException {
        this.screen = new char[24][80];
        this.lineRedraw = new boolean[24];
        this.screenfg = new Color[24][80];
        this.screenbg = new Color[24][80];
        int n2 = 0;
        while (n2 < 24) {
            this.lineRedraw[n2] = true;
            int n3 = 0;
            while (n3 < 80) {
                this.screenfg[n2][n3] = this.fgcolor;
                this.screenbg[n2][n3] = this.bgcolor;
                ++n3;
            }
            ++n2;
        }
        this.initProcess();
        this.openConnection(string, n);
        this.PTFont = new Font("Courier", 0, 14);
        FontMetrics fontMetrics = this.getFontMetrics(this.PTFont);
        this.topOffset = fontMetrics.getMaxAscent() + 1;
        this.charOffset = fontMetrics.stringWidth("X");
        this.lineOffset = fontMetrics.getHeight();
        this.PTWidth = this.charOffset * 80;
        this.PTWidth += 4;
        this.PTHeight = this.lineOffset * 24 + 3;
        super.resize(this.PTWidth + 1, this.PTHeight + 1);
    }

    public boolean keyUp(Event event, int n) {
        try {
            this.sOut.write((byte)n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return super.keyUp(event, n);
    }

    public void update(Graphics graphics) {
        if (this.backBuffer == null) {
            this.backBuffer = this.createImage(this.PTWidth + 1, this.PTHeight + 1);
        }
        Graphics graphics2 = this.backBuffer.getGraphics();
        graphics2.setFont(this.PTFont);
        int n = 0;
        while (n < 24) {
            if (this.lineRedraw[n]) {
                this.lineRedraw[n] = false;
                int n2 = 0;
                while (n2 < 79) {
                    Color color = this.screenfg[n][n2];
                    Color color2 = this.screenbg[n][n2];
                    int n3 = n2;
                    boolean bl = true;
                    while (++n2 < 80 && bl) {
                        if (color == this.screenfg[n][n2] && color2 == this.screenbg[n][n2]) continue;
                        bl = false;
                    }
                    if (!bl) {
                        --n2;
                    }
                    graphics2.setColor(color2);
                    graphics2.fillRect(3 + n3 * this.charOffset, 2 + n * this.lineOffset, this.charOffset * (n2 - n3), this.lineOffset);
                    graphics2.setColor(color);
                    graphics2.drawChars(this.screen[n], n3, n2 - n3, 3 + n3 * this.charOffset, this.topOffset + n * this.lineOffset);
                }
            }
            ++n;
        }
        if (this.yloc < 24 && this.xloc < 80 && this.yloc >= 0 && this.xloc >= 0) {
            graphics2.setColor(new Color(this.screenbg[this.yloc][this.xloc].getRGB() ^ 0xFFFFFF));
            graphics2.fillRect(3 + this.xloc * this.charOffset, 2 + this.yloc * this.lineOffset, this.charOffset, this.lineOffset);
            graphics2.setColor(new Color(this.screenfg[this.yloc][this.xloc].getRGB() ^ 0xFFFFFF));
            graphics2.drawChars(this.screen[this.yloc], this.xloc, 1, 3 + this.xloc * this.charOffset, this.topOffset + this.yloc * this.lineOffset);
            this.lineRedraw[this.yloc] = true;
        }
        graphics2.setColor(this.d_fgcolor);
        graphics2.drawRect(0, 0, this.PTWidth, this.PTHeight);
        graphics.drawImage(this.backBuffer, 0, 0, this.d_bgcolor, this);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    class BasicTelnetTerminalHandler
    extends DefaultTelnetTerminalHandler {
        BasicTelnetTerminalHandler() {
        }

        public void LineFeed() {
            ++BasicTelnet.this.yloc;
            BasicTelnet.this.xloc = 0;
            BasicTelnet.this.scrValid();
            BasicTelnet.this.lineRedraw[BasicTelnet.this.yloc] = true;
        }

        public void BackSpace() {
            --BasicTelnet.this.xloc;
            if (BasicTelnet.this.xloc < 0) {
                --BasicTelnet.this.yloc;
                BasicTelnet.this.xloc = 79;
                if (BasicTelnet.this.yloc < 0) {
                    BasicTelnet.this.yloc = 0;
                }
            }
        }

        public void HorizontalTab() {
            int n = 8 - BasicTelnet.this.xloc % 8;
            int n2 = 0;
            while (n2 < n) {
                BasicTelnet.this.normal((byte)32);
                ++n2;
            }
        }

        public void CarriageReturn() {
        }

        public void Null() {
        }

        public void FormFeed() {
        }

        public void ClearScreen() {
        }

        public void VerticalTab() {
        }
    }
}

