/*
 * Decompiled with CFR 0.152.
 */
package thor.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import thor.net.TelnetConstants;
import thor.net.TelnetOptions;
import thor.net.TelnetOutputStream;
import thor.net.TelnetTerminalHandler;

class TelnetInputStream
extends PushbackInputStream
implements TelnetConstants {
    private TelnetTerminalHandler ioHandler;
    private int inTelnetState = 241;
    private TelnetOutputStream ioOut;

    public TelnetInputStream(InputStream inputStream, TelnetOutputStream telnetOutputStream, TelnetTerminalHandler telnetTerminalHandler) {
        super(inputStream);
        this.ioOut = telnetOutputStream;
        this.ioHandler = telnetTerminalHandler;
    }

    public int available() throws IOException {
        int n = super.read();
        if (this.inTelnetState == 241 && n != 255) {
            super.unread(n);
            return 1;
        }
        super.unread(n);
        return 0;
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException();
    }

    public long skip(long l) throws IOException {
        throw new IOException();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 < 0) {
            return n3;
        }
        byArray[0] = (byte)(0xFF & n3);
        return 1;
    }

    public int read() throws IOException {
        int n;
        block27: while ((n = super.read()) >= 0) {
            if (this.inTelnetState == 241) {
                if (n == 255) {
                    this.inTelnetState = 255;
                    continue;
                }
                if (n <= 13) {
                    switch (n) {
                        case 10: {
                            this.ioHandler.LineFeed();
                            continue block27;
                        }
                        case 13: {
                            this.ioHandler.CarriageReturn();
                            continue block27;
                        }
                        case 8: {
                            this.ioHandler.BackSpace();
                            continue block27;
                        }
                        case 9: {
                            this.ioHandler.HorizontalTab();
                            continue block27;
                        }
                        case 7: {
                            this.ioHandler.Bell();
                            continue block27;
                        }
                        case 0: {
                            this.ioHandler.Null();
                            continue block27;
                        }
                        case 11: {
                            this.ioHandler.VerticalTab();
                            continue block27;
                        }
                        case 12: {
                            this.ioHandler.FormFeed();
                            continue block27;
                        }
                    }
                    return n;
                }
                return n;
            }
            switch (this.inTelnetState) {
                case 255: {
                    if (n == 255) {
                        this.inTelnetState = 241;
                        return n;
                    }
                    this.inTelnetState = n;
                    break;
                }
                case 250: {
                    this.ioHandler.OtherCommands(250);
                    break;
                }
                case 240: {
                    this.ioHandler.OtherCommands(240);
                    break;
                }
                case 242: {
                    this.ioHandler.OtherCommands(242);
                    break;
                }
                case 243: {
                    this.ioHandler.OtherCommands(243);
                    break;
                }
                case 244: {
                    this.ioHandler.OtherCommands(244);
                    break;
                }
                case 245: {
                    this.ioHandler.OtherCommands(245);
                    break;
                }
                case 246: {
                    this.ioHandler.OtherCommands(246);
                    break;
                }
                case 247: {
                    this.ioHandler.OtherCommands(247);
                    break;
                }
                case 248: {
                    this.ioHandler.OtherCommands(248);
                    break;
                }
                case 249: {
                    this.ioHandler.OtherCommands(249);
                    break;
                }
                case 252: {
                    this.inTelnetState = 241;
                    TelnetOptions.toString(n);
                    if (this.ioHandler.isWantedOption(n)) {
                        this.ioHandler.removeWantedOption(n);
                    }
                    this.ioHandler.setOption(n, false);
                    break;
                }
                case 254: {
                    this.inTelnetState = 241;
                    TelnetOptions.toString(n);
                    this.ioHandler.setOption(n, false);
                    break;
                }
                case 251: {
                    this.inTelnetState = 241;
                    TelnetOptions.toString(n);
                    if (this.ioHandler.isWantedOption(n)) {
                        this.ioHandler.setOption(n, true);
                        break;
                    }
                    this.ioOut.sendcmd((byte)-2, (byte)n);
                    break;
                }
                case 253: {
                    this.inTelnetState = 241;
                    TelnetOptions.toString(n);
                    if (this.ioHandler.isWantedOption(n)) {
                        this.ioHandler.setOption(n, true);
                        break;
                    }
                    this.ioOut.sendcmd((byte)-4, (byte)n);
                }
            }
        }
        return n;
    }

    void setTelnetTerminalHandler(TelnetTerminalHandler telnetTerminalHandler) {
        this.ioHandler = telnetTerminalHandler;
    }

    TelnetTerminalHandler getTelnetTerminalHandler() {
        return this.ioHandler;
    }
}

