/*
 * Decompiled with CFR 0.152.
 */
package thor.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import thor.net.DefaultTelnetTerminalHandler;
import thor.net.TelnetConstants;
import thor.net.TelnetInputStream;
import thor.net.TelnetOutputStream;
import thor.net.TelnetTerminalHandler;

public class TelnetURLConnection
extends URLConnection
implements TelnetConstants {
    private TelnetInputStream ioTelnetIn;
    private TelnetOutputStream ioTelnetOut;
    private TelnetTerminalHandler ioHandler = new DefaultTelnetTerminalHandler();
    private Socket sock;

    public TelnetURLConnection(URL uRL) {
        super(uRL);
    }

    public void connect() throws IOException {
        this.sock = new Socket(this.url.getHost(), this.url.getPort());
        this.ioTelnetOut = new TelnetOutputStream(this.sock.getOutputStream());
        this.ioTelnetIn = new TelnetInputStream(this.sock.getInputStream(), this.ioTelnetOut, this.ioHandler);
    }

    public void disconnect() throws IOException {
        this.sock.close();
        this.ioTelnetOut = null;
        this.ioTelnetIn = null;
        this.sock = null;
    }

    public boolean connected() {
        return this.sock != null;
    }

    public OutputStream getOutputStream() {
        return this.ioTelnetOut;
    }

    public InputStream getInputStream() {
        return this.ioTelnetIn;
    }

    public void setTelnetTerminalHandler(TelnetTerminalHandler telnetTerminalHandler) {
        this.ioHandler = telnetTerminalHandler;
        this.ioTelnetIn.setTelnetTerminalHandler(this.ioHandler);
    }

    public TelnetTerminalHandler getTelnetTerminalHandler() {
        return this.ioHandler;
    }

    public void sendCommand(int n, int n2) throws IOException {
        this.ioTelnetOut.sendcmd((byte)n, (byte)n2);
    }

    public void updateOptions() {
        try {
            int[] nArray = this.getTelnetTerminalHandler().getWantedOptions();
            int n = 0;
            while (n < nArray.length) {
                this.sendCommand(253, nArray[n]);
                ++n;
            }
            int[] nArray2 = this.getTelnetTerminalHandler().getNotWantedOptions();
            int n2 = 0;
            while (n2 < nArray2.length) {
                this.sendCommand(254, nArray2[n2]);
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

