/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.AttributeController;
import org.objectweb.fractal.util.Fractal;

public class AttributeUtil {
    private static String capitalize(String str) {
        if (str.length() == 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static Method findGetter(Class[] itfs, String propName) {
        for (int i = 0; i < itfs.length; ++i) {
            Method getter = AttributeUtil.findGetter(itfs[i], propName);
            if (getter == null) continue;
            return getter;
        }
        return null;
    }

    private static Method findGetter(Class klass, String propName) {
        Method getter = null;
        try {
            getter = klass.getMethod("get" + AttributeUtil.capitalize(propName), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                getter = klass.getMethod("is" + AttributeUtil.capitalize(propName), new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                // empty catch block
            }
        }
        if (getter == null || getter.getReturnType().equals(Void.TYPE)) {
            return null;
        }
        return getter;
    }

    private static Method findSetter(Class[] itfs, String propName, Object value) {
        for (int i = 0; i < itfs.length; ++i) {
            Method setter = AttributeUtil.findSetter(itfs[i], propName, value);
            if (setter == null) continue;
            return setter;
        }
        return null;
    }

    private static Method findSetter(Class klass, String propName, Object value) {
        Method[] allMethods = klass.getMethods();
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (int i = 0; i < allMethods.length; ++i) {
            if (!AttributeUtil.isValidSetter(allMethods[i], propName, value)) continue;
            candidates.add(allMethods[i]);
        }
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (Method)candidates.get(0);
        }
        return (Method)candidates.get(0);
    }

    public static Class[] getAttributeControllerInterfaces(Component component) {
        try {
            AttributeController ac = Fractal.getAttributeController((Component)component);
            Class<?>[] itfs = ac.getClass().getInterfaces();
            ArrayList attrItfs = new ArrayList();
            for (int i = 0; i < itfs.length; ++i) {
                if (!AttributeController.class.isAssignableFrom(itfs[i])) continue;
                attrItfs.add(itfs[i]);
            }
            return attrItfs.toArray(new Class[attrItfs.size()]);
        }
        catch (NoSuchInterfaceException nsie) {
            return new Class[0];
        }
    }

    public static Map getAttributes(Component component) {
        String[] names = AttributeUtil.getAttributesNames(component);
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (int i = 0; i < names.length; ++i) {
            props.put(names[i], AttributeUtil.getAttribute(component, names[i]));
        }
        return props;
    }

    public static String[] getAttributesNames(Component component) {
        Class[] itfs = AttributeUtil.getAttributeControllerInterfaces(component);
        HashSet<String> names = new HashSet<String>();
        if (itfs != null) {
            for (int i = 0; i < itfs.length; ++i) {
                Method[] allMethods = itfs[i].getMethods();
                for (int j = 0; j < allMethods.length; ++j) {
                    Method m = allMethods[j];
                    if (!m.getName().matches("^(get|is)[A-Z].*") || m.getParameterTypes().length != 0 || m.getReturnType().equals(Void.TYPE)) continue;
                    char[] chars = m.getName().substring(3).toCharArray();
                    chars[0] = Character.toLowerCase(chars[0]);
                    names.add(new String(chars));
                }
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public static String[] getAttributesNames(Component component, Class attributeClass) {
        HashSet<String> names = new HashSet<String>();
        Method[] allMethods = attributeClass.getMethods();
        for (int j = 0; j < allMethods.length; ++j) {
            Method m = allMethods[j];
            if (!m.getName().matches("^(get|is)[A-Z].*") || m.getParameterTypes().length != 0 || m.getReturnType().equals(Void.TYPE)) continue;
            char[] chars = m.getName().substring(3).toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            names.add(new String(chars));
        }
        return names.toArray(new String[names.size()]);
    }

    public static Object getAttribute(Component component, String name) {
        Class[] itfs = AttributeUtil.getAttributeControllerInterfaces(component);
        if (itfs == null || itfs.length == 0) {
            return null;
        }
        Method getter = AttributeUtil.findGetter(itfs, name);
        if (getter != null) {
            try {
                return getter.invoke((Object)Fractal.getAttributeController((Component)component), new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Class getAttributeType(Component component, String name) {
        Class[] itfs = AttributeUtil.getAttributeControllerInterfaces(component);
        if (itfs == null || itfs.length == 0) {
            return null;
        }
        Method getter = AttributeUtil.findGetter(itfs, name);
        if (getter != null) {
            return getter.getReturnType();
        }
        return null;
    }

    public static boolean hasAttribute(Component component, String name) {
        Class[] itfs = AttributeUtil.getAttributeControllerInterfaces(component);
        if (itfs == null || itfs.length == 0) {
            return false;
        }
        return AttributeUtil.findGetter(itfs, name) != null;
    }

    private static boolean isValidSetter(Method m, String prop, Object value) {
        if (!m.getName().equals("set" + AttributeUtil.capitalize(prop))) {
            return false;
        }
        Class<?>[] pTypes = m.getParameterTypes();
        if (pTypes.length != 1) {
            return false;
        }
        if (value == null) {
            return true;
        }
        Class<?> clazz = value.getClass();
        if (pTypes[0].isPrimitive() && !clazz.isPrimitive()) {
            if (value instanceof Integer && pTypes[0].equals(Integer.TYPE)) {
                return true;
            }
            if (value instanceof Boolean && pTypes[0].equals(Boolean.TYPE)) {
                return true;
            }
            if (value instanceof Float && pTypes[0].equals(Float.TYPE)) {
                return true;
            }
            if (value instanceof Long && pTypes[0].equals(Long.TYPE)) {
                return true;
            }
            if (value instanceof Double && pTypes[0].equals(Double.TYPE)) {
                return true;
            }
        }
        return pTypes[0].isAssignableFrom(value.getClass());
    }

    public static void setAttribute(Component component, String name, Object value) throws IllegalArgumentException, NoSuchInterfaceException {
        Method setter;
        if (!AttributeUtil.hasAttribute(component, name)) {
            throw new IllegalArgumentException("No such attribute.");
        }
        Class[] itfs = AttributeUtil.getAttributeControllerInterfaces(component);
        if (itfs != null && (setter = AttributeUtil.findSetter(itfs, name, value)) != null) {
            try {
                setter.invoke((Object)Fractal.getAttributeController((Component)component), value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

