/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.dumper.util;

import org.objectweb.fractal.adl.dumper.util.ComponentUtil;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.util.Fractal;

public class ContentUtil {
    public static boolean isSubcomponent(Component child, Component parent) {
        try {
            int i;
            Component[] children = Fractal.getContentController((Component)parent).getFcSubComponents();
            for (i = 0; i < children.length && child != children[i]; ++i) {
            }
            return i < children.length;
        }
        catch (NoSuchInterfaceException e) {
            return false;
        }
    }

    public static Component[] getParents(Component comp) {
        try {
            return Fractal.getSuperController((Component)comp).getFcSuperComponents();
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
    }

    public static boolean isShared(Component comp) {
        Component[] parents = ContentUtil.getParents(comp);
        if (parents != null) {
            return parents.length > 1;
        }
        return false;
    }

    public static Component[] getSubComponents(Component comp) {
        try {
            return Fractal.getContentController((Component)comp).getFcSubComponents();
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
    }

    public static boolean isComposite(Component comp) {
        try {
            Fractal.getContentController((Component)comp);
            return true;
        }
        catch (NoSuchInterfaceException e1) {
            return false;
        }
    }

    public static String getImplementation(Component comp) {
        String content = null;
        try {
            content = comp.getFcInterface("/content").getClass().getName();
        }
        catch (NoSuchInterfaceException e) {
            return null;
        }
        return content;
    }

    public static boolean isFirstParentOfSharedComp(Component child, Component parent) {
        return ContentUtil.isShared(child) && ComponentUtil.getName(ContentUtil.getParents(child)[0]).equals(ComponentUtil.getName(parent));
    }

    public static boolean areRelatives(Component comp1, Component comp2) {
        return ContentUtil.isSubcomponent(comp1, comp2) || ContentUtil.isSubcomponent(comp2, comp1) || ContentUtil.areSiblings(comp1, comp2);
    }

    public static boolean areSiblings(Component comp1, Component comp2) {
        Component[] parents1 = ContentUtil.getParents(comp1);
        Component[] parents2 = ContentUtil.getParents(comp2);
        if (ComponentUtil.isTopLevel(comp1) && ComponentUtil.isTopLevel(comp2)) {
            return true;
        }
        if (parents1 == null || parents2 == null) {
            return false;
        }
        for (int i = 0; i < parents1.length; ++i) {
            int j = 0;
            while (i < parents2.length) {
                if (parents1[i] == parents1[j]) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }
}

