/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.jonathan.apis.binding.Identifier;
import org.objectweb.jonathan.apis.binding.NamingContext;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.ContextFactory;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.presentation.Marshaller;
import org.objectweb.jonathan.apis.presentation.UnMarshaller;
import org.objectweb.jonathan.apis.protocols.Protocol;
import org.objectweb.jonathan.apis.protocols.ProtocolGraph;
import org.objectweb.jonathan.apis.protocols.RequestSession;
import org.objectweb.jonathan.apis.protocols.SessionIdentifier;
import org.objectweb.jonathan.apis.stub_factories.StubFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class RmiBinder
implements NamingContext,
BindingController {
    protected NamingContext adapter;
    protected StubFactory stubFactory;
    protected ContextFactory contextFactory;
    protected Protocol rmi;
    protected Protocol tcp;
    protected LoggerFactory loggerFactory;
    protected Logger logger;
    private Map sessionIdentifiers = new HashMap();

    public String[] listFc() {
        return new String[]{"adapter", "stub-factory", "context-factory", "rmi-protocol", "tcp-protocol", "logger-factory"};
    }

    public Object lookupFc(String clientItfName) {
        if (clientItfName.equals("adapter")) {
            return this.adapter;
        }
        if (clientItfName.equals("stub-factory")) {
            return this.stubFactory;
        }
        if (clientItfName.equals("context-factory")) {
            return this.contextFactory;
        }
        if (clientItfName.equals("rmi-protocol")) {
            return this.rmi;
        }
        if (clientItfName.equals("tcp-protocol")) {
            return this.tcp;
        }
        if (clientItfName.equals("logger-factory")) {
            return this.loggerFactory;
        }
        return null;
    }

    public void bindFc(String clientItfName, Object serverItf) {
        if (clientItfName.equals("adapter")) {
            this.adapter = (NamingContext)serverItf;
        } else if (clientItfName.equals("stub-factory")) {
            this.stubFactory = (StubFactory)serverItf;
        } else if (clientItfName.equals("context-factory")) {
            this.contextFactory = (ContextFactory)serverItf;
        } else if (clientItfName.equals("rmi-protocol")) {
            this.rmi = (Protocol)serverItf;
        } else if (clientItfName.equals("tcp-protocol")) {
            this.tcp = (Protocol)serverItf;
        } else if (clientItfName.equals("logger-factory")) {
            this.loggerFactory = (LoggerFactory)serverItf;
            this.logger = this.loggerFactory.getLogger(this.getClass().getName());
        }
    }

    public void unbindFc(String clientItfName) {
        if (clientItfName.equals("adapter")) {
            this.adapter = null;
        } else if (clientItfName.equals("stub-factory")) {
            this.stubFactory = null;
        } else if (clientItfName.equals("context-factory")) {
            this.contextFactory = null;
        } else if (clientItfName.equals("rmi-protocol")) {
            this.rmi = null;
        } else if (clientItfName.equals("tcp-protocol")) {
            this.tcp = null;
        } else if (clientItfName.equals("logger-factory")) {
            this.loggerFactory = null;
            this.logger = null;
        }
    }

    public Identifier export(Object obj, Context hints) throws JonathanException {
        Integer i;
        int port = 0;
        if (hints != null && (i = (Integer)hints.getValue("port", '\u0000')) != null) {
            port = i;
        }
        SessionIdentifier sid = null;
        if (port == 0) {
            if (this.sessionIdentifiers.size() > 0) {
                sid = (SessionIdentifier)this.sessionIdentifiers.values().iterator().next();
            }
        } else {
            sid = (SessionIdentifier)this.sessionIdentifiers.get(new Integer(port));
        }
        if (sid == null) {
            Context phints = this.contextFactory.newContext();
            phints.addElement("port", Integer.class, new Integer(port), '\u0000');
            ProtocolGraph pgraph = this.rmi.createProtocolGraph(new ProtocolGraph[]{this.tcp.createProtocolGraph(new ProtocolGraph[0], phints)}, phints);
            phints.release();
            sid = pgraph.export(null);
            Context ctxt = sid.next()[0].getInfo();
            port = (Integer)ctxt.getValue("port", '\u0000');
            this.sessionIdentifiers.put(new Integer(port), sid);
        }
        Context ctxt = sid.next()[0].getInfo();
        String host = (String)ctxt.getValue("hostname", '\u0000');
        port = (Integer)ctxt.getValue("port", '\u0000');
        Id id = new Id(host, port, this.adapter.export(obj, hints));
        if (this.logger != null && this.logger.isLoggable(BasicLevel.INFO)) {
            this.logger.log(BasicLevel.INFO, (Object)("Object " + obj + " exported with id " + id));
        }
        return id;
    }

    public Identifier decode(byte[] data, int offset, int length) throws JonathanException {
        int port = ((data[offset] & 0xFF) << 24) + ((data[offset + 1] & 0xFF) << 16) + ((data[offset + 2] & 0xFF) << 8) + (data[offset + 3] & 0xFF);
        int len = ((data[offset + 4] & 0xFF) << 8) + (data[offset + 5] & 0xFF);
        char[] host = new char[len];
        for (int i = 0; i < len; ++i) {
            host[i] = (char)(data[offset + 6 + i] & 0xFF);
        }
        Identifier next = this.adapter.decode(data, offset + 6 + len, length - 6 - len);
        return new Id(new String(host), port, next);
    }

    public Identifier decode(UnMarshaller u) throws JonathanException {
        int port = u.readInt();
        int len = u.readShort();
        char[] host = new char[len];
        for (int i = 0; i < len; ++i) {
            host[i] = (char)(u.readByte() & 0xFF);
        }
        Identifier next = this.adapter.decode(u);
        return new Id(new String(host), port, next);
    }

    class Id
    implements Identifier {
        public String host;
        public int port;
        public Identifier next;

        public Id(String host, int port, Identifier next) {
            this.host = host;
            this.port = port;
            this.next = next;
        }

        public NamingContext getContext() {
            return RmiBinder.this;
        }

        public Object bind(Identifier[] ref, Context hints) throws JonathanException {
            RequestSession session;
            Object impl;
            Properties p = new Properties();
            p.put("object_key", this.next.encode());
            p.put("hostname", this.host);
            p.put("port", new Integer(this.port));
            SessionIdentifier sessionId = RmiBinder.this.rmi.createSessionIdentifier(p, new SessionIdentifier[]{RmiBinder.this.tcp.createSessionIdentifier(p, new SessionIdentifier[0])});
            if (sessionId.isLocal() && (impl = (session = (RequestSession)this.next.bind(null, hints)).getTarget()) != null) {
                return impl;
            }
            Object s = RmiBinder.this.stubFactory.newStub(sessionId, new Identifier[]{this}, hints);
            if (RmiBinder.this.logger != null && RmiBinder.this.logger.isLoggable(BasicLevel.INFO)) {
                RmiBinder.this.logger.log(BasicLevel.INFO, (Object)("Stub " + s + " bound to id " + ref[0]));
            }
            return s;
        }

        public void unexport() {
        }

        public boolean isValid() {
            return true;
        }

        public Object resolve() {
            return null;
        }

        public byte[] encode() throws JonathanException {
            int len = this.host.length();
            byte[] n = this.next.encode();
            byte[] b = new byte[n.length + 6 + len];
            b[0] = (byte)(this.port >>> 24 & 0xFF);
            b[1] = (byte)(this.port >>> 16 & 0xFF);
            b[2] = (byte)(this.port >>> 8 & 0xFF);
            b[3] = (byte)(this.port & 0xFF);
            b[4] = (byte)(len >>> 8 & 0xFF);
            b[5] = (byte)(len & 0xFF);
            for (int i = 0; i < len; ++i) {
                b[i + 6] = (byte)this.host.charAt(i);
            }
            System.arraycopy(n, 0, b, 6 + len, n.length);
            return b;
        }

        public void encode(Marshaller m) throws JonathanException {
            int len = this.host.length();
            m.writeInt(this.port);
            m.writeShort((short)len);
            for (int i = 0; i < len; ++i) {
                m.writeByte((byte)this.host.charAt(i));
            }
            this.next.encode(m);
        }

        public boolean equals(Object o) {
            if (o instanceof Id) {
                Id id = (Id)o;
                if (this.host.equals(id.host) && this.port == id.port) {
                    return this.next.equals(id.next);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.host.hashCode() * this.port * (this.next.hashCode() + 17);
        }

        public String toString() {
            return "Id[" + this.host + "," + this.port + "," + this.next + "]";
        }
    }
}

