/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi.io;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.rmi.io.Ref;
import org.objectweb.jonathan.apis.binding.NamingContext;
import org.objectweb.jonathan.apis.binding.Reference;

public class RmiObjectOutputStream
extends ObjectOutputStream {
    protected NamingContext domain;

    public RmiObjectOutputStream(OutputStream os, NamingContext domain) throws IOException {
        super(os);
        this.enableReplaceObject(true);
        this.domain = domain;
        String codeBase = System.getProperty("java.rmi.server.codebase");
        this.writeUTF(codeBase == null ? "" : codeBase);
    }

    protected Object replaceObject(Object obj) throws IOException {
        if (obj instanceof Interface) {
            try {
                Ref ref = new Ref();
                ref.type = obj.getClass().getInterfaces()[0].getName();
                ref.id = obj instanceof Reference ? ((Reference)obj).getIdentifiers()[0].encode() : this.domain.export(obj, null).encode();
                return ref;
            }
            catch (Exception e) {
                throw new IOException("Cannot export object: " + e);
            }
        }
        return obj;
    }

    protected void drain() throws IOException {
        super.drain();
    }
}

