/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.objectweb.fractal.rmi.io.RmiObjectInputStream;
import org.objectweb.jonathan.apis.binding.NamingContext;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.ContextFactory;
import org.objectweb.jonathan.apis.kernel.InternalException;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.presentation.EndOfMessageException;
import org.objectweb.jonathan.apis.presentation.UnMarshaller;
import org.objectweb.jonathan.apis.resources.Chunk;
import org.objectweb.jonathan.apis.resources.ChunkProvider;

public class RmiUnMarshaller
extends InputStream
implements UnMarshaller {
    private static final Chunk EMPTY_CHUNK = new Chunk(new byte[0], 0, 0);
    protected NamingContext domain;
    protected ContextFactory contextFactory;
    protected ObjectInputStream is;
    private ChunkProvider provider;
    private Chunk first;
    private int offset;
    private int lastOffset;
    private Context context;

    public RmiUnMarshaller(NamingContext domain, ContextFactory contextFactory, Chunk chunk, int read) {
        this.domain = domain;
        this.contextFactory = contextFactory;
        this.first = chunk;
        this.offset = chunk.offset;
        this.lastOffset = read - this.offset;
        this.context = null;
    }

    public RmiUnMarshaller(NamingContext domain, ContextFactory contextFactory, ChunkProvider provider) {
        this(domain, contextFactory, EMPTY_CHUNK, 0);
        this.provider = provider;
    }

    public boolean isLittleEndian() {
        return false;
    }

    public void setByteOrder(boolean littleEndian) {
        throw new RuntimeException("Not implemented.");
    }

    public final Context getContext() {
        if (this.context == null) {
            try {
                this.context = this.contextFactory.newContext();
            }
            catch (NullPointerException e) {
                e.printStackTrace(System.err);
                throw new InternalException("Context factory required.");
            }
        }
        return this.context;
    }

    public int bytesRead() {
        return this.lastOffset + this.offset;
    }

    public void setSize(int size) throws JonathanException {
        boolean sz0 = size == 0;
        Chunk result = null;
        Chunk current = null;
        int lastOff = this.lastOffset + this.offset;
        int available = this.first.top - this.offset;
        this.first.offset = this.offset;
        while (size > available) {
            if (available > 0) {
                current = current == null ? (result = this.first.duplicate()) : (current.next = this.first.duplicate());
                size -= available;
                this.offset = this.first.top;
            }
            this.prepare();
            available = this.first.top - this.offset;
        }
        if (size > 0) {
            if (current == null) {
                result = this.first.duplicate(this.offset, this.offset + size);
            } else {
                current.next = this.first.duplicate(this.offset, this.offset + size);
            }
            this.offset += size;
        }
        Context thisContext = this.context;
        if (this.context != null) {
            this.context.acquire();
        }
        this.close();
        this.context = thisContext;
        this.first = sz0 ? EMPTY_CHUNK : result;
        this.offset = this.first.offset;
        this.lastOffset = lastOff - this.offset;
    }

    public InputStream inputStream() {
        return this;
    }

    public byte readByte() throws JonathanException {
        if (this.first.top == this.offset) {
            this.prepare();
        }
        return this.first.data[this.offset++];
    }

    public boolean readBoolean() throws JonathanException {
        if (this.first.top == this.offset) {
            this.prepare();
        }
        return this.first.data[this.offset++] != 0;
    }

    public char readChar8() throws JonathanException {
        if (this.first.top == this.offset) {
            this.prepare();
        }
        return (char)(this.first.data[this.offset++] & 0xFF);
    }

    public char readChar16() throws JonathanException {
        byte[] data = this.first.data;
        int val = 0;
        if (this.first.top - this.offset >= 2) {
            val = ((data[this.offset] & 0xFF) << 8) + (data[this.offset + 1] & 0xFF);
            this.offset += 2;
        } else {
            int m = 1;
            while (m >= 0) {
                int p = Math.min(m + 1, this.first.top - this.offset);
                if (p == 0) {
                    this.prepare();
                    data = this.first.data;
                    continue;
                }
                while (--p >= 0) {
                    val += (data[this.offset++] & 0xFF) << m-- * 8;
                }
            }
        }
        return (char)val;
    }

    public short readShort() throws JonathanException {
        byte[] data = this.first.data;
        int val = 0;
        if (this.first.top - this.offset >= 2) {
            val = ((data[this.offset] & 0xFF) << 8) + (data[this.offset + 1] & 0xFF);
            this.offset += 2;
        } else {
            int m = 1;
            while (m >= 0) {
                int p = Math.min(m + 1, this.first.top - this.offset);
                if (p == 0) {
                    this.prepare();
                    data = this.first.data;
                    continue;
                }
                while (--p >= 0) {
                    val += (data[this.offset++] & 0xFF) << m-- * 8;
                }
            }
        }
        return (short)val;
    }

    public int readInt() throws JonathanException {
        byte[] data = this.first.data;
        int val = 0;
        if (this.first.top - this.offset >= 4) {
            val = ((data[this.offset] & 0xFF) << 24) + ((data[this.offset + 1] & 0xFF) << 16) + ((data[this.offset + 2] & 0xFF) << 8) + (data[this.offset + 3] & 0xFF);
            this.offset += 4;
        } else {
            int m = 3;
            while (m >= 0) {
                int p = Math.min(m + 1, this.first.top - this.offset);
                if (p == 0) {
                    this.prepare();
                    data = this.first.data;
                    continue;
                }
                while (--p >= 0) {
                    val += (data[this.offset++] & 0xFF) << m-- * 8;
                }
            }
        }
        return val;
    }

    public float readFloat() throws JonathanException {
        byte[] data = this.first.data;
        int val = 0;
        if (this.first.top - this.offset >= 4) {
            val = ((data[this.offset] & 0xFF) << 24) + ((data[this.offset + 1] & 0xFF) << 16) + ((data[this.offset + 2] & 0xFF) << 8) + (data[this.offset + 3] & 0xFF);
            this.offset += 4;
        } else {
            int m = 3;
            while (m >= 0) {
                int p = Math.min(m + 1, this.first.top - this.offset);
                if (p == 0) {
                    this.prepare();
                    data = this.first.data;
                    continue;
                }
                while (--p >= 0) {
                    val += (data[this.offset++] & 0xFF) << m-- * 8;
                }
            }
        }
        return Float.intBitsToFloat(val);
    }

    public long readLong() throws JonathanException {
        byte[] data = this.first.data;
        long val = 0L;
        if (this.first.top - this.offset >= 8) {
            val = (((long)data[this.offset] & 0xFFL) << 56) + (((long)data[this.offset + 1] & 0xFFL) << 48) + (((long)data[this.offset + 2] & 0xFFL) << 40) + (((long)data[this.offset + 3] & 0xFFL) << 32) + (((long)data[this.offset + 4] & 0xFFL) << 24) + (((long)data[this.offset + 5] & 0xFFL) << 16) + (((long)data[this.offset + 6] & 0xFFL) << 8) + ((long)data[this.offset + 7] & 0xFFL);
            this.offset += 8;
        } else {
            int m = 7;
            while (m >= 0) {
                int p = Math.min(m + 1, this.first.top - this.offset);
                if (p == 0) {
                    this.prepare();
                    data = this.first.data;
                    continue;
                }
                while (--p >= 0) {
                    val += ((long)data[this.offset++] & 0xFFL) << m-- * 8;
                }
            }
        }
        return val;
    }

    public double readDouble() throws JonathanException {
        byte[] data = this.first.data;
        long val = 0L;
        if (this.first.top - this.offset >= 8) {
            val = (((long)data[this.offset] & 0xFFL) << 56) + (((long)data[this.offset + 1] & 0xFFL) << 48) + (((long)data[this.offset + 2] & 0xFFL) << 40) + (((long)data[this.offset + 3] & 0xFFL) << 32) + (((long)data[this.offset + 4] & 0xFFL) << 24) + (((long)data[this.offset + 5] & 0xFFL) << 16) + (((long)data[this.offset + 6] & 0xFFL) << 8) + ((long)data[this.offset + 7] & 0xFFL);
            this.offset += 8;
            return Double.longBitsToDouble(val);
        }
        int m = 7;
        while (m >= 0) {
            int p = Math.min(m + 1, this.first.top - this.offset);
            if (p == 0) {
                this.prepare();
                data = this.first.data;
                continue;
            }
            while (--p >= 0) {
                val += ((long)data[this.offset++] & 0xFFL) << m-- * 8;
            }
        }
        return Double.longBitsToDouble(val);
    }

    public String readString8() throws JonathanException {
        int len = this.readInt() - 1;
        char[] tab = new char[len];
        byte[] data = this.first.data;
        int off = 0;
        int max = this.first.top - this.offset;
        while (max < len) {
            while (off < max) {
                tab[off++] = (char)(data[this.offset++] & 0xFF);
            }
            this.prepare();
            data = this.first.data;
            max = this.first.top - this.offset + off;
        }
        while (off < len) {
            tab[off++] = (char)(data[this.offset++] & 0xFF);
        }
        if (this.first.top == this.offset) {
            this.prepare();
            ++this.offset;
        } else {
            ++this.offset;
        }
        return new String(tab);
    }

    public String readString16() throws JonathanException {
        throw new InternalException("Not implemented.");
    }

    public void readByteArray(byte[] array, int off, int len) throws JonathanException {
        byte[] data = this.first.data;
        int max = this.first.top - this.offset;
        while (max < len) {
            System.arraycopy(data, this.offset, array, off, max);
            this.offset += max;
            off += max;
            len -= max;
            this.prepare();
            data = this.first.data;
            max = this.first.top - this.offset;
        }
        System.arraycopy(data, this.offset, array, off, len);
        this.offset += len;
    }

    public Object readReference() throws JonathanException {
        try {
            this.initObjectStream();
            return this.is.readObject();
        }
        catch (Exception e) {
            System.err.println(Thread.currentThread() + " Exception " + e);
            throw new JonathanException(e);
        }
    }

    public Object readValue() throws JonathanException {
        try {
            this.initObjectStream();
            return this.is.readObject();
        }
        catch (Exception e) {
            System.err.println(Thread.currentThread() + " Exception " + e);
            throw new JonathanException(e);
        }
    }

    public int available() throws IOException {
        Chunk chunk = this.first;
        int size = chunk.top - this.offset;
        chunk = chunk.next;
        while (chunk != null) {
            size += chunk.top - chunk.offset;
            chunk = chunk.next;
        }
        return size;
    }

    public int read() throws IOException {
        try {
            if (this.first.top == this.offset) {
                this.prepare();
            }
            return this.first.data[this.offset++] & 0xFF;
        }
        catch (JonathanException e) {
            Exception f = e.represents();
            if (f instanceof EndOfMessageException) {
                return -1;
            }
            if (f instanceof IOException) {
                throw (IOException)f;
            }
            throw new IOException(f.getMessage());
        }
    }

    public int read(byte[] array, int off, int length) throws IOException {
        try {
            int toCopy;
            if (array == null) {
                return (int)this.skip(length);
            }
            for (int len = length; len > 0; len -= toCopy) {
                int available = this.first.top - this.offset;
                if (available == 0) {
                    this.prepare();
                    available = this.first.top - this.offset;
                }
                toCopy = Math.min(available, len);
                System.arraycopy(this.first.data, this.offset, array, off, toCopy);
                this.offset += toCopy;
                off += toCopy;
            }
            return length;
        }
        catch (JonathanException e) {
            Exception f = e.represents();
            if (f instanceof EndOfMessageException) {
                return -1;
            }
            if (f instanceof IOException) {
                throw (IOException)f;
            }
            throw new IOException(f.getMessage());
        }
    }

    public long skip(long n) throws IOException {
        try {
            long toSkip;
            for (long len = n; len > 0L; len -= toSkip) {
                int available = this.first.top - this.offset;
                if (available == 0) {
                    this.prepare();
                    available = this.first.top - this.offset;
                }
                toSkip = Math.min((long)available, len);
                this.offset = (int)((long)this.offset + toSkip);
            }
            return n;
        }
        catch (JonathanException e) {
            Exception f = e.represents();
            if (f instanceof EndOfMessageException) {
                return -1L;
            }
            if (f instanceof IOException) {
                throw (IOException)f;
            }
            throw new IOException(f.getMessage());
        }
    }

    public void close() {
        if (this.first != null) {
            this.first.offset = this.offset;
        }
        while (this.first != null) {
            Chunk next = this.first.next;
            this.first.release();
            this.first = next;
        }
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
        if (this.context != null) {
            this.context.release();
            this.context = null;
        }
    }

    protected void initObjectStream() throws IOException {
        if (this.is == null) {
            this.is = new RmiObjectInputStream(this, this.domain, this.contextFactory);
        }
    }

    private void prepare() throws JonathanException {
        this.lastOffset += this.offset;
        this.first.offset = this.offset;
        while (this.first != null && this.first.top == this.first.offset) {
            Chunk prev = this.first;
            this.first = this.first.next;
            prev.release();
        }
        if (this.first != null) {
            this.offset = this.first.offset;
            this.lastOffset -= this.offset;
        } else if (this.provider != null) {
            this.first = this.provider.prepare();
            this.offset = this.first.offset;
            this.lastOffset -= this.offset;
        } else {
            throw new EndOfMessageException();
        }
    }
}

