/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi.registry;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.rmi.registry.NamingServiceAttributes;

public class NamingServiceImpl
implements NamingService,
NamingServiceAttributes {
    static final String defaultPersistenceFile = "namingServiceState.bytes";
    private boolean isPersistent = false;
    private String persistenceFileName = null;
    private Map bindings = new HashMap();

    public synchronized String[] list() {
        return this.bindings.keySet().toArray(new String[this.bindings.size()]);
    }

    public synchronized Component lookup(String name) {
        return (Component)this.bindings.get(name);
    }

    public synchronized boolean bind(String name, Component comp) {
        if (!this.bindings.containsKey(name)) {
            this.bindings.put(name, comp);
            return true;
        }
        return false;
    }

    public synchronized Component rebind(String name, Component comp) {
        Component old = (Component)this.bindings.remove(name);
        this.bindings.put(name, comp);
        return old;
    }

    public synchronized Component unbind(String name) {
        return (Component)this.bindings.remove(name);
    }

    public boolean getPersistenceMode() {
        return this.isPersistent;
    }

    public synchronized void setPersistenceMode(boolean on) {
        if (on) {
            if (!this.isPersistent) {
                this.isPersistent = true;
                if (this.persistenceFileName == null) {
                    this.persistenceFileName = defaultPersistenceFile;
                }
            }
        } else if (this.isPersistent) {
            this.isPersistent = false;
            new File(this.persistenceFileName).delete();
        }
    }

    public String getPersistenceFileName() {
        return this.persistenceFileName;
    }

    public synchronized void setPersistenceFileName(String fileName) {
        if (this.isPersistent && !fileName.equals(this.persistenceFileName)) {
            new File(this.persistenceFileName).renameTo(new File(fileName));
        }
        this.persistenceFileName = fileName;
    }
}

