/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi.registry;

import java.net.InetAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.GenericFactory;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.api.type.TypeFactory;
import org.objectweb.fractal.jonathan.JContextFactory;
import org.objectweb.fractal.rmi.registry.NamingService;
import org.objectweb.fractal.util.Fractal;
import org.objectweb.jonathan.apis.binding.Identifier;
import org.objectweb.jonathan.apis.binding.NamingContext;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.JonathanException;

public class Registry {
    public static final int DEFAULT_PORT = 1234;
    public static final String URI_SCHEME = "frmi";

    private Registry() {
    }

    public static void main(String[] args) throws Exception {
        int port = 1234;
        if (args.length == 1) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Registry.createRegistry(port);
    }

    public static void createRegistry(int port) throws Exception {
        Registry.createRegistry(port, null);
    }

    public static void createRegistry(int port, Map hints) throws Exception {
        System.setSecurityManager(new SecurityManager());
        if (hints == null) {
            hints = new HashMap<String, ClassLoader>();
            hints.put("classloader", Thread.currentThread().getContextClassLoader() == null ? Registry.class.getClassLoader() : Thread.currentThread().getContextClassLoader());
        }
        Factory f = FactoryFactory.getFactory((String)"org.objectweb.fractal.adl.FractalBackend", (Map)hints);
        Component comp = (Component)f.newComponent("org.objectweb.fractal.rmi.ORB", hints);
        Fractal.getLifeCycleController((Component)comp).startFc();
        NamingContext binder = (NamingContext)comp.getFcInterface("context");
        Component boot = Fractal.getBootstrapComponent(hints);
        TypeFactory tf = Fractal.getTypeFactory((Component)boot);
        ComponentType nsType = tf.createFcType(new InterfaceType[]{tf.createFcItfType("naming service", "org.objectweb.fractal.rmi.registry.NamingService", false, false, false), tf.createFcItfType("attribute-controller", "org.objectweb.fractal.rmi.registry.NamingServiceAttributes", false, false, false)});
        GenericFactory cf = Fractal.getGenericFactory((Component)boot);
        Component nsId = cf.newFcInstance((Type)nsType, (Object)"primitive", (Object)"org.objectweb.fractal.rmi.registry.NamingServiceImpl");
        Fractal.getLifeCycleController((Component)nsId).startFc();
        Context ctxt = new JContextFactory().newContext();
        ctxt.addElement("port", Integer.class, new Integer(port), '\u0000');
        ctxt.addElement("key", Integer.class, new Integer(-1), '\u0000');
        binder.export(nsId.getFcInterface("naming service"), ctxt);
        System.out.println("Fractal registry is ready.");
    }

    public static NamingService getRegistry() throws Exception {
        String host = InetAddress.getLocalHost().getHostName();
        return Registry.getRegistry(host);
    }

    public static NamingService getRegistry(String host) throws Exception {
        return Registry.getRegistry(host, 1234);
    }

    public static NamingService getRegistry(String host, int port) throws Exception {
        Factory f = FactoryFactory.getFactory((String)"org.objectweb.fractal.adl.FractalBackend");
        Component comp = (Component)f.newComponent("org.objectweb.fractal.rmi.ORB", null);
        Fractal.getLifeCycleController((Component)comp).startFc();
        NamingContext binder = (NamingContext)comp.getFcInterface("context");
        return Registry.getRegistry(host, port, binder);
    }

    public static NamingService getRegistry(String host, NamingContext binder) throws JonathanException {
        return Registry.getRegistry(host, 1234, binder);
    }

    public static NamingService getRegistry(String host, int port, NamingContext binder) throws JonathanException {
        int len = host.length();
        byte[] b = new byte[len + 10];
        b[0] = (byte)(port >>> 24 & 0xFF);
        b[1] = (byte)(port >>> 16 & 0xFF);
        b[2] = (byte)(port >>> 8 & 0xFF);
        b[3] = (byte)(port & 0xFF);
        b[4] = (byte)(len >>> 8 & 0xFF);
        b[5] = (byte)(len & 0xFF);
        for (int i = 0; i < len; ++i) {
            b[i + 6] = (byte)host.charAt(i);
        }
        int key = -1;
        b[len + 6] = (byte)(key >>> 24 & 0xFF);
        b[len + 7] = (byte)(key >>> 16 & 0xFF);
        b[len + 8] = (byte)(key >>> 8 & 0xFF);
        b[len + 9] = (byte)(key & 0xFF);
        Identifier id = binder.decode(b, 0, b.length);
        Context hints = new JContextFactory().newContext();
        hints.addElement("interface_type", String.class, "org.objectweb.fractal.rmi.registry.NamingService", '\u0000');
        return (NamingService)id.bind(new Identifier[]{id}, hints);
    }

    public static URI newURI(String address) throws Exception {
        if (address == null) {
            address = InetAddress.getLocalHost().getHostName();
        }
        return new URI("frmi://" + address);
    }

    public static NamingService getRegistry(URI uri) throws Exception {
        int port;
        if (!URI_SCHEME.equals(uri.getScheme())) {
            throw new Exception("Invalid URI: " + uri + " instead of " + URI_SCHEME + ":" + uri.getSchemeSpecificPart());
        }
        String path = uri.getPath();
        if (path != null && !path.equals("")) {
            throw new Exception("Invalid URI: " + uri + " instead of " + URI_SCHEME + "://" + uri.getAuthority());
        }
        String host = uri.getHost();
        if (host == null || host.equals("")) {
            host = InetAddress.getLocalHost().getHostName();
        }
        if ((port = uri.getPort()) == -1) {
            port = 1234;
        }
        return Registry.getRegistry(host, port);
    }

    public static Component lookup(URI uri) throws Exception {
        return Registry.getRegistry(Registry.newURI(uri.getHost() + ':' + uri.getPort())).lookup(uri.getPath().substring(1));
    }

    public static Component lookup(String address) throws Exception {
        return Registry.lookup(Registry.newURI(address));
    }
}

