/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.rmi.stub;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.rmi.RemoteException;
import org.objectweb.jonathan.apis.binding.Identifier;
import org.objectweb.jonathan.apis.binding.Reference;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.presentation.MarshalException;
import org.objectweb.jonathan.apis.presentation.Marshaller;
import org.objectweb.jonathan.apis.presentation.MarshallerFactory;
import org.objectweb.jonathan.apis.presentation.UnMarshaller;
import org.objectweb.jonathan.apis.protocols.ReplyInterface;
import org.objectweb.jonathan.apis.protocols.ServerException;
import org.objectweb.jonathan.apis.protocols.SessionIdentifier;
import org.objectweb.jonathan.apis.protocols.Session_High;

public class Stub
implements Reference,
Interface {
    protected Identifier id;
    protected MarshallerFactory marshallerFactory;
    protected SessionIdentifier sessionId;
    protected Session_High session;

    public Identifier[] getIdentifiers() {
        return new Identifier[]{this.id};
    }

    public void setIdentifiers(Identifier[] ids) {
        this.id = ids[0];
    }

    public Component getFcItfOwner() {
        try {
            Marshaller marshaller = this.request();
            ReplyInterface reply = this.prepareInvocation(marshaller);
            marshaller.writeInt(-1);
            this.invoke(marshaller);
            UnMarshaller unmarshaller = reply.listen();
            Component result = (Component)unmarshaller.readValue();
            unmarshaller.close();
            return result;
        }
        catch (Exception e) {
            e = this.handleException(e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RemoteException("server side exception", e);
        }
    }

    public String getFcItfName() {
        try {
            Marshaller marshaller = this.request();
            ReplyInterface reply = this.prepareInvocation(marshaller);
            marshaller.writeInt(-2);
            this.invoke(marshaller);
            UnMarshaller unmarshaller = reply.listen();
            String result = (String)unmarshaller.readValue();
            unmarshaller.close();
            return result;
        }
        catch (Exception e) {
            e = this.handleException(e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RemoteException("server side exception", e);
        }
    }

    public Type getFcItfType() {
        try {
            Marshaller marshaller = this.request();
            ReplyInterface reply = this.prepareInvocation(marshaller);
            marshaller.writeInt(-3);
            this.invoke(marshaller);
            UnMarshaller unmarshaller = reply.listen();
            Type result = (Type)unmarshaller.readValue();
            unmarshaller.close();
            return result;
        }
        catch (Exception e) {
            e = this.handleException(e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RemoteException("server side exception", e);
        }
    }

    public boolean isFcInternalItf() {
        try {
            Marshaller marshaller = this.request();
            ReplyInterface reply = this.prepareInvocation(marshaller);
            marshaller.writeInt(-4);
            this.invoke(marshaller);
            UnMarshaller unmarshaller = reply.listen();
            boolean result = unmarshaller.readBoolean();
            unmarshaller.close();
            return result;
        }
        catch (Exception e) {
            e = this.handleException(e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RemoteException("server side exception", e);
        }
    }

    protected Marshaller request() throws MarshalException {
        if (this.marshallerFactory == null) {
            throw new MarshalException("null marshaller factory");
        }
        return this.marshallerFactory.newMarshaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReplyInterface prepareInvocation(Marshaller marshaller) throws MarshalException {
        try {
            Stub stub = this;
            synchronized (stub) {
                if (this.session == null) {
                    this.session = this.sessionId.bind(null);
                }
            }
            return this.session.prepareInvocation(marshaller);
        }
        catch (Exception e) {
            throw new MarshalException("exception preparing marshaller: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(Marshaller marshaller) throws MarshalException {
        try {
            Stub stub = this;
            synchronized (stub) {
                if (this.session == null) {
                    throw new MarshalException("null session");
                }
            }
            this.session.send(marshaller);
        }
        catch (Exception e) {
            throw new MarshalException("exception at invocation: " + e);
        }
    }

    protected Exception handleException(Exception e) {
        if (e instanceof ServerException) {
            try {
                UnMarshaller unmarshaller = ((ServerException)e).unmarshaller;
                Exception f = (Exception)unmarshaller.readValue();
                unmarshaller.close();
                return f;
            }
            catch (JonathanException je) {
                return new RemoteException("error during exception unmarshalling by stub", je);
            }
        }
        return new RemoteException("error during marshalling/unmarshalling by stub", e);
    }

    protected Object replaceClassName(Object o) throws ClassNotFoundException {
        Object[] desc;
        if (o instanceof String) {
            return Class.forName((String)o);
        }
        if (o instanceof Object[] && (desc = (Object[])o).length == 2 && desc[1] instanceof String) {
            return new Object[]{desc[0], Class.forName((String)desc[1])};
        }
        return o;
    }

    protected Object replaceClassValue(Object o) {
        Object[] desc;
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        if (o instanceof Object[] && (desc = (Object[])o).length == 2 && desc[1] instanceof Class) {
            return new Object[]{desc[0], ((Class)desc[1]).getName()};
        }
        return o;
    }

    public boolean equals(Object o) {
        if (o instanceof Stub) {
            return this.id.equals(((Stub)o).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected void finalize() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }
}

