/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonathan.libs.protocols.tcpip;

import java.io.IOException;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.protocols.ip.IpConnection;
import org.objectweb.jonathan.apis.resources.Chunk;
import org.objectweb.jonathan.apis.resources.ChunkProvider;
import org.objectweb.jonathan.libs.protocols.tcpip.LoggerProvider;
import org.objectweb.jonathan.libs.protocols.tcpip.TcpIpProtocol;
import org.objectweb.util.monolog.api.BasicLevel;

final class TcpIpChunkProvider
extends Chunk
implements ChunkProvider {
    static final byte[] empty_data = new byte[0];
    static final Chunk empty_chunk = new Chunk(empty_data, 0, 0);
    TcpIpProtocol.Session session;
    IpConnection connection;
    int max;
    Chunk cache;

    TcpIpChunkProvider(TcpIpProtocol.Session session) {
        super(empty_data, 0, 0);
        this.max = 0;
        this.session = session;
        this.connection = session.connection;
        this.cache = empty_chunk;
    }

    TcpIpChunkProvider(TcpIpChunkProvider message) {
        super(message.data, message.offset, message.top);
        this.cache = message.cache;
        this.max = message.max;
        this.session = message.session;
        this.connection = message.connection;
        message.cache = null;
    }

    public Chunk prepare() throws JonathanException {
        TcpIpProtocol protocol = this.session.getProtocol();
        if (this.top == this.offset) {
            try {
                int to_read = this.connection.available();
                if (to_read > 1) {
                    if (to_read > this.max - this.top) {
                        this.cache.release();
                        this.cache = protocol.chunk_factory.newChunk(to_read);
                        this.data = this.cache.data;
                        this.offset = this.cache.offset;
                        this.top = this.cache.top;
                        this.max = this.data.length;
                    }
                    this.connection.receive(this, to_read);
                    return this;
                }
                if (this.max - this.top == 0) {
                    this.cache.release();
                    this.cache = protocol.chunk_factory.newChunk();
                    this.data = this.cache.data;
                    this.offset = this.cache.offset;
                    this.top = this.cache.top;
                    this.max = this.data.length;
                }
                this.connection.receive(this, 1);
                return this;
            }
            catch (IOException e) {
                this.delete();
                this.connection.delete();
                this.connection = null;
                throw new JonathanException(e);
            }
        }
        return this;
    }

    public void close() {
        if (this.cache != null) {
            this.session.closeNotify(this);
        }
    }

    protected void finalize() {
        if (this.cache != null) {
            if (LoggerProvider.logger != null && LoggerProvider.logger.isLoggable(BasicLevel.ERROR)) {
                LoggerProvider.logger.log(BasicLevel.ERROR, (Object)"Resource management error. Message has not been properly closed.");
            }
            this.delete();
        }
    }

    final void delete() {
        if (this.cache != null) {
            this.cache.release();
            this.cache = null;
        }
        this.session.deleteNotify(this);
    }

    public Chunk duplicate() throws JonathanException {
        this.cache.top = this.top;
        return this.cache.duplicate(this.offset, this.top);
    }

    public Chunk duplicate(int off, int t) throws JonathanException {
        this.cache.top = this.top;
        return this.cache.duplicate(off, t);
    }

    public void release() {
    }
}

