/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonathan.libs.protocols.tcpip;

import java.io.IOException;
import java.util.Properties;
import org.objectweb.jonathan.apis.binding.BindException;
import org.objectweb.jonathan.apis.kernel.Context;
import org.objectweb.jonathan.apis.kernel.ContextFactory;
import org.objectweb.jonathan.apis.kernel.InternalException;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.presentation.EndOfMessageException;
import org.objectweb.jonathan.apis.presentation.Marshaller;
import org.objectweb.jonathan.apis.presentation.MarshallerFactory;
import org.objectweb.jonathan.apis.protocols.CommunicationException;
import org.objectweb.jonathan.apis.protocols.Protocol;
import org.objectweb.jonathan.apis.protocols.ProtocolGraph;
import org.objectweb.jonathan.apis.protocols.ReplyInterface;
import org.objectweb.jonathan.apis.protocols.SessionIdentifier;
import org.objectweb.jonathan.apis.protocols.Session_High;
import org.objectweb.jonathan.apis.protocols.Session_Low;
import org.objectweb.jonathan.apis.protocols.ip.IpConnection;
import org.objectweb.jonathan.apis.protocols.ip.IpSession;
import org.objectweb.jonathan.apis.protocols.ip.IpSessionIdentifier;
import org.objectweb.jonathan.apis.protocols.ip.TcpIpConnectionMgr;
import org.objectweb.jonathan.apis.protocols.ip.TcpIpSrvConnectionFactory;
import org.objectweb.jonathan.apis.resources.Chunk;
import org.objectweb.jonathan.apis.resources.ChunkFactory;
import org.objectweb.jonathan.apis.resources.Scheduler;
import org.objectweb.jonathan.libs.protocols.tcpip.LoggerProvider;
import org.objectweb.jonathan.libs.protocols.tcpip.TcpIpChunkProvider;
import org.objectweb.util.monolog.api.BasicLevel;

public class TcpIpProtocol
implements Protocol {
    protected Scheduler scheduler;
    protected ChunkFactory chunk_factory;
    protected MarshallerFactory marshaller_factory;
    protected ContextFactory context_factory;
    public boolean verbose;
    SrvSessionFactory[] srv_session_factories = new SrvSessionFactory[4];
    int num_srv_sessions = 0;
    protected TcpIpConnectionMgr connection_mgr;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public TcpIpProtocol(TcpIpConnectionMgr connection_mgr, Scheduler scheduler, ChunkFactory chunk_factory, MarshallerFactory mf, ContextFactory context_factory) {
        this.scheduler = scheduler;
        this.chunk_factory = chunk_factory;
        this.connection_mgr = connection_mgr;
        this.marshaller_factory = mf;
        this.context_factory = context_factory;
        this.verbose = false;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isAnInvocationProtocol() {
        return false;
    }

    public ProtocolGraph createProtocolGraph(ProtocolGraph[] lower, Context hints) {
        try {
            int port = (Integer)hints.getValue("port", '\u0000');
            return new TcpIpProtocolGraph(port);
        }
        catch (ClassCastException cce) {
            return new TcpIpProtocolGraph();
        }
    }

    public IpSessionIdentifier newSessionIdentifier(String host, int port) {
        return new CltSessionIdentifier(host, port);
    }

    public SessionIdentifier createSessionIdentifier(Properties info, SessionIdentifier[] next) throws JonathanException {
        String host = "";
        int port = 0;
        try {
            host = (String)info.get("hostname");
            port = (Integer)info.get("port") & 0xFFFF;
        }
        catch (ClassCastException cce) {
            throw new JonathanException("Unable to find relevant TCP/IP information (host, port)");
        }
        return new CltSessionIdentifier(host, port);
    }

    public boolean isLocal(IpSessionIdentifier tcp_session_id) {
        String hostname;
        tcp_session_id.hostname = hostname = this.connection_mgr.getCanonicalHostName(tcp_session_id.hostname);
        return this.isLocal(hostname, tcp_session_id.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLocal(String host, int port) {
        SrvSessionFactory[] srvSessionFactoryArray = this.srv_session_factories;
        synchronized (this.srv_session_factories) {
            for (int i = 0; i < this.num_srv_sessions; ++i) {
                if (this.srv_session_factories[i].session_id.port != port || !this.srv_session_factories[i].session_id.hostname.equals(host)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    void remove(SrvSessionFactory factory) {
        int i;
        for (i = 0; i < this.num_srv_sessions && this.srv_session_factories[i] != factory; ++i) {
        }
        if (i < this.num_srv_sessions) {
            --this.num_srv_sessions;
            System.arraycopy(this.srv_session_factories, i + 1, this.srv_session_factories, i, this.num_srv_sessions - i);
            this.srv_session_factories[this.num_srv_sessions] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Marshaller message, IpConnection connection) throws IOException {
        int len;
        Chunk first = message.getState();
        Chunk portion = null;
        int size = 0;
        boolean onechunk = true;
        Chunk c = first;
        while (c != null) {
            len = c.top - c.offset;
            if (len != 0) {
                if (size != 0) {
                    onechunk = false;
                } else {
                    portion = c;
                }
                size += len;
            }
            c = c.next;
        }
        if (onechunk) {
            if (portion != null) {
                if (LoggerProvider.send_logger != null && LoggerProvider.send_logger.isLoggable(BasicLevel.DEBUG)) {
                    String str = "TCP a: ";
                    for (int i = 0; i < portion.top - portion.offset; ++i) {
                        str = str + portion.data[i] + " ";
                    }
                    LoggerProvider.send_logger.log(BasicLevel.DEBUG, (Object)str);
                }
                connection.emit(portion);
            }
            message.close();
        } else {
            try {
                portion = this.chunk_factory.newChunk(size);
                int off = portion.offset;
                c = first;
                while (c != null) {
                    len = c.top - c.offset;
                    if (len > 0) {
                        System.arraycopy(c.data, c.offset, portion.data, off, len);
                        off += len;
                    }
                    c = c.next;
                }
                portion.top = off;
                if (LoggerProvider.send_logger != null && LoggerProvider.send_logger.isLoggable(BasicLevel.DEBUG)) {
                    String str = "TCP b: ";
                    for (int i = 0; i < size; ++i) {
                        str = portion.data[i] + " ";
                    }
                    LoggerProvider.send_logger.log(BasicLevel.DEBUG, (Object)str);
                }
                connection.emit(portion);
                message.close();
            }
            finally {
                portion.release();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class SrvSessionFactory
    implements Runnable {
        SrvSessionId session_id;
        Session_Low hls;
        boolean cont;
        TcpIpProtocol protocol;
        Thread runner;

        SrvSessionFactory(SrvSessionId session_id, Session_Low hls, TcpIpProtocol protocol) {
            this.hls = hls;
            this.session_id = session_id;
            this.protocol = protocol;
            this.cont = true;
        }

        SrvSessionId register(Session_Low hls, TcpIpProtocolGraph protocol_graph) {
            int port = protocol_graph.port;
            if ((port == 0 || port == this.session_id.port) && this.hls.equals(hls)) {
                return this.session_id;
            }
            return null;
        }

        public void run() {
            this.runner = Thread.currentThread();
            TcpIpSrvConnectionFactory connection_factory = this.session_id.connection_factory;
            while (this.cont) {
                try {
                    SrvSession session = new SrvSession(this.hls);
                    IpConnection connection = connection_factory.newSrvConnection(session);
                    session.connect(connection);
                }
                catch (JonathanException e) {
                    if (!this.cont) continue;
                    if (TcpIpProtocol.this.verbose) {
                        System.err.println("Stopping server socket on exception.");
                        e.printStackTrace();
                    }
                    if (LoggerProvider.bind_logger != null && LoggerProvider.bind_logger.isLoggable(BasicLevel.INFO)) {
                        LoggerProvider.bind_logger.log(BasicLevel.INFO, (Object)"Stopping server socket on exception.", (Throwable)e);
                    }
                    this.session_id.unexport();
                    TcpIpProtocol.this.remove(this);
                    this.cont = false;
                }
            }
        }

        void release() {
            this.cont = false;
            this.runner.interrupt();
            this.session_id.unexport();
            TcpIpProtocol.this.remove(this);
        }
    }

    final class CltSession
    extends Session {
        IpSessionIdentifier session_id;
        int acquired;

        CltSession(Session_Low hls, IpSessionIdentifier session_id) throws JonathanException {
            super(hls);
            this.session_id = session_id;
            this.acquired = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void send(Marshaller message) throws JonathanException {
            try {
                TcpIpProtocol.this.send(message, this.connection);
            }
            catch (IOException e) {
                try {
                    CltSession cltSession = this;
                    synchronized (cltSession) {
                        if (this.connection == null) {
                            throw new CommunicationException("Session is closed");
                        }
                        try {
                            this.rebind();
                        }
                        catch (JonathanException g) {
                            throw new BindException("Can't rebind TCP session");
                        }
                        try {
                            TcpIpProtocol.this.send(message, this.connection);
                        }
                        catch (IOException f) {
                            this.unbind();
                            throw new CommunicationException(f);
                        }
                    }
                }
                finally {
                    message.close();
                }
            }
        }

        void rebind() throws JonathanException {
            this.connection.delete();
            this.connection = null;
            String hostname = this.session_id.hostname;
            int port = this.session_id.port;
            IpConnection new_connection = TcpIpProtocol.this.connection_mgr.newCltConnection(hostname, port, this);
            this.connect(new_connection);
        }

        public final synchronized void close() {
            --this.acquired;
            if (this.acquired == 0 && this.connection != null) {
                this.connection.release();
                this.connection = null;
            }
        }

        final synchronized void acquire() {
            ++this.acquired;
        }

        public boolean equals(Object object) {
            if (object instanceof CltSession) {
                CltSession other = (CltSession)object;
                return other.session_id.equals(this.session_id) && other.hls.equals(this.hls);
            }
            return false;
        }

        public int hashCode() {
            return this.session_id.hashCode() + this.hls.hashCode();
        }
    }

    final class SrvSession
    extends Session {
        SrvSession(Session_Low hls) {
            super(hls);
        }

        public final void close() {
        }

        public final void send(Marshaller message) throws JonathanException {
            try {
                TcpIpProtocol.this.send(message, this.connection);
            }
            catch (IOException e) {
                try {
                    SrvSession srvSession = this;
                    synchronized (srvSession) {
                        if (this.connection == null) {
                            throw new CommunicationException("Session is closed");
                        }
                        this.unbind();
                        throw new CommunicationException(e);
                    }
                }
                catch (Throwable throwable) {
                    message.close();
                    throw throwable;
                }
            }
        }
    }

    abstract class Session
    implements IpSession,
    Runnable {
        IpConnection connection;
        TcpIpChunkProvider tcp_message;
        Session_Low hls;

        Session(Session_Low hls) {
            this.hls = hls;
        }

        public final void prepare(Marshaller m) {
        }

        public final ReplyInterface prepareInvocation(Marshaller m) throws JonathanException {
            throw new InternalException("TCP session don't handle invocations.");
        }

        public final boolean direct() {
            return true;
        }

        public final Session_Low getHls() {
            return this.hls;
        }

        public synchronized void connect(IpConnection connection) throws JonathanException {
            if (this.connection != null) {
                return;
            }
            this.connection = connection;
            if (this.tcp_message == null) {
                this.tcp_message = new TcpIpChunkProvider(this);
                TcpIpProtocol.this.scheduler.newJob().run(this);
            }
        }

        public final IpConnection getConnection() {
            return this.connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            TcpIpChunkProvider message = null;
            IpConnection connection = null;
            try {
                Session session = this;
                synchronized (session) {
                    if (this.connection == null) {
                        return;
                    }
                    message = this.tcp_message;
                    connection = this.connection;
                }
                this.hls.send(TcpIpProtocol.this.marshaller_factory.newUnMarshaller(message), (Session_High)this);
            }
            catch (JonathanException e) {
                Exception f;
                if (LoggerProvider.receive_logger != null && LoggerProvider.receive_logger.isLoggable(BasicLevel.INFO)) {
                    LoggerProvider.receive_logger.log(BasicLevel.INFO, (Object)"Exception caught by TcpIpProtocol.");
                }
                if ((f = e.represents()) instanceof IOException || f instanceof EndOfMessageException) {
                    Session session = this;
                    synchronized (session) {
                        if (connection == this.connection) {
                            this.unbind();
                            return;
                        }
                        message.delete();
                    }
                }
                this.hls.send(e, (Session_High)this);
            }
        }

        final synchronized void closeNotify(TcpIpChunkProvider message) {
            if (this.connection != null && message == this.tcp_message) {
                this.tcp_message = new TcpIpChunkProvider(message);
                TcpIpProtocol.this.scheduler.newJob().run(this);
            } else {
                System.out.println("connection " + this.connection + " " + message + " " + this.tcp_message);
                message.delete();
            }
        }

        final synchronized void deleteNotify(TcpIpChunkProvider message) {
            if (message == this.tcp_message) {
                this.tcp_message = null;
            }
        }

        void unbind() {
            if (this.connection != null) {
                this.connection.delete();
                this.connection = null;
            }
        }

        TcpIpProtocol getProtocol() {
            return TcpIpProtocol.this;
        }
    }

    final class SrvSessionId
    extends IpSessionIdentifier {
        TcpIpSrvConnectionFactory connection_factory;

        SrvSessionId(TcpIpSrvConnectionFactory connection_factory) {
            super(connection_factory.getHostName(), connection_factory.getPort());
            this.connection_factory = connection_factory;
        }

        public Protocol getProtocol() {
            return TcpIpProtocol.this;
        }

        public void unexport() {
            this.connection_factory.close();
        }

        public Session_High bind(Session_Low hls) throws JonathanException {
            throw new InternalException("Meaningless operation");
        }

        public Context getInfo() throws JonathanException {
            Context c = TcpIpProtocol.this.context_factory.newContext();
            c.addElement("hostname", class$java$lang$String == null ? (class$java$lang$String = TcpIpProtocol.class$("java.lang.String")) : class$java$lang$String, this.hostname, '\u0000');
            c.addElement("port", class$java$lang$Integer == null ? (class$java$lang$Integer = TcpIpProtocol.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(this.port), '\u0000');
            return c;
        }

        public boolean isLocal() {
            return TcpIpProtocol.this.isLocal(this);
        }
    }

    final class CltSessionIdentifier
    extends IpSessionIdentifier {
        CltSessionIdentifier(String hostname, int port) {
            super(hostname, port);
        }

        public Protocol getProtocol() {
            return TcpIpProtocol.this;
        }

        public void unexport() {
        }

        public Session_High bind(Session_Low hls) throws JonathanException {
            CltSession session = new CltSession(hls, this);
            IpConnection connection = TcpIpProtocol.this.connection_mgr.newCltConnection(this.hostname, this.port, session);
            session = (CltSession)connection.getSession();
            session.acquire();
            session.connect(connection);
            return session;
        }

        public Context getInfo() throws JonathanException {
            Context c = TcpIpProtocol.this.context_factory.newContext();
            c.addElement("hostname", class$java$lang$String == null ? (class$java$lang$String = TcpIpProtocol.class$("java.lang.String")) : class$java$lang$String, this.hostname, '\u0000');
            c.addElement("port", class$java$lang$Integer == null ? (class$java$lang$Integer = TcpIpProtocol.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(this.port), '\u0000');
            return c;
        }

        public boolean isLocal() {
            return TcpIpProtocol.this.isLocal(this);
        }
    }

    final class TcpIpProtocolGraph
    implements ProtocolGraph {
        int port;

        TcpIpProtocolGraph(int port) {
            this.port = port;
        }

        TcpIpProtocolGraph() {
            this(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionIdentifier export(Session_Low hls) throws JonathanException {
            SrvSessionFactory[] srvSessionFactoryArray = TcpIpProtocol.this.srv_session_factories;
            synchronized (TcpIpProtocol.this.srv_session_factories) {
                SrvSessionId session_id;
                for (int i = 0; i < TcpIpProtocol.this.num_srv_sessions; ++i) {
                    session_id = TcpIpProtocol.this.srv_session_factories[i].register(hls, this);
                    if (session_id == null) continue;
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return session_id;
                }
                TcpIpSrvConnectionFactory srv_connection_factory = TcpIpProtocol.this.connection_mgr.newSrvConnectionFactory(this.port);
                session_id = new SrvSessionId(srv_connection_factory);
                SrvSessionFactory srv_fac = new SrvSessionFactory(session_id, hls, TcpIpProtocol.this);
                TcpIpProtocol.this.scheduler.newJob().run(srv_fac);
                int len = TcpIpProtocol.this.srv_session_factories.length;
                if (TcpIpProtocol.this.num_srv_sessions == len) {
                    SrvSessionFactory[] new_srv_session_factories = new SrvSessionFactory[len + 4];
                    System.arraycopy(TcpIpProtocol.this.srv_session_factories, 0, new_srv_session_factories, 0, len);
                    TcpIpProtocol.this.srv_session_factories = new_srv_session_factories;
                }
                TcpIpProtocol.this.srv_session_factories[TcpIpProtocol.this.num_srv_sessions++] = srv_fac;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return session_id;
            }
        }
    }
}

