/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonathan.libs.resources.tcpip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.objectweb.jonathan.apis.binding.ExportException;
import org.objectweb.jonathan.apis.kernel.InternalException;
import org.objectweb.jonathan.apis.kernel.JonathanException;
import org.objectweb.jonathan.apis.protocols.ip.IpConnection;
import org.objectweb.jonathan.apis.protocols.ip.IpSession;
import org.objectweb.jonathan.apis.protocols.ip.TcpIpConnectionMgr;
import org.objectweb.jonathan.apis.protocols.ip.TcpIpSrvConnectionFactory;
import org.objectweb.jonathan.apis.resources.Chunk;
import org.objectweb.jonathan.libs.resources.tcpip.LoggerProvider;
import org.objectweb.util.monolog.api.BasicLevel;

public class IPv4ConnectionFactory
implements TcpIpConnectionMgr {
    static String default_localhost_name;
    static String default_localhost_address;
    static InetAddress default_localhost;
    InetAddress localhost;
    public String localhost_name;
    public boolean verbose;
    public boolean use_address_as_name;
    public int SO_LINGER;
    public int SO_TIMEOUT;
    public boolean TCP_NODELAY;
    public int backlog;
    int max_retries;

    public IPv4ConnectionFactory() throws JonathanException {
        this(null, false, 100, 0, true, 50, 10, true);
    }

    public IPv4ConnectionFactory(String localhost_value, boolean verbose, int SO_LINGER, int SO_TIMEOUT, boolean TCP_NODELAY, int backlog, int max_retries, boolean use_address_as_name) throws JonathanException {
        this.verbose = verbose;
        this.SO_LINGER = SO_LINGER;
        this.SO_TIMEOUT = SO_TIMEOUT;
        this.TCP_NODELAY = TCP_NODELAY;
        this.backlog = backlog;
        this.max_retries = max_retries;
        if (max_retries <= 0) {
            this.max_retries = 1;
        }
        this.use_address_as_name = use_address_as_name;
        try {
            if (localhost_value != null && (localhost_value.equals("localhost") || localhost_value.equals("127.0.0.1"))) {
                localhost_value = null;
            }
            if (localhost_value != null) {
                this.localhost = InetAddress.getByName(localhost_value);
                this.localhost_name = use_address_as_name ? this.localhost.getHostAddress() : this.localhost.getHostName();
            } else {
                this.localhost = default_localhost;
                this.localhost_name = use_address_as_name ? default_localhost_address : default_localhost_name;
            }
        }
        catch (UnknownHostException e) {
            throw new JonathanException(e);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IpConnection newCltConnection(String host, int port, IpSession session) throws JonathanException {
        try {
            if (host == null || host.equals("localhost") || host.equals("127.0.0.1")) {
                host = default_localhost_name;
            }
            if (LoggerProvider.bind_logger != null && LoggerProvider.bind_logger.isLoggable(BasicLevel.INFO)) {
                LoggerProvider.bind_logger.log(BasicLevel.INFO, (Object)("Trying to connect to " + host + " on port " + (port & 0xFFFF) + "."));
            }
            Socket socket = null;
            for (int i = 0; i < this.max_retries; ++i) {
                try {
                    socket = new Socket(host, port & 0xFFFF);
                    break;
                }
                catch (ConnectException e) {
                    if (i == this.max_retries - 1) {
                        throw new JonathanException(e);
                    }
                    if (LoggerProvider.bind_logger == null || !LoggerProvider.bind_logger.isLoggable(BasicLevel.INFO)) continue;
                    LoggerProvider.bind_logger.log(BasicLevel.INFO, (Object)("Re-trying to connect to " + host + " on port " + (port & 0xFFFF) + "."));
                    continue;
                }
            }
            if (this.SO_LINGER >= 0) {
                socket.setSoLinger(true, this.SO_LINGER);
            }
            if (this.SO_TIMEOUT >= 0) {
                socket.setSoTimeout(this.SO_TIMEOUT);
            }
            socket.setTcpNoDelay(this.TCP_NODELAY);
            port = socket.getPort() & 0xFFFF;
            if (LoggerProvider.bind_logger != null && LoggerProvider.bind_logger.isLoggable(BasicLevel.INFO)) {
                LoggerProvider.bind_logger.log(BasicLevel.INFO, (Object)("Connected to " + socket));
            }
            return new Connection(socket, session, host, port);
        }
        catch (IOException e) {
            throw new JonathanException(e);
        }
    }

    public TcpIpSrvConnectionFactory newSrvConnectionFactory(int port) throws JonathanException {
        return new SrvConnectionFactory(this.localhost, port, this.backlog);
    }

    public String getCanonicalHostName(String hostname) {
        if (hostname != null && hostname.length() > 0) {
            if (this.use_address_as_name) {
                if (!Character.isDigit(hostname.charAt(0))) {
                    if (hostname.equals("localhost")) {
                        return default_localhost_address;
                    }
                    try {
                        return InetAddress.getByName(hostname).getHostAddress();
                    }
                    catch (Exception ignored) {
                    }
                } else if (hostname.equals("127.0.0.1")) {
                    return default_localhost_address;
                }
            } else if (Character.isDigit(hostname.charAt(0))) {
                if (hostname.equals("127.0.0.1")) {
                    return default_localhost_name;
                }
                try {
                    return InetAddress.getByName(hostname).getHostName();
                }
                catch (Exception exception) {
                }
            } else if (hostname.equals("localhost")) {
                return default_localhost_name;
            }
        }
        return hostname;
    }

    protected Connection newSrvConnection(Socket socket, IpSession session, String host, int port) throws JonathanException {
        return new Connection(socket, session, host, port);
    }

    static {
        block6: {
            default_localhost = null;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements() && (default_localhost == null || default_localhost.isLoopbackAddress())) {
                    Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                    while (addresses.hasMoreElements() && (default_localhost == null || default_localhost.isLoopbackAddress())) {
                        InetAddress address = addresses.nextElement();
                        if (address instanceof Inet6Address) continue;
                        default_localhost = address;
                    }
                }
                if (default_localhost == null) {
                    default_localhost = InetAddress.getByName(null);
                }
            }
            catch (Exception ignored) {
                if (LoggerProvider.logger == null || !LoggerProvider.logger.isLoggable(BasicLevel.WARN)) break block6;
                LoggerProvider.logger.log(BasicLevel.WARN, (Object)"Could not determine local host address.");
            }
        }
        if (default_localhost != null) {
            default_localhost_name = default_localhost.getHostName();
            default_localhost_address = default_localhost.getHostAddress();
        }
    }

    class SrvConnectionFactory
    implements TcpIpSrvConnectionFactory {
        int port;
        String hostname;
        ServerSocket server_socket;

        SrvConnectionFactory(InetAddress localhost, int port, int backlog) throws JonathanException {
            block4: {
                this.hostname = IPv4ConnectionFactory.this.use_address_as_name ? localhost.getHostAddress() : localhost.getHostName();
                try {
                    this.server_socket = new ServerSocket(port & 0xFFFF, backlog, localhost);
                    if (this.server_socket != null) {
                        this.port = this.server_socket.getLocalPort() & 0xFFFF;
                        if (LoggerProvider.export_logger != null && LoggerProvider.export_logger.isLoggable(BasicLevel.INFO)) {
                            LoggerProvider.export_logger.log(BasicLevel.INFO, (Object)("Opened a server connection on host " + this.hostname + " on port " + (this.port & 0xFFFF)));
                        }
                        break block4;
                    }
                    throw new ExportException("Can't create server socket.");
                }
                catch (IOException e) {
                    throw new ExportException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IpConnection newSrvConnection(IpSession session) throws JonathanException {
            try {
                ServerSocket current = null;
                SrvConnectionFactory srvConnectionFactory = this;
                synchronized (srvConnectionFactory) {
                    if (this.server_socket == null) {
                        throw new ExportException("Server Connection Factory has been closed");
                    }
                    current = this.server_socket;
                }
                Socket socket = current.accept();
                if (IPv4ConnectionFactory.this.SO_LINGER >= 0) {
                    socket.setSoLinger(true, IPv4ConnectionFactory.this.SO_LINGER);
                }
                if (IPv4ConnectionFactory.this.SO_TIMEOUT >= 0) {
                    socket.setSoTimeout(IPv4ConnectionFactory.this.SO_TIMEOUT);
                }
                socket.setTcpNoDelay(IPv4ConnectionFactory.this.TCP_NODELAY);
                int port = socket.getPort() & 0xFFFF;
                String hostname = socket.getInetAddress().getHostName();
                if (LoggerProvider.bind_logger != null && LoggerProvider.bind_logger.isLoggable(BasicLevel.INFO)) {
                    LoggerProvider.bind_logger.log(BasicLevel.INFO, (Object)("Accepted connection with host: " + hostname + " on port: " + port));
                }
                return IPv4ConnectionFactory.this.newSrvConnection(socket, session, hostname, port);
            }
            catch (IOException e) {
                throw new ExportException(e);
            }
        }

        public int getPort() {
            return this.port;
        }

        public String getHostName() {
            return this.hostname;
        }

        public synchronized void close() {
            if (this.server_socket != null) {
                try {
                    this.server_socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.server_socket = null;
            }
        }
    }

    class Connection
    implements IpConnection {
        Socket socket;
        String host;
        int port;
        InputStream is;
        OutputStream os;
        IpSession session;

        protected Connection(Socket socket, IpSession session, String host, int port) throws JonathanException {
            if (socket != null) {
                try {
                    this.is = socket.getInputStream();
                    this.os = socket.getOutputStream();
                }
                catch (IOException e) {
                    try {
                        socket.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw new JonathanException(e);
                }
            }
            throw new InternalException("Null socket to create connection");
            this.socket = socket;
            this.session = session;
            this.host = host;
            this.port = port;
        }

        public int available() throws IOException {
            return this.is.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void emit(Chunk c) throws IOException {
            OutputStream outputStream = this.os;
            synchronized (outputStream) {
                if (LoggerProvider.send_logger != null && LoggerProvider.send_logger.isLoggable(BasicLevel.DEBUG)) {
                    byte[] data = c.data;
                    int len = c.top - c.offset;
                    String str = "OUT: ";
                    for (int i = c.offset; i < len; ++i) {
                        str = str + data[i] + " ";
                    }
                    LoggerProvider.send_logger.log(BasicLevel.DEBUG, (Object)str);
                }
                this.os.write(c.data, c.offset, c.top);
            }
        }

        public void receive(Chunk c, int sz) throws IOException {
            byte[] data = c.data;
            int top = c.top;
            while (sz > 0) {
                int a = this.is.read(data, top, sz);
                if (LoggerProvider.receive_logger != null && LoggerProvider.receive_logger.isLoggable(BasicLevel.DEBUG)) {
                    String str = "IN: ";
                    for (int i = top; i < top + sz; ++i) {
                        str = str + data[i] + " ";
                    }
                    LoggerProvider.receive_logger.log(BasicLevel.DEBUG, (Object)str);
                }
                if (a > 0) {
                    top += a;
                    sz -= a;
                    continue;
                }
                throw new EOFException();
            }
            c.top = top;
        }

        public int getPort() {
            return this.port;
        }

        public String getHostName() {
            return this.host;
        }

        public IpSession getSession() {
            return this.session;
        }

        public void setSession(IpSession session) {
            this.session = session;
        }

        public synchronized void delete() {
            if (this.socket != null) {
                try {
                    if (LoggerProvider.logger != null && LoggerProvider.logger.isLoggable(BasicLevel.INFO)) {
                        LoggerProvider.logger.log(BasicLevel.INFO, (Object)("Connection with host " + this.host + " on port " + (this.port & 0xFFFF) + " closed."));
                    }
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket = null;
                this.session = null;
            }
        }

        public void release() {
            this.delete();
        }

        public String toString() {
            return "IPv4Connection[" + this.socket + "]";
        }
    }
}

