/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.context.lib;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.context.api.ContextParser;
import org.objectweb.util.explorer.context.api.ContextPropertiesFeeder;
import org.objectweb.util.explorer.contextConfig.Context;
import org.objectweb.util.explorer.contextConfig.ContextImpl;
import org.objectweb.util.explorer.contextConfig.Decoder;
import org.objectweb.util.explorer.contextConfig.Decoders;
import org.objectweb.util.explorer.core.common.lib.BindingFeature;
import org.objectweb.util.explorer.core.common.lib.ClassResolver;

public class Parser
extends BindingFeature
implements ContextParser {
    static /* synthetic */ Class class$org$objectweb$util$explorer$context$api$Decoder;

    protected InputStream getInputStream(String resource) {
        InputStream inputStream = ClassResolver.getResourceAsStream(resource);
        if (inputStream == null) {
            try {
                inputStream = new URL(resource).openStream();
            }
            catch (MalformedURLException e) {
                try {
                    inputStream = new FileInputStream(resource);
                }
                catch (FileNotFoundException e1) {
                    this.getTrace().info(resource + ": File not found on the file system!");
                    return null;
                }
            }
            catch (IOException e) {
                this.getTrace().info(resource + ": Failed to open stream on resource!");
                return null;
            }
        }
        return inputStream;
    }

    protected void buildDecoder(Decoders decoders) {
        if (decoders != null) {
            List decoderList = decoders.getDecoderList();
            Iterator it = decoderList.iterator();
            while (it.hasNext()) {
                Decoder decoderNode = (Decoder)it.next();
                String className = decoderNode.getJavaClass();
                try {
                    Class c = ClassResolver.resolve(className);
                    if (c == null || !(class$org$objectweb$util$explorer$context$api$Decoder == null ? Parser.class$("org.objectweb.util.explorer.context.api.Decoder") : class$org$objectweb$util$explorer$context$api$Decoder).isAssignableFrom(c)) continue;
                    this.getPropertiesFeeder().addDecoder((org.objectweb.util.explorer.context.api.Decoder)c.newInstance());
                }
                catch (ClassNotFoundException e) {
                    this.getTrace().warn(className + " : Class not found !");
                }
                catch (Exception e) {
                    this.getTrace().warn(className + " : Class not found !");
                }
            }
        }
    }

    protected void parse(InputStream inputStream) {
        if (inputStream != null) {
            try {
                Context context = ContextImpl.unmarshal(new InputStreamReader(inputStream), false);
                if (context != null) {
                    this.buildDecoder(context.getDecoders());
                }
            }
            catch (IOException e) {
                this.getTrace().info("Error during parsing!\n" + e.getMessage());
            }
        }
    }

    protected ContextPropertiesFeeder getPropertiesFeeder() {
        try {
            return (ContextPropertiesFeeder)this.lookupFc("context-properties-feeder");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("context-properties-feeder: interface not found!");
            return null;
        }
    }

    public String[] clientFc() {
        return new String[]{"context-properties-feeder"};
    }

    public void parse(String fileUrl) {
        if (fileUrl != null && !fileUrl.equals("")) {
            this.parse(this.getInputStream(fileUrl));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

