/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.core.code.lib;

import org.objectweb.util.explorer.ExplorerUtils;
import org.objectweb.util.explorer.core.code.api.Code;
import org.objectweb.util.explorer.core.code.api.CodeConfiguration;
import org.objectweb.util.explorer.core.common.lib.ClassResolver;
import org.objectweb.util.trace.TraceSystem;

public class JavaCode
implements CodeConfiguration,
Code {
    protected Class theClass_ = null;

    protected boolean equals(JavaCode code) {
        if (code != null) {
            Class codeClass = code.theClass_;
            if (this.theClass_ != null && codeClass != null) {
                return this.theClass_.getName().equals(codeClass.getName());
            }
        }
        return false;
    }

    public void setCode(String code) {
        try {
            this.theClass_ = ClassResolver.resolve(code);
        }
        catch (ClassNotFoundException e) {
            TraceSystem.get((String)"explorer").info(code + ": Class not found!");
        }
    }

    public boolean isInstanceOf(Class c) {
        if (c != null && this.theClass_ != null) {
            return c.isAssignableFrom(this.theClass_);
        }
        return false;
    }

    public Object createInstance() {
        if (this.theClass_ != null) {
            try {
                return this.theClass_.newInstance();
            }
            catch (InstantiationException e) {
                TraceSystem.get((String)"explorer").info(e.getMessage());
            }
            catch (IllegalAccessException e) {
                TraceSystem.get((String)"explorer").info(e.getMessage());
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof JavaCode) {
            return this.equals((JavaCode)o);
        }
        return false;
    }

    public String toString() {
        return "JavaCode[class=" + ExplorerUtils.toString(this.theClass_) + "]";
    }
}

