/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.core.common.lib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ClassesInheritance {
    protected List classes_ = new Vector();

    public ClassesInheritance(Class theClass) {
        if (theClass != null) {
            this.build(theClass);
        }
    }

    protected Class getClass(String className) {
        Iterator it = this.classes_.iterator();
        while (it.hasNext()) {
            Class c = (Class)it.next();
            if (!className.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    protected void buildClass(Class c) {
        if (c != null) {
            this.classes_.add(c);
        }
    }

    protected void buildInterfaces(Class[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            Class oldClass = this.getClass(interfaces[i].getName());
            if (oldClass != null) {
                this.classes_.remove(oldClass);
            }
            this.classes_.add(interfaces[i]);
        }
        Vector allExtendedInterfaces = new Vector();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?>[] extendedInterfaces = interfaces[i].getInterfaces();
            for (int j = 0; j < extendedInterfaces.length; ++j) {
                allExtendedInterfaces.add(extendedInterfaces[j]);
            }
        }
        if (allExtendedInterfaces.size() != 0) {
            this.buildInterfaces(allExtendedInterfaces.toArray(new Class[0]));
        }
    }

    protected void build(Class c) {
        if (c != null) {
            this.buildClass(c);
            this.buildInterfaces(c.getInterfaces());
            this.build(c.getSuperclass());
        }
    }

    public List getInheritClasses() {
        return this.classes_;
    }

    public static Class[] getInheritedClasses(Class c) {
        return new ClassesInheritance(c).getInheritClasses().toArray(new Class[0]);
    }

    public static void main(String[] args) {
        ClassesInheritance ci = new ClassesInheritance(new ArrayList().getClass());
        List list = ci.getInheritClasses();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            System.out.println("=> " + it.next());
        }
    }
}

