/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.core.role.lib;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.objectweb.util.explorer.ExplorerUtils;
import org.objectweb.util.explorer.core.common.lib.BindingFeature;
import org.objectweb.util.explorer.core.role.api.Role;
import org.objectweb.util.explorer.core.role.api.RoleDescription;
import org.objectweb.util.explorer.core.role.api.RoleFeeder;
import org.objectweb.util.explorer.core.role.api.RoleManager;
import org.objectweb.util.explorer.core.role.api.RoleProvider;
import org.objectweb.util.explorer.core.role.lib.DefaultRole;

public class RoleProperty
extends BindingFeature
implements RoleFeeder,
RoleProvider,
RoleManager {
    protected Map roleMap_ = null;
    protected Map inheritedRolesMap_ = null;
    protected String[] currentRoleIds_ = new String[]{"_Default_Role_"};

    public RoleProperty() {
        this.roleMap_ = new HashMap();
        this.inheritedRolesMap_ = new HashMap();
    }

    protected void buildInheritedRolesList(String[] roleIds, Vector roleIdsList) {
        for (int i = 0; i < roleIds.length; ++i) {
            if (roleIdsList.contains(roleIds[i])) continue;
            roleIdsList.add(roleIds[i]);
        }
        Vector<String> allExtendedRoleIds = new Vector<String>();
        for (int i = 0; i < roleIds.length; ++i) {
            String[] inheritedRoles = (String[])this.inheritedRolesMap_.get(roleIds[i]);
            String roleId = null;
            if (inheritedRoles == null) continue;
            for (int j = 0; j < inheritedRoles.length; ++j) {
                roleId = inheritedRoles[j];
                if (!this.roleMap_.containsKey(roleId) || roleIdsList.contains(roleId)) continue;
                allExtendedRoleIds.add(roleId);
            }
        }
        if (allExtendedRoleIds.size() != 0) {
            this.buildInheritedRolesList(allExtendedRoleIds.toArray(new String[allExtendedRoleIds.size()]), roleIdsList);
        }
    }

    protected String[] provideInheritedRoleIds(String[] roleIds) {
        Vector<String> roleList = new Vector<String>();
        this.buildInheritedRolesList(roleIds, roleList);
        if (!roleList.contains("_Default_Role_")) {
            roleList.add("_Default_Role_");
        }
        return roleList.toArray(new String[roleList.size()]);
    }

    protected void mergeInheritedRoles(String roleId, RoleDescription roleDesc) {
        String[] currentInheritedRoles = (String[])this.inheritedRolesMap_.get(roleId);
        String[] inheritedRolesToAdd = roleDesc.getInheritance();
        this.inheritedRolesMap_.put(roleId, ExplorerUtils.mergeArrays(currentInheritedRoles, inheritedRolesToAdd));
    }

    protected void mergeRole(Role currentRole, RoleDescription roleDesc) {
        if (!roleDesc.isConcrete()) {
            currentRole.setConcrete(false);
        }
    }

    protected void storeRoleDesc(RoleDescription roleDesc) {
        DefaultRole theRole = null;
        String roleId = roleDesc.getId();
        if (this.roleMap_.containsKey(roleId)) {
            this.mergeRole((Role)this.roleMap_.get(roleId), roleDesc);
            this.mergeInheritedRoles(roleId, roleDesc);
        } else {
            theRole = new DefaultRole(roleId);
            theRole.setConcrete(roleDesc.isConcrete());
            this.roleMap_.put(roleId, theRole);
            this.inheritedRolesMap_.put(roleId, roleDesc.getInheritance() != null ? roleDesc.getInheritance() : new String[]{});
        }
    }

    protected void fixCurrentRoleIds(String[] roleIds) {
        this.currentRoleIds_ = roleIds != null ? roleIds : new String[0];
    }

    public String[] clientFc() {
        return new String[]{"role-feeder", "role-provider"};
    }

    public void feed(RoleDescription roleDesc) {
        this.storeRoleDesc(roleDesc);
    }

    public Role getRole(String id) {
        return (Role)this.roleMap_.get(id);
    }

    public String[] getRoleIds(Role[] roles) {
        String[] roleIds = new String[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            roleIds[i] = roles[i].getId();
        }
        return roleIds;
    }

    public Role[] getRoles(String[] roleIds) {
        Vector<Role> v = new Vector<Role>();
        Role r = null;
        for (int i = 0; i < roleIds.length; ++i) {
            r = this.getRole(roleIds[i]);
            if (r == null) continue;
            v.add(r);
        }
        return v.toArray(new Role[v.size()]);
    }

    public String[] getInheritedRoleIds(String[] roleIds) {
        return this.provideInheritedRoleIds(roleIds);
    }

    public Role getDefaultRole() {
        return (Role)this.roleMap_.get("_Default_Role_");
    }

    public String[] getRoleList() {
        return this.getRoleList(false);
    }

    public String[] getRoleList(boolean alphabeticOrder) {
        return this.getRoleList(false, false);
    }

    public String[] getRoleList(boolean alphabeticOrder, boolean excludedAbstractRoles) {
        String[] roleIds = this.roleMap_.keySet().toArray(new String[this.roleMap_.size()]);
        if (alphabeticOrder) {
            Arrays.sort(roleIds, new RoleComparator());
        }
        if (excludedAbstractRoles) {
            Vector<String> l = new Vector<String>();
            for (int i = 0; i < roleIds.length; ++i) {
                if (!this.getRole(roleIds[i]).isConcrete()) continue;
                l.add(roleIds[i]);
            }
            return l.toArray(new String[l.size()]);
        }
        return roleIds;
    }

    public String[] getCurrentRoleIds() {
        return this.currentRoleIds_;
    }

    public void setCurrentRoleIds(String[] roleIds) {
        this.fixCurrentRoleIds(roleIds);
    }

    private final class RoleComparator
    implements Comparator {
        private RoleComparator() {
        }

        protected int compare(String id1, String id2) {
            return id1.compareTo(id2);
        }

        public int compare(Object o1, Object o2) {
            return this.compare((String)o1, (String)o2);
        }
    }
}

