/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.explorerConfig;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.objectweb.util.explorer.explorerConfig.Accelerator;
import org.objectweb.util.explorer.explorerConfig.Unmarshallable;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class AcceleratorImpl
extends DefaultHandler
implements Cloneable,
Unmarshallable,
LexicalHandler,
Accelerator {
    private String shift = "false";
    private static boolean zeus_ShiftInitialized;
    private static Vector zeus_validShift;
    private boolean zeus_ShiftSet;
    private String xmlchar;
    private boolean zeus_XmlcharSet;
    private String ctrl;
    private static boolean zeus_CtrlInitialized;
    private static Vector zeus_validCtrl;
    private boolean zeus_CtrlSet;
    private String meta;
    private static boolean zeus_MetaInitialized;
    private static Vector zeus_validMeta;
    private boolean zeus_MetaSet;
    private String alt;
    private static boolean zeus_AltInitialized;
    private static Vector zeus_validAlt;
    private boolean zeus_AltSet;
    private String docTypeString;
    private String outputEncoding;
    private Unmarshallable zeus_currentUNode;
    private Unmarshallable zeus_parentUNode;
    private boolean zeus_thisNodeHandled = false;
    private boolean hasDTD;
    private boolean validate;
    private Map namespaceMappings;
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;
    private static AcceleratorImpl prototype;

    public static void setPrototype(AcceleratorImpl prototype) {
        AcceleratorImpl.prototype = prototype;
    }

    public static AcceleratorImpl newInstance() {
        try {
            return prototype != null ? (AcceleratorImpl)prototype.clone() : new AcceleratorImpl();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public AcceleratorImpl() {
        zeus_ShiftInitialized = false;
        zeus_validShift = null;
        this.zeus_ShiftSet = false;
        this.zeus_XmlcharSet = false;
        this.ctrl = "false";
        zeus_CtrlInitialized = false;
        zeus_validCtrl = null;
        this.zeus_CtrlSet = false;
        this.meta = "false";
        zeus_MetaInitialized = false;
        zeus_validMeta = null;
        this.zeus_MetaSet = false;
        this.alt = "false";
        zeus_AltInitialized = false;
        zeus_validAlt = null;
        this.zeus_AltSet = false;
        this.docTypeString = "";
        this.hasDTD = false;
        this.validate = false;
        this.namespaceMappings = new HashMap();
    }

    public String getShift() {
        return this.shift;
    }

    public void setShift(String shift) throws IllegalArgumentException {
        if (!zeus_ShiftInitialized) {
            zeus_validShift = new Vector();
            zeus_validShift.addElement("true");
            zeus_validShift.addElement("false");
            zeus_ShiftInitialized = true;
        }
        if (!zeus_validShift.contains(shift)) {
            throw new IllegalArgumentException("Illegal value for attribute 'shift'");
        }
        this.shift = shift;
        this.zeus_ShiftSet = true;
    }

    public String getXmlchar() {
        return this.xmlchar;
    }

    public void setXmlchar(String xmlchar) {
        this.xmlchar = xmlchar;
        this.zeus_XmlcharSet = true;
    }

    public String getCtrl() {
        return this.ctrl;
    }

    public void setCtrl(String ctrl) throws IllegalArgumentException {
        if (!zeus_CtrlInitialized) {
            zeus_validCtrl = new Vector();
            zeus_validCtrl.addElement("true");
            zeus_validCtrl.addElement("false");
            zeus_CtrlInitialized = true;
        }
        if (!zeus_validCtrl.contains(ctrl)) {
            throw new IllegalArgumentException("Illegal value for attribute 'ctrl'");
        }
        this.ctrl = ctrl;
        this.zeus_CtrlSet = true;
    }

    public String getMeta() {
        return this.meta;
    }

    public void setMeta(String meta) throws IllegalArgumentException {
        if (!zeus_MetaInitialized) {
            zeus_validMeta = new Vector();
            zeus_validMeta.addElement("true");
            zeus_validMeta.addElement("false");
            zeus_MetaInitialized = true;
        }
        if (!zeus_validMeta.contains(meta)) {
            throw new IllegalArgumentException("Illegal value for attribute 'meta'");
        }
        this.meta = meta;
        this.zeus_MetaSet = true;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String alt) throws IllegalArgumentException {
        if (!zeus_AltInitialized) {
            zeus_validAlt = new Vector();
            zeus_validAlt.addElement("true");
            zeus_validAlt.addElement("false");
            zeus_AltInitialized = true;
        }
        if (!zeus_validAlt.contains(alt)) {
            throw new IllegalArgumentException("Illegal value for attribute 'alt'");
        }
        this.alt = alt;
        this.zeus_AltSet = true;
    }

    public void setDocType(String name, String publicID, String systemID) {
        try {
            this.startDTD(name, publicID, systemID);
        }
        catch (SAXException neverHappens) {
            // empty catch block
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void marshal(File file) throws IOException {
        this.marshal(new FileWriter(file));
    }

    public void marshal(OutputStream outputStream) throws IOException {
        this.marshal(new OutputStreamWriter(outputStream));
    }

    public void marshal(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ");
        if (this.outputEncoding != null) {
            writer.write("encoding=\"");
            writer.write(this.outputEncoding);
            writer.write("\"?>\n\n");
        } else {
            writer.write("encoding=\"UTF-8\"?>\n\n");
        }
        writer.write(this.docTypeString);
        writer.write("\n");
        this.writeXMLRepresentation(writer, "");
        writer.flush();
        writer.close();
    }

    protected void writeXMLRepresentation(Writer writer, String indent) throws IOException {
        writer.write(indent);
        writer.write("<accelerator");
        Iterator i = this.namespaceMappings.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = (String)this.namespaceMappings.get(prefix);
            writer.write(" xmlns");
            if (!prefix.trim().equals("")) {
                writer.write(":");
                writer.write(prefix);
            }
            writer.write("=\"");
            writer.write(uri);
            writer.write("\"\n        ");
        }
        if (this.zeus_ShiftSet) {
            writer.write(" shift=\"");
            writer.write(this.escapeAttributeValue(this.shift));
            writer.write("\"");
        }
        if (this.zeus_XmlcharSet) {
            writer.write(" char=\"");
            writer.write(this.escapeAttributeValue(this.xmlchar));
            writer.write("\"");
        }
        if (this.zeus_CtrlSet) {
            writer.write(" ctrl=\"");
            writer.write(this.escapeAttributeValue(this.ctrl));
            writer.write("\"");
        }
        if (this.zeus_MetaSet) {
            writer.write(" meta=\"");
            writer.write(this.escapeAttributeValue(this.meta));
            writer.write("\"");
        }
        if (this.zeus_AltSet) {
            writer.write(" alt=\"");
            writer.write(this.escapeAttributeValue(this.alt));
            writer.write("\"");
        }
        writer.write("/>\n");
    }

    private String escapeAttributeValue(String attributeValue) {
        String returnValue = attributeValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch != '\"') continue;
            returnValue = returnValue.substring(0, i) + "&quot;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    private String escapeTextValue(String textValue) {
        String returnValue = textValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch == '<') {
                returnValue = returnValue.substring(0, i) + "&lt;" + returnValue.substring(i + 1);
                continue;
            }
            if (ch != '>') continue;
            returnValue = returnValue.substring(0, i) + "&gt;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public static void setErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }

    public static Accelerator unmarshal(File file) throws IOException {
        return AcceleratorImpl.unmarshal(new FileReader(file));
    }

    public static Accelerator unmarshal(File file, boolean validate) throws IOException {
        return AcceleratorImpl.unmarshal(new FileReader(file), validate);
    }

    public static Accelerator unmarshal(InputStream inputStream) throws IOException {
        return AcceleratorImpl.unmarshal(new InputStreamReader(inputStream));
    }

    public static Accelerator unmarshal(InputStream inputStream, boolean validate) throws IOException {
        return AcceleratorImpl.unmarshal(new InputStreamReader(inputStream), validate);
    }

    public static Accelerator unmarshal(Reader reader) throws IOException {
        return AcceleratorImpl.unmarshal(reader, false);
    }

    public static Accelerator unmarshal(Reader reader, boolean validate) throws IOException {
        AcceleratorImpl accelerator = AcceleratorImpl.newInstance();
        accelerator.setValidating(validate);
        accelerator.setCurrentUNode(accelerator);
        accelerator.setParentUNode(null);
        XMLReader parser = null;
        String parserClass = System.getProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        try {
            parser = XMLReaderFactory.createXMLReader(parserClass);
            if (entityResolver != null) {
                parser.setEntityResolver(entityResolver);
            }
            parser.setErrorHandler(accelerator);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", accelerator);
            parser.setContentHandler(accelerator);
        }
        catch (SAXException e) {
            throw new IOException("Could not load XML parser: " + e.getMessage());
        }
        InputSource inputSource = new InputSource(reader);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", new Boolean(validate));
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing XML document: " + e.getMessage());
        }
        return accelerator;
    }

    public Unmarshallable getParentUNode() {
        return this.zeus_parentUNode;
    }

    public void setParentUNode(Unmarshallable parentUNode) {
        this.zeus_parentUNode = parentUNode;
    }

    public Unmarshallable getCurrentUNode() {
        return this.zeus_currentUNode;
    }

    public void setCurrentUNode(Unmarshallable currentUNode) {
        this.zeus_currentUNode = currentUNode;
    }

    public void setValidating(boolean validate) {
        this.validate = validate;
    }

    public void startDocument() throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceMappings.put(prefix, uri);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (localName.equals("accelerator") && !this.zeus_thisNodeHandled) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                if (attName.equals("shift")) {
                    this.setShift(attValue);
                }
                if (attName.equals("char")) {
                    this.setXmlchar(attValue);
                }
                if (attName.equals("ctrl")) {
                    this.setCtrl(attValue);
                }
                if (attName.equals("meta")) {
                    this.setMeta(attValue);
                }
                if (!attName.equals("alt")) continue;
                this.setAlt(attValue);
            }
            this.zeus_thisNodeHandled = true;
            return;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.endElement(namespaceURI, localName, qName);
            return;
        }
        Unmarshallable parent = this.getCurrentUNode().getParentUNode();
        if (parent != null) {
            parent.setCurrentUNode(parent);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.characters(ch, start, len);
            return;
        }
        String text = new String(ch, start, len);
        text = text.trim();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
        if (errorHandler != null) {
            errorHandler.warning(e);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.error(e);
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.fatalError(e);
        }
    }

    public void startDTD(String name, String publicID, String systemID) throws SAXException {
        if (name == null || name.equals("")) {
            this.docTypeString = "";
            return;
        }
        this.hasDTD = true;
        StringBuffer docTypeSB = new StringBuffer();
        boolean hasPublic = false;
        docTypeSB.append("<!DOCTYPE ").append(name);
        if (publicID != null && !publicID.equals("")) {
            docTypeSB.append(" PUBLIC \"").append(publicID).append("\"");
            hasPublic = true;
        }
        if (systemID != null && !systemID.equals("")) {
            if (!hasPublic) {
                docTypeSB.append(" SYSTEM");
            }
            docTypeSB.append(" \"").append(systemID).append("\"");
        }
        docTypeSB.append(">");
        this.docTypeString = docTypeSB.toString();
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    static {
        prototype = null;
    }
}

