/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.explorerConfig;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.util.explorer.explorerConfig.Explorer;
import org.objectweb.util.explorer.explorerConfig.Include;
import org.objectweb.util.explorer.explorerConfig.IncludeImpl;
import org.objectweb.util.explorer.explorerConfig.Jar;
import org.objectweb.util.explorer.explorerConfig.JarImpl;
import org.objectweb.util.explorer.explorerConfig.Menu;
import org.objectweb.util.explorer.explorerConfig.MenuImpl;
import org.objectweb.util.explorer.explorerConfig.Node;
import org.objectweb.util.explorer.explorerConfig.NodeImpl;
import org.objectweb.util.explorer.explorerConfig.Role;
import org.objectweb.util.explorer.explorerConfig.RoleImpl;
import org.objectweb.util.explorer.explorerConfig.Root;
import org.objectweb.util.explorer.explorerConfig.RootImpl;
import org.objectweb.util.explorer.explorerConfig.TypeSystem;
import org.objectweb.util.explorer.explorerConfig.TypeSystemImpl;
import org.objectweb.util.explorer.explorerConfig.Unmarshallable;
import org.objectweb.util.explorer.explorerConfig.Zip;
import org.objectweb.util.explorer.explorerConfig.ZipImpl;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExplorerImpl
extends DefaultHandler
implements Cloneable,
Unmarshallable,
LexicalHandler,
Explorer {
    private Root root;
    private List menuList = new LinkedList();
    private List zipList = new LinkedList();
    private List jarList = new LinkedList();
    private List includeList = new LinkedList();
    private List nodeList = new LinkedList();
    private List typeSystemList = new LinkedList();
    private List roleList = new LinkedList();
    private String docTypeString = "";
    private String outputEncoding;
    private Unmarshallable zeus_currentUNode;
    private Unmarshallable zeus_parentUNode;
    private boolean zeus_thisNodeHandled = false;
    private boolean hasDTD = false;
    private boolean validate = false;
    private Map namespaceMappings = new HashMap();
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;
    private static ExplorerImpl prototype;

    public static void setPrototype(ExplorerImpl prototype) {
        ExplorerImpl.prototype = prototype;
    }

    public static ExplorerImpl newInstance() {
        try {
            return prototype != null ? (ExplorerImpl)prototype.clone() : new ExplorerImpl();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Root getRoot() {
        return this.root;
    }

    public void setRoot(Root root) {
        this.root = root;
    }

    public List getMenuList() {
        return this.menuList;
    }

    public void setMenuList(List menuList) {
        this.menuList = menuList;
    }

    public void addMenu(Menu menu) {
        this.menuList.add(menu);
    }

    public void removeMenu(Menu menu) {
        this.menuList.remove(menu);
    }

    public List getZipList() {
        return this.zipList;
    }

    public void setZipList(List zipList) {
        this.zipList = zipList;
    }

    public void addZip(Zip zip) {
        this.zipList.add(zip);
    }

    public void removeZip(Zip zip) {
        this.zipList.remove(zip);
    }

    public List getJarList() {
        return this.jarList;
    }

    public void setJarList(List jarList) {
        this.jarList = jarList;
    }

    public void addJar(Jar jar) {
        this.jarList.add(jar);
    }

    public void removeJar(Jar jar) {
        this.jarList.remove(jar);
    }

    public List getIncludeList() {
        return this.includeList;
    }

    public void setIncludeList(List includeList) {
        this.includeList = includeList;
    }

    public void addInclude(Include include) {
        this.includeList.add(include);
    }

    public void removeInclude(Include include) {
        this.includeList.remove(include);
    }

    public List getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(List nodeList) {
        this.nodeList = nodeList;
    }

    public void addNode(Node node) {
        this.nodeList.add(node);
    }

    public void removeNode(Node node) {
        this.nodeList.remove(node);
    }

    public List getTypeSystemList() {
        return this.typeSystemList;
    }

    public void setTypeSystemList(List typeSystemList) {
        this.typeSystemList = typeSystemList;
    }

    public void addTypeSystem(TypeSystem typeSystem) {
        this.typeSystemList.add(typeSystem);
    }

    public void removeTypeSystem(TypeSystem typeSystem) {
        this.typeSystemList.remove(typeSystem);
    }

    public List getRoleList() {
        return this.roleList;
    }

    public void setRoleList(List roleList) {
        this.roleList = roleList;
    }

    public void addRole(Role role) {
        this.roleList.add(role);
    }

    public void removeRole(Role role) {
        this.roleList.remove(role);
    }

    public void setDocType(String name, String publicID, String systemID) {
        try {
            this.startDTD(name, publicID, systemID);
        }
        catch (SAXException neverHappens) {
            // empty catch block
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void marshal(File file) throws IOException {
        this.marshal(new FileWriter(file));
    }

    public void marshal(OutputStream outputStream) throws IOException {
        this.marshal(new OutputStreamWriter(outputStream));
    }

    public void marshal(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ");
        if (this.outputEncoding != null) {
            writer.write("encoding=\"");
            writer.write(this.outputEncoding);
            writer.write("\"?>\n\n");
        } else {
            writer.write("encoding=\"UTF-8\"?>\n\n");
        }
        writer.write(this.docTypeString);
        writer.write("\n");
        this.writeXMLRepresentation(writer, "");
        writer.flush();
        writer.close();
    }

    protected void writeXMLRepresentation(Writer writer, String indent) throws IOException {
        writer.write(indent);
        writer.write("<explorer");
        Iterator<Object> i = this.namespaceMappings.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = (String)this.namespaceMappings.get(prefix);
            writer.write(" xmlns");
            if (!prefix.trim().equals("")) {
                writer.write(":");
                writer.write(prefix);
            }
            writer.write("=\"");
            writer.write(uri);
            writer.write("\"\n        ");
        }
        writer.write(">");
        writer.write("\n");
        if (this.root != null) {
            ((RootImpl)this.root).writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.menuList.iterator();
        while (i.hasNext()) {
            MenuImpl menu = (MenuImpl)i.next();
            menu.writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.zipList.iterator();
        while (i.hasNext()) {
            ZipImpl zip = (ZipImpl)i.next();
            zip.writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.jarList.iterator();
        while (i.hasNext()) {
            JarImpl jar = (JarImpl)i.next();
            jar.writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.includeList.iterator();
        while (i.hasNext()) {
            IncludeImpl include = (IncludeImpl)i.next();
            include.writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.nodeList.iterator();
        while (i.hasNext()) {
            NodeImpl node = (NodeImpl)i.next();
            node.writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.typeSystemList.iterator();
        while (i.hasNext()) {
            TypeSystemImpl typeSystem = (TypeSystemImpl)i.next();
            typeSystem.writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.roleList.iterator();
        while (i.hasNext()) {
            RoleImpl role = (RoleImpl)i.next();
            role.writeXMLRepresentation(writer, indent + "  ");
        }
        writer.write(indent);
        writer.write("</explorer>\n");
    }

    private String escapeAttributeValue(String attributeValue) {
        String returnValue = attributeValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch != '\"') continue;
            returnValue = returnValue.substring(0, i) + "&quot;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    private String escapeTextValue(String textValue) {
        String returnValue = textValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch == '<') {
                returnValue = returnValue.substring(0, i) + "&lt;" + returnValue.substring(i + 1);
                continue;
            }
            if (ch != '>') continue;
            returnValue = returnValue.substring(0, i) + "&gt;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public static void setErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }

    public static Explorer unmarshal(File file) throws IOException {
        return ExplorerImpl.unmarshal(new FileReader(file));
    }

    public static Explorer unmarshal(File file, boolean validate) throws IOException {
        return ExplorerImpl.unmarshal(new FileReader(file), validate);
    }

    public static Explorer unmarshal(InputStream inputStream) throws IOException {
        return ExplorerImpl.unmarshal(new InputStreamReader(inputStream));
    }

    public static Explorer unmarshal(InputStream inputStream, boolean validate) throws IOException {
        return ExplorerImpl.unmarshal(new InputStreamReader(inputStream), validate);
    }

    public static Explorer unmarshal(Reader reader) throws IOException {
        return ExplorerImpl.unmarshal(reader, false);
    }

    public static Explorer unmarshal(Reader reader, boolean validate) throws IOException {
        ExplorerImpl explorer = ExplorerImpl.newInstance();
        explorer.setValidating(validate);
        explorer.setCurrentUNode(explorer);
        explorer.setParentUNode(null);
        XMLReader parser = null;
        String parserClass = System.getProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        try {
            parser = XMLReaderFactory.createXMLReader(parserClass);
            if (entityResolver != null) {
                parser.setEntityResolver(entityResolver);
            }
            parser.setErrorHandler(explorer);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", explorer);
            parser.setContentHandler(explorer);
        }
        catch (SAXException e) {
            throw new IOException("Could not load XML parser: " + e.getMessage());
        }
        InputSource inputSource = new InputSource(reader);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", new Boolean(validate));
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing XML document: " + e.getMessage());
        }
        return explorer;
    }

    public Unmarshallable getParentUNode() {
        return this.zeus_parentUNode;
    }

    public void setParentUNode(Unmarshallable parentUNode) {
        this.zeus_parentUNode = parentUNode;
    }

    public Unmarshallable getCurrentUNode() {
        return this.zeus_currentUNode;
    }

    public void setCurrentUNode(Unmarshallable currentUNode) {
        this.zeus_currentUNode = currentUNode;
    }

    public void setValidating(boolean validate) {
        this.validate = validate;
    }

    public void startDocument() throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceMappings.put(prefix, uri);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (localName.equals("explorer") && !this.zeus_thisNodeHandled) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
            }
            this.zeus_thisNodeHandled = true;
            return;
        }
        if (localName.equals("root") && this.root == null) {
            RootImpl root = RootImpl.newInstance();
            current = this.getCurrentUNode();
            root.setParentUNode(current);
            root.setCurrentUNode(root);
            this.setCurrentUNode(root);
            root.startElement(namespaceURI, localName, qName, atts);
            this.root = root;
            return;
        }
        if (localName.equals("menu")) {
            MenuImpl menu = MenuImpl.newInstance();
            current = this.getCurrentUNode();
            menu.setParentUNode(current);
            menu.setCurrentUNode(menu);
            this.setCurrentUNode(menu);
            menu.startElement(namespaceURI, localName, qName, atts);
            this.menuList.add(menu);
            return;
        }
        if (localName.equals("zip")) {
            ZipImpl zip = ZipImpl.newInstance();
            current = this.getCurrentUNode();
            zip.setParentUNode(current);
            zip.setCurrentUNode(zip);
            this.setCurrentUNode(zip);
            zip.startElement(namespaceURI, localName, qName, atts);
            this.zipList.add(zip);
            return;
        }
        if (localName.equals("jar")) {
            JarImpl jar = JarImpl.newInstance();
            current = this.getCurrentUNode();
            jar.setParentUNode(current);
            jar.setCurrentUNode(jar);
            this.setCurrentUNode(jar);
            jar.startElement(namespaceURI, localName, qName, atts);
            this.jarList.add(jar);
            return;
        }
        if (localName.equals("include")) {
            IncludeImpl include = IncludeImpl.newInstance();
            current = this.getCurrentUNode();
            include.setParentUNode(current);
            include.setCurrentUNode(include);
            this.setCurrentUNode(include);
            include.startElement(namespaceURI, localName, qName, atts);
            this.includeList.add(include);
            return;
        }
        if (localName.equals("node")) {
            NodeImpl node = NodeImpl.newInstance();
            current = this.getCurrentUNode();
            node.setParentUNode(current);
            node.setCurrentUNode(node);
            this.setCurrentUNode(node);
            node.startElement(namespaceURI, localName, qName, atts);
            this.nodeList.add(node);
            return;
        }
        if (localName.equals("type-system")) {
            TypeSystemImpl typeSystem = TypeSystemImpl.newInstance();
            current = this.getCurrentUNode();
            typeSystem.setParentUNode(current);
            typeSystem.setCurrentUNode(typeSystem);
            this.setCurrentUNode(typeSystem);
            typeSystem.startElement(namespaceURI, localName, qName, atts);
            this.typeSystemList.add(typeSystem);
            return;
        }
        if (localName.equals("role")) {
            RoleImpl role = RoleImpl.newInstance();
            current = this.getCurrentUNode();
            role.setParentUNode(current);
            role.setCurrentUNode(role);
            this.setCurrentUNode(role);
            role.startElement(namespaceURI, localName, qName, atts);
            this.roleList.add(role);
            return;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.endElement(namespaceURI, localName, qName);
            return;
        }
        Unmarshallable parent = this.getCurrentUNode().getParentUNode();
        if (parent != null) {
            parent.setCurrentUNode(parent);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.characters(ch, start, len);
            return;
        }
        String text = new String(ch, start, len);
        text = text.trim();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
        if (errorHandler != null) {
            errorHandler.warning(e);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.error(e);
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.fatalError(e);
        }
    }

    public void startDTD(String name, String publicID, String systemID) throws SAXException {
        if (name == null || name.equals("")) {
            this.docTypeString = "";
            return;
        }
        this.hasDTD = true;
        StringBuffer docTypeSB = new StringBuffer();
        boolean hasPublic = false;
        docTypeSB.append("<!DOCTYPE ").append(name);
        if (publicID != null && !publicID.equals("")) {
            docTypeSB.append(" PUBLIC \"").append(publicID).append("\"");
            hasPublic = true;
        }
        if (systemID != null && !systemID.equals("")) {
            if (!hasPublic) {
                docTypeSB.append(" SYSTEM");
            }
            docTypeSB.append(" \"").append(systemID).append("\"");
        }
        docTypeSB.append(">");
        this.docTypeString = docTypeSB.toString();
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    static {
        prototype = null;
    }
}

