/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.explorerConfig;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.objectweb.util.explorer.explorerConfig.Explorer;
import org.objectweb.util.explorer.explorerConfig.ExplorerDefaultErrorHandler;
import org.objectweb.util.explorer.explorerConfig.ExplorerImpl;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class ExplorerUnmarshaller {
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public static void setErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }

    public static Explorer unmarshal(File file) throws IOException {
        return ExplorerUnmarshaller.unmarshal(new FileReader(file));
    }

    public static Explorer unmarshal(File file, boolean validate) throws IOException {
        return ExplorerUnmarshaller.unmarshal(new FileReader(file), validate);
    }

    public static Explorer unmarshal(InputStream inputStream) throws IOException {
        return ExplorerUnmarshaller.unmarshal(new InputStreamReader(inputStream));
    }

    public static Explorer unmarshal(InputStream inputStream, boolean validate) throws IOException {
        return ExplorerUnmarshaller.unmarshal(new InputStreamReader(inputStream), validate);
    }

    public static Explorer unmarshal(Reader reader) throws IOException {
        String property = System.getProperty("org.enhydra.zeus.validation", "false");
        boolean validationState = false;
        if (property.equalsIgnoreCase("true")) {
            validationState = true;
        }
        return ExplorerUnmarshaller.unmarshal(reader, validationState);
    }

    public static Explorer unmarshal(Reader reader, boolean validate) throws IOException {
        if (entityResolver != null) {
            ExplorerImpl.setEntityResolver(entityResolver);
        }
        if (errorHandler != null) {
            ExplorerImpl.setErrorHandler(errorHandler);
        } else if (validate) {
            ExplorerImpl.setErrorHandler(new ExplorerDefaultErrorHandler());
        }
        return ExplorerImpl.unmarshal(reader, validate);
    }
}

