/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.explorerConfig;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.objectweb.util.explorer.explorerConfig.Item;
import org.objectweb.util.explorer.explorerConfig.ItemImpl;
import org.objectweb.util.explorer.explorerConfig.Menu;
import org.objectweb.util.explorer.explorerConfig.Mnemonic;
import org.objectweb.util.explorer.explorerConfig.MnemonicImpl;
import org.objectweb.util.explorer.explorerConfig.Separator;
import org.objectweb.util.explorer.explorerConfig.SeparatorImpl;
import org.objectweb.util.explorer.explorerConfig.Unmarshallable;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class MenuImpl
extends DefaultHandler
implements Cloneable,
Unmarshallable,
LexicalHandler,
Menu {
    private Mnemonic mnemonic;
    private List itemList = new LinkedList();
    private List separatorList = new LinkedList();
    private String label;
    private boolean zeus_LabelSet = false;
    private String inheritTypeMenu = "true";
    private static boolean zeus_InheritTypeMenuInitialized;
    private static Vector zeus_validInheritTypeMenu;
    private boolean zeus_InheritTypeMenuSet;
    private String inheritTreeMenu;
    private static boolean zeus_InheritTreeMenuInitialized;
    private static Vector zeus_validInheritTreeMenu;
    private boolean zeus_InheritTreeMenuSet;
    private String docTypeString;
    private String outputEncoding;
    private Unmarshallable zeus_currentUNode;
    private Unmarshallable zeus_parentUNode;
    private boolean zeus_thisNodeHandled = false;
    private boolean hasDTD;
    private boolean validate;
    private Map namespaceMappings;
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;
    private static MenuImpl prototype;

    public static void setPrototype(MenuImpl prototype) {
        MenuImpl.prototype = prototype;
    }

    public static MenuImpl newInstance() {
        try {
            return prototype != null ? (MenuImpl)prototype.clone() : new MenuImpl();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public MenuImpl() {
        zeus_InheritTypeMenuInitialized = false;
        zeus_validInheritTypeMenu = null;
        this.zeus_InheritTypeMenuSet = false;
        this.inheritTreeMenu = "true";
        zeus_InheritTreeMenuInitialized = false;
        zeus_validInheritTreeMenu = null;
        this.zeus_InheritTreeMenuSet = false;
        this.docTypeString = "";
        this.hasDTD = false;
        this.validate = false;
        this.namespaceMappings = new HashMap();
    }

    public Mnemonic getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(Mnemonic mnemonic) {
        this.mnemonic = mnemonic;
    }

    public List getItemList() {
        return this.itemList;
    }

    public void setItemList(List itemList) {
        this.itemList = itemList;
    }

    public void addItem(Item item) {
        this.itemList.add(item);
    }

    public void removeItem(Item item) {
        this.itemList.remove(item);
    }

    public List getSeparatorList() {
        return this.separatorList;
    }

    public void setSeparatorList(List separatorList) {
        this.separatorList = separatorList;
    }

    public void addSeparator(Separator separator) {
        this.separatorList.add(separator);
    }

    public void removeSeparator(Separator separator) {
        this.separatorList.remove(separator);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.zeus_LabelSet = true;
    }

    public String getInheritTypeMenu() {
        return this.inheritTypeMenu;
    }

    public void setInheritTypeMenu(String inheritTypeMenu) throws IllegalArgumentException {
        if (!zeus_InheritTypeMenuInitialized) {
            zeus_validInheritTypeMenu = new Vector();
            zeus_validInheritTypeMenu.addElement("true");
            zeus_validInheritTypeMenu.addElement("false");
            zeus_InheritTypeMenuInitialized = true;
        }
        if (!zeus_validInheritTypeMenu.contains(inheritTypeMenu)) {
            throw new IllegalArgumentException("Illegal value for attribute 'inheritTypeMenu'");
        }
        this.inheritTypeMenu = inheritTypeMenu;
        this.zeus_InheritTypeMenuSet = true;
    }

    public String getInheritTreeMenu() {
        return this.inheritTreeMenu;
    }

    public void setInheritTreeMenu(String inheritTreeMenu) throws IllegalArgumentException {
        if (!zeus_InheritTreeMenuInitialized) {
            zeus_validInheritTreeMenu = new Vector();
            zeus_validInheritTreeMenu.addElement("true");
            zeus_validInheritTreeMenu.addElement("false");
            zeus_InheritTreeMenuInitialized = true;
        }
        if (!zeus_validInheritTreeMenu.contains(inheritTreeMenu)) {
            throw new IllegalArgumentException("Illegal value for attribute 'inheritTreeMenu'");
        }
        this.inheritTreeMenu = inheritTreeMenu;
        this.zeus_InheritTreeMenuSet = true;
    }

    public void setDocType(String name, String publicID, String systemID) {
        try {
            this.startDTD(name, publicID, systemID);
        }
        catch (SAXException neverHappens) {
            // empty catch block
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void marshal(File file) throws IOException {
        this.marshal(new FileWriter(file));
    }

    public void marshal(OutputStream outputStream) throws IOException {
        this.marshal(new OutputStreamWriter(outputStream));
    }

    public void marshal(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ");
        if (this.outputEncoding != null) {
            writer.write("encoding=\"");
            writer.write(this.outputEncoding);
            writer.write("\"?>\n\n");
        } else {
            writer.write("encoding=\"UTF-8\"?>\n\n");
        }
        writer.write(this.docTypeString);
        writer.write("\n");
        this.writeXMLRepresentation(writer, "");
        writer.flush();
        writer.close();
    }

    protected void writeXMLRepresentation(Writer writer, String indent) throws IOException {
        writer.write(indent);
        writer.write("<menu");
        Iterator<Object> i = this.namespaceMappings.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = (String)this.namespaceMappings.get(prefix);
            writer.write(" xmlns");
            if (!prefix.trim().equals("")) {
                writer.write(":");
                writer.write(prefix);
            }
            writer.write("=\"");
            writer.write(uri);
            writer.write("\"\n        ");
        }
        if (this.zeus_LabelSet) {
            writer.write(" label=\"");
            writer.write(this.escapeAttributeValue(this.label));
            writer.write("\"");
        }
        if (this.zeus_InheritTypeMenuSet) {
            writer.write(" inherit-type-menu=\"");
            writer.write(this.escapeAttributeValue(this.inheritTypeMenu));
            writer.write("\"");
        }
        if (this.zeus_InheritTreeMenuSet) {
            writer.write(" inherit-tree-menu=\"");
            writer.write(this.escapeAttributeValue(this.inheritTreeMenu));
            writer.write("\"");
        }
        writer.write(">");
        writer.write("\n");
        if (this.mnemonic != null) {
            ((MnemonicImpl)this.mnemonic).writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.itemList.iterator();
        while (i.hasNext()) {
            ItemImpl item = (ItemImpl)i.next();
            item.writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.separatorList.iterator();
        while (i.hasNext()) {
            SeparatorImpl separator = (SeparatorImpl)i.next();
            separator.writeXMLRepresentation(writer, indent + "  ");
        }
        writer.write(indent);
        writer.write("</menu>\n");
    }

    private String escapeAttributeValue(String attributeValue) {
        String returnValue = attributeValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch != '\"') continue;
            returnValue = returnValue.substring(0, i) + "&quot;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    private String escapeTextValue(String textValue) {
        String returnValue = textValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch == '<') {
                returnValue = returnValue.substring(0, i) + "&lt;" + returnValue.substring(i + 1);
                continue;
            }
            if (ch != '>') continue;
            returnValue = returnValue.substring(0, i) + "&gt;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public static void setErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }

    public static Menu unmarshal(File file) throws IOException {
        return MenuImpl.unmarshal(new FileReader(file));
    }

    public static Menu unmarshal(File file, boolean validate) throws IOException {
        return MenuImpl.unmarshal(new FileReader(file), validate);
    }

    public static Menu unmarshal(InputStream inputStream) throws IOException {
        return MenuImpl.unmarshal(new InputStreamReader(inputStream));
    }

    public static Menu unmarshal(InputStream inputStream, boolean validate) throws IOException {
        return MenuImpl.unmarshal(new InputStreamReader(inputStream), validate);
    }

    public static Menu unmarshal(Reader reader) throws IOException {
        return MenuImpl.unmarshal(reader, false);
    }

    public static Menu unmarshal(Reader reader, boolean validate) throws IOException {
        MenuImpl menu = MenuImpl.newInstance();
        menu.setValidating(validate);
        menu.setCurrentUNode(menu);
        menu.setParentUNode(null);
        XMLReader parser = null;
        String parserClass = System.getProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        try {
            parser = XMLReaderFactory.createXMLReader(parserClass);
            if (entityResolver != null) {
                parser.setEntityResolver(entityResolver);
            }
            parser.setErrorHandler(menu);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", menu);
            parser.setContentHandler(menu);
        }
        catch (SAXException e) {
            throw new IOException("Could not load XML parser: " + e.getMessage());
        }
        InputSource inputSource = new InputSource(reader);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", new Boolean(validate));
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing XML document: " + e.getMessage());
        }
        return menu;
    }

    public Unmarshallable getParentUNode() {
        return this.zeus_parentUNode;
    }

    public void setParentUNode(Unmarshallable parentUNode) {
        this.zeus_parentUNode = parentUNode;
    }

    public Unmarshallable getCurrentUNode() {
        return this.zeus_currentUNode;
    }

    public void setCurrentUNode(Unmarshallable currentUNode) {
        this.zeus_currentUNode = currentUNode;
    }

    public void setValidating(boolean validate) {
        this.validate = validate;
    }

    public void startDocument() throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceMappings.put(prefix, uri);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (localName.equals("menu") && !this.zeus_thisNodeHandled) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                if (attName.equals("label")) {
                    this.setLabel(attValue);
                }
                if (attName.equals("inherit-type-menu")) {
                    this.setInheritTypeMenu(attValue);
                }
                if (!attName.equals("inherit-tree-menu")) continue;
                this.setInheritTreeMenu(attValue);
            }
            this.zeus_thisNodeHandled = true;
            return;
        }
        if (localName.equals("mnemonic") && this.mnemonic == null) {
            MnemonicImpl mnemonic = MnemonicImpl.newInstance();
            current = this.getCurrentUNode();
            mnemonic.setParentUNode(current);
            mnemonic.setCurrentUNode(mnemonic);
            this.setCurrentUNode(mnemonic);
            mnemonic.startElement(namespaceURI, localName, qName, atts);
            this.mnemonic = mnemonic;
            return;
        }
        if (localName.equals("item")) {
            ItemImpl item = ItemImpl.newInstance();
            current = this.getCurrentUNode();
            item.setParentUNode(current);
            item.setCurrentUNode(item);
            this.setCurrentUNode(item);
            item.startElement(namespaceURI, localName, qName, atts);
            this.itemList.add(item);
            return;
        }
        if (localName.equals("separator")) {
            SeparatorImpl separator = SeparatorImpl.newInstance();
            current = this.getCurrentUNode();
            separator.setParentUNode(current);
            separator.setCurrentUNode(separator);
            this.setCurrentUNode(separator);
            separator.startElement(namespaceURI, localName, qName, atts);
            this.separatorList.add(separator);
            return;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.endElement(namespaceURI, localName, qName);
            return;
        }
        Unmarshallable parent = this.getCurrentUNode().getParentUNode();
        if (parent != null) {
            parent.setCurrentUNode(parent);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.characters(ch, start, len);
            return;
        }
        String text = new String(ch, start, len);
        text = text.trim();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
        if (errorHandler != null) {
            errorHandler.warning(e);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.error(e);
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.fatalError(e);
        }
    }

    public void startDTD(String name, String publicID, String systemID) throws SAXException {
        if (name == null || name.equals("")) {
            this.docTypeString = "";
            return;
        }
        this.hasDTD = true;
        StringBuffer docTypeSB = new StringBuffer();
        boolean hasPublic = false;
        docTypeSB.append("<!DOCTYPE ").append(name);
        if (publicID != null && !publicID.equals("")) {
            docTypeSB.append(" PUBLIC \"").append(publicID).append("\"");
            hasPublic = true;
        }
        if (systemID != null && !systemID.equals("")) {
            if (!hasPublic) {
                docTypeSB.append(" SYSTEM");
            }
            docTypeSB.append(" \"").append(systemID).append("\"");
        }
        docTypeSB.append(">");
        this.docTypeString = docTypeSB.toString();
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    static {
        prototype = null;
    }
}

