/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.explorerConfig;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.util.explorer.explorerConfig.DropAction;
import org.objectweb.util.explorer.explorerConfig.DropActionImpl;
import org.objectweb.util.explorer.explorerConfig.Icon;
import org.objectweb.util.explorer.explorerConfig.IconImpl;
import org.objectweb.util.explorer.explorerConfig.Info;
import org.objectweb.util.explorer.explorerConfig.InfoImpl;
import org.objectweb.util.explorer.explorerConfig.Jar;
import org.objectweb.util.explorer.explorerConfig.JarImpl;
import org.objectweb.util.explorer.explorerConfig.Menu;
import org.objectweb.util.explorer.explorerConfig.MenuImpl;
import org.objectweb.util.explorer.explorerConfig.Node;
import org.objectweb.util.explorer.explorerConfig.Panel;
import org.objectweb.util.explorer.explorerConfig.PanelImpl;
import org.objectweb.util.explorer.explorerConfig.Unmarshallable;
import org.objectweb.util.explorer.explorerConfig.Wrapper;
import org.objectweb.util.explorer.explorerConfig.WrapperImpl;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class NodeImpl
extends DefaultHandler
implements Cloneable,
Unmarshallable,
LexicalHandler,
Node {
    private List jarList = new LinkedList();
    private Wrapper wrapper;
    private Panel panel;
    private Icon icon;
    private Menu menu;
    private List dropActionList = new LinkedList();
    private Info info;
    private String typeName;
    private boolean zeus_TypeNameSet = false;
    private static final String typeSystem = "Java";
    private boolean zeus_TypeSystemSet = true;
    private String docTypeString = "";
    private String outputEncoding;
    private Unmarshallable zeus_currentUNode;
    private Unmarshallable zeus_parentUNode;
    private boolean zeus_thisNodeHandled = false;
    private boolean hasDTD = false;
    private boolean validate = false;
    private Map namespaceMappings = new HashMap();
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;
    private static NodeImpl prototype;

    public static void setPrototype(NodeImpl prototype) {
        NodeImpl.prototype = prototype;
    }

    public static NodeImpl newInstance() {
        try {
            return prototype != null ? (NodeImpl)prototype.clone() : new NodeImpl();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public List getJarList() {
        return this.jarList;
    }

    public void setJarList(List jarList) {
        this.jarList = jarList;
    }

    public void addJar(Jar jar) {
        this.jarList.add(jar);
    }

    public void removeJar(Jar jar) {
        this.jarList.remove(jar);
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public Panel getPanel() {
        return this.panel;
    }

    public void setPanel(Panel panel) {
        this.panel = panel;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public List getDropActionList() {
        return this.dropActionList;
    }

    public void setDropActionList(List dropActionList) {
        this.dropActionList = dropActionList;
    }

    public void addDropAction(DropAction dropAction) {
        this.dropActionList.add(dropAction);
    }

    public void removeDropAction(DropAction dropAction) {
        this.dropActionList.remove(dropAction);
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
        this.zeus_TypeNameSet = true;
    }

    public String getTypeSystem() {
        return typeSystem;
    }

    public void setDocType(String name, String publicID, String systemID) {
        try {
            this.startDTD(name, publicID, systemID);
        }
        catch (SAXException neverHappens) {
            // empty catch block
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void marshal(File file) throws IOException {
        this.marshal(new FileWriter(file));
    }

    public void marshal(OutputStream outputStream) throws IOException {
        this.marshal(new OutputStreamWriter(outputStream));
    }

    public void marshal(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ");
        if (this.outputEncoding != null) {
            writer.write("encoding=\"");
            writer.write(this.outputEncoding);
            writer.write("\"?>\n\n");
        } else {
            writer.write("encoding=\"UTF-8\"?>\n\n");
        }
        writer.write(this.docTypeString);
        writer.write("\n");
        this.writeXMLRepresentation(writer, "");
        writer.flush();
        writer.close();
    }

    protected void writeXMLRepresentation(Writer writer, String indent) throws IOException {
        writer.write(indent);
        writer.write("<node");
        Iterator<Object> i = this.namespaceMappings.keySet().iterator();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            String uri = (String)this.namespaceMappings.get(prefix);
            writer.write(" xmlns");
            if (!prefix.trim().equals("")) {
                writer.write(":");
                writer.write(prefix);
            }
            writer.write("=\"");
            writer.write(uri);
            writer.write("\"\n        ");
        }
        if (this.zeus_TypeNameSet) {
            writer.write(" type-name=\"");
            writer.write(this.escapeAttributeValue(this.typeName));
            writer.write("\"");
        }
        if (this.zeus_TypeSystemSet) {
            writer.write(" type-system=\"");
            writer.write(this.escapeAttributeValue(typeSystem));
            writer.write("\"");
        }
        writer.write(">");
        writer.write("\n");
        i = this.jarList.iterator();
        while (i.hasNext()) {
            JarImpl jar = (JarImpl)i.next();
            jar.writeXMLRepresentation(writer, indent + "  ");
        }
        if (this.wrapper != null) {
            ((WrapperImpl)this.wrapper).writeXMLRepresentation(writer, indent + "  ");
        }
        if (this.panel != null) {
            ((PanelImpl)this.panel).writeXMLRepresentation(writer, indent + "  ");
        }
        if (this.icon != null) {
            ((IconImpl)this.icon).writeXMLRepresentation(writer, indent + "  ");
        }
        if (this.menu != null) {
            ((MenuImpl)this.menu).writeXMLRepresentation(writer, indent + "  ");
        }
        i = this.dropActionList.iterator();
        while (i.hasNext()) {
            DropActionImpl dropAction = (DropActionImpl)i.next();
            dropAction.writeXMLRepresentation(writer, indent + "  ");
        }
        if (this.info != null) {
            ((InfoImpl)this.info).writeXMLRepresentation(writer, indent + "  ");
        }
        writer.write(indent);
        writer.write("</node>\n");
    }

    private String escapeAttributeValue(String attributeValue) {
        String returnValue = attributeValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch != '\"') continue;
            returnValue = returnValue.substring(0, i) + "&quot;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    private String escapeTextValue(String textValue) {
        String returnValue = textValue;
        for (int i = 0; i < returnValue.length(); ++i) {
            char ch = returnValue.charAt(i);
            if (ch == '<') {
                returnValue = returnValue.substring(0, i) + "&lt;" + returnValue.substring(i + 1);
                continue;
            }
            if (ch != '>') continue;
            returnValue = returnValue.substring(0, i) + "&gt;" + returnValue.substring(i + 1);
        }
        return returnValue;
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public static void setErrorHandler(ErrorHandler handler) {
        errorHandler = handler;
    }

    public static Node unmarshal(File file) throws IOException {
        return NodeImpl.unmarshal(new FileReader(file));
    }

    public static Node unmarshal(File file, boolean validate) throws IOException {
        return NodeImpl.unmarshal(new FileReader(file), validate);
    }

    public static Node unmarshal(InputStream inputStream) throws IOException {
        return NodeImpl.unmarshal(new InputStreamReader(inputStream));
    }

    public static Node unmarshal(InputStream inputStream, boolean validate) throws IOException {
        return NodeImpl.unmarshal(new InputStreamReader(inputStream), validate);
    }

    public static Node unmarshal(Reader reader) throws IOException {
        return NodeImpl.unmarshal(reader, false);
    }

    public static Node unmarshal(Reader reader, boolean validate) throws IOException {
        NodeImpl node = NodeImpl.newInstance();
        node.setValidating(validate);
        node.setCurrentUNode(node);
        node.setParentUNode(null);
        XMLReader parser = null;
        String parserClass = System.getProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        try {
            parser = XMLReaderFactory.createXMLReader(parserClass);
            if (entityResolver != null) {
                parser.setEntityResolver(entityResolver);
            }
            parser.setErrorHandler(node);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", node);
            parser.setContentHandler(node);
        }
        catch (SAXException e) {
            throw new IOException("Could not load XML parser: " + e.getMessage());
        }
        InputSource inputSource = new InputSource(reader);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", new Boolean(validate));
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing XML document: " + e.getMessage());
        }
        return node;
    }

    public Unmarshallable getParentUNode() {
        return this.zeus_parentUNode;
    }

    public void setParentUNode(Unmarshallable parentUNode) {
        this.zeus_parentUNode = parentUNode;
    }

    public Unmarshallable getCurrentUNode() {
        return this.zeus_currentUNode;
    }

    public void setCurrentUNode(Unmarshallable currentUNode) {
        this.zeus_currentUNode = currentUNode;
    }

    public void setValidating(boolean validate) {
        this.validate = validate;
    }

    public void startDocument() throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceMappings.put(prefix, uri);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (localName.equals("node") && !this.zeus_thisNodeHandled) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                if (!attName.equals("type-name")) continue;
                this.setTypeName(attValue);
            }
            this.zeus_thisNodeHandled = true;
            return;
        }
        if (localName.equals("jar")) {
            JarImpl jar = JarImpl.newInstance();
            current = this.getCurrentUNode();
            jar.setParentUNode(current);
            jar.setCurrentUNode(jar);
            this.setCurrentUNode(jar);
            jar.startElement(namespaceURI, localName, qName, atts);
            this.jarList.add(jar);
            return;
        }
        if (localName.equals("wrapper") && this.wrapper == null) {
            WrapperImpl wrapper = WrapperImpl.newInstance();
            current = this.getCurrentUNode();
            wrapper.setParentUNode(current);
            wrapper.setCurrentUNode(wrapper);
            this.setCurrentUNode(wrapper);
            wrapper.startElement(namespaceURI, localName, qName, atts);
            this.wrapper = wrapper;
            return;
        }
        if (localName.equals("panel") && this.panel == null) {
            PanelImpl panel = PanelImpl.newInstance();
            current = this.getCurrentUNode();
            panel.setParentUNode(current);
            panel.setCurrentUNode(panel);
            this.setCurrentUNode(panel);
            panel.startElement(namespaceURI, localName, qName, atts);
            this.panel = panel;
            return;
        }
        if (localName.equals("icon") && this.icon == null) {
            IconImpl icon = IconImpl.newInstance();
            current = this.getCurrentUNode();
            icon.setParentUNode(current);
            icon.setCurrentUNode(icon);
            this.setCurrentUNode(icon);
            icon.startElement(namespaceURI, localName, qName, atts);
            this.icon = icon;
            return;
        }
        if (localName.equals("menu") && this.menu == null) {
            MenuImpl menu = MenuImpl.newInstance();
            current = this.getCurrentUNode();
            menu.setParentUNode(current);
            menu.setCurrentUNode(menu);
            this.setCurrentUNode(menu);
            menu.startElement(namespaceURI, localName, qName, atts);
            this.menu = menu;
            return;
        }
        if (localName.equals("drop-action")) {
            DropActionImpl dropAction = DropActionImpl.newInstance();
            current = this.getCurrentUNode();
            dropAction.setParentUNode(current);
            dropAction.setCurrentUNode(dropAction);
            this.setCurrentUNode(dropAction);
            dropAction.startElement(namespaceURI, localName, qName, atts);
            this.dropActionList.add(dropAction);
            return;
        }
        if (localName.equals("info") && this.info == null) {
            InfoImpl info = InfoImpl.newInstance();
            current = this.getCurrentUNode();
            info.setParentUNode(current);
            info.setCurrentUNode(info);
            this.setCurrentUNode(info);
            info.startElement(namespaceURI, localName, qName, atts);
            this.info = info;
            return;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.endElement(namespaceURI, localName, qName);
            return;
        }
        Unmarshallable parent = this.getCurrentUNode().getParentUNode();
        if (parent != null) {
            parent.setCurrentUNode(parent);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.characters(ch, start, len);
            return;
        }
        String text = new String(ch, start, len);
        text = text.trim();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
        if (errorHandler != null) {
            errorHandler.warning(e);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.error(e);
        }
    }

    public void fatalError(SAXParseException e) throws SAXException {
        if (this.validate && !this.hasDTD) {
            throw new SAXException("Validation is turned on, but no DTD has been specified in the input XML document. Please supply a DTD through a DOCTYPE reference.");
        }
        if (errorHandler != null) {
            errorHandler.fatalError(e);
        }
    }

    public void startDTD(String name, String publicID, String systemID) throws SAXException {
        if (name == null || name.equals("")) {
            this.docTypeString = "";
            return;
        }
        this.hasDTD = true;
        StringBuffer docTypeSB = new StringBuffer();
        boolean hasPublic = false;
        docTypeSB.append("<!DOCTYPE ").append(name);
        if (publicID != null && !publicID.equals("")) {
            docTypeSB.append(" PUBLIC \"").append(publicID).append("\"");
            hasPublic = true;
        }
        if (systemID != null && !systemID.equals("")) {
            if (!hasPublic) {
                docTypeSB.append(" SYSTEM");
            }
            docTypeSB.append(" \"").append(systemID).append("\"");
        }
        docTypeSB.append(">");
        this.docTypeString = docTypeSB.toString();
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    static {
        prototype = null;
    }
}

