/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.explorerConfig.beans;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.apollon.framework.Bean;
import org.objectweb.apollon.framework.ExtensionManager;
import org.objectweb.apollon.framework.IndexTable;
import org.objectweb.apollon.framework.Listener;
import org.objectweb.apollon.framework.ModificationEvent;
import org.objectweb.util.explorer.explorerConfig.ExplorerImpl;
import org.objectweb.util.explorer.explorerConfig.Include;
import org.objectweb.util.explorer.explorerConfig.Jar;
import org.objectweb.util.explorer.explorerConfig.Menu;
import org.objectweb.util.explorer.explorerConfig.Node;
import org.objectweb.util.explorer.explorerConfig.Role;
import org.objectweb.util.explorer.explorerConfig.Root;
import org.objectweb.util.explorer.explorerConfig.TypeSystem;
import org.objectweb.util.explorer.explorerConfig.Unmarshallable;
import org.objectweb.util.explorer.explorerConfig.Zip;
import org.objectweb.util.explorer.explorerConfig.beans.ExplorerBean;
import org.objectweb.util.explorer.explorerConfig.beans.ExplorerExtensionManager;
import org.objectweb.util.explorer.explorerConfig.beans.ExplorerListener;
import org.objectweb.util.explorer.explorerConfig.beans.ExplorerModificationEvent;
import org.objectweb.util.explorer.explorerConfig.beans.IncludeBeanImpl;
import org.objectweb.util.explorer.explorerConfig.beans.JarBeanImpl;
import org.objectweb.util.explorer.explorerConfig.beans.MenuBeanImpl;
import org.objectweb.util.explorer.explorerConfig.beans.NodeBeanImpl;
import org.objectweb.util.explorer.explorerConfig.beans.RoleBeanImpl;
import org.objectweb.util.explorer.explorerConfig.beans.RootBeanImpl;
import org.objectweb.util.explorer.explorerConfig.beans.TypeSystemBeanImpl;
import org.objectweb.util.explorer.explorerConfig.beans.ZipBeanImpl;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExplorerBeanImpl
extends ExplorerImpl
implements ExplorerBean {
    private List orderedList = new ArrayList();
    private ArrayList explorerListeners = new ArrayList();
    private ExtensionManager _extManager = new ExplorerExtensionManager(this);
    private Unmarshallable zeus_currentUNode;
    private Unmarshallable zeus_parentUNode;
    private boolean zeus_thisNodeHandled = false;
    private boolean hasDTD;
    private boolean validate;
    private Map namespaceMappings;
    private static EntityResolver entityResolver;
    private static ErrorHandler errorHandler;

    public synchronized void addExplorerListener(Listener l) {
        this.explorerListeners.add(l);
    }

    public synchronized void removeExplorerListener(ExplorerListener l) {
        this.explorerListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        ExplorerModificationEvent modifEvent = new ExplorerModificationEvent(this);
        ArrayList lv = null;
        ExplorerBeanImpl explorerBeanImpl = this;
        synchronized (explorerBeanImpl) {
            lv = (ArrayList)this.explorerListeners.clone();
        }
        for (int i = 0; i < lv.size(); ++i) {
            ((Listener)lv.get(i)).refreshData((ModificationEvent)modifEvent);
        }
    }

    public ExtensionManager getExtensionManager() {
        return this._extManager;
    }

    public List getChildrenList() {
        LinkedList<Bean> result = new LinkedList<Bean>();
        Iterator i = this.orderedList.iterator();
        while (i.hasNext()) {
            Object child = i.next();
            if (child instanceof String) {
                if (IndexTable.lookup((String)((String)child)) == null) continue;
                result.add(IndexTable.lookup((String)((String)child)));
                continue;
            }
            result.add((Bean)child);
        }
        return result;
    }

    public void setRoot(Root root) throws IllegalArgumentException {
        this.orderedList.remove(this.getRoot());
        if (root != null) {
            this.orderedList.add(root);
        }
        super.setRoot(root);
    }

    public void setMenuList(List menuList) throws IllegalArgumentException {
        super.setMenuList(menuList);
    }

    public void addMenu(Menu menu) {
        super.addMenu(menu);
        this.orderedList.add(menu);
        this.notifyListeners();
    }

    public void removeMenu(Menu menu) {
        super.removeMenu(menu);
        this.orderedList.remove(menu);
        this.notifyListeners();
    }

    public void setZipList(List zipList) throws IllegalArgumentException {
        super.setZipList(zipList);
    }

    public void addZip(Zip zip) {
        super.addZip(zip);
        this.orderedList.add(zip);
        this.notifyListeners();
    }

    public void removeZip(Zip zip) {
        super.removeZip(zip);
        this.orderedList.remove(zip);
        this.notifyListeners();
    }

    public void setJarList(List jarList) throws IllegalArgumentException {
        super.setJarList(jarList);
    }

    public void addJar(Jar jar) {
        super.addJar(jar);
        this.orderedList.add(jar);
        this.notifyListeners();
    }

    public void removeJar(Jar jar) {
        super.removeJar(jar);
        this.orderedList.remove(jar);
        this.notifyListeners();
    }

    public void setIncludeList(List includeList) throws IllegalArgumentException {
        super.setIncludeList(includeList);
    }

    public void addInclude(Include include) {
        super.addInclude(include);
        this.orderedList.add(include);
        this.notifyListeners();
    }

    public void removeInclude(Include include) {
        super.removeInclude(include);
        this.orderedList.remove(include);
        this.notifyListeners();
    }

    public void setNodeList(List nodeList) throws IllegalArgumentException {
        super.setNodeList(nodeList);
    }

    public void addNode(Node node) {
        super.addNode(node);
        this.orderedList.add(node);
        this.notifyListeners();
    }

    public void removeNode(Node node) {
        super.removeNode(node);
        this.orderedList.remove(node);
        this.notifyListeners();
    }

    public void setTypeSystemList(List typeSystemList) throws IllegalArgumentException {
        super.setTypeSystemList(typeSystemList);
    }

    public void addTypeSystem(TypeSystem typeSystem) {
        super.addTypeSystem(typeSystem);
        this.orderedList.add(typeSystem);
        this.notifyListeners();
    }

    public void removeTypeSystem(TypeSystem typeSystem) {
        super.removeTypeSystem(typeSystem);
        this.orderedList.remove(typeSystem);
        this.notifyListeners();
    }

    public void setRoleList(List roleList) throws IllegalArgumentException {
        super.setRoleList(roleList);
    }

    public void addRole(Role role) {
        super.addRole(role);
        this.orderedList.add(role);
        this.notifyListeners();
    }

    public void removeRole(Role role) {
        super.removeRole(role);
        this.orderedList.remove(role);
        this.notifyListeners();
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }

    public void marshalBean(File file) throws IOException {
        this.marshal(file);
    }

    public static ExplorerBean unmarshalBean(File file) throws IOException {
        return ExplorerBeanImpl.unmarshalBean(new FileReader(file), false);
    }

    public static ExplorerBean unmarshalBean(Reader reader, boolean validate) throws IOException {
        ExplorerBeanImpl explorer = new ExplorerBeanImpl();
        explorer.setValidating(validate);
        explorer.setCurrentUNode(explorer);
        explorer.setParentUNode(null);
        XMLReader parser = null;
        String parserClass = System.getProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        try {
            parser = XMLReaderFactory.createXMLReader(parserClass);
            if (entityResolver != null) {
                parser.setEntityResolver(entityResolver);
            }
            parser.setErrorHandler(explorer);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", explorer);
            parser.setContentHandler(explorer);
        }
        catch (SAXException e) {
            throw new IOException("Could not load XML parser: " + e.getMessage());
        }
        InputSource inputSource = new InputSource(reader);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", new Boolean(validate));
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            parser.parse(inputSource);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing XML document: " + e.getMessage());
        }
        return explorer;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Unmarshallable current = this.getCurrentUNode();
        if (current != this) {
            current.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (localName.equals("explorer") && !this.zeus_thisNodeHandled) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
            }
            this.zeus_thisNodeHandled = true;
            return;
        }
        if (localName.equals("root")) {
            RootBeanImpl root = new RootBeanImpl();
            current = this.getCurrentUNode();
            root.setParentUNode(current);
            root.setCurrentUNode(root);
            this.setCurrentUNode(root);
            root.startElement(namespaceURI, localName, qName, atts);
            this.setRoot(root);
            return;
        }
        if (localName.equals("menu")) {
            MenuBeanImpl menu = new MenuBeanImpl();
            current = this.getCurrentUNode();
            menu.setParentUNode(current);
            menu.setCurrentUNode(menu);
            this.setCurrentUNode(menu);
            menu.startElement(namespaceURI, localName, qName, atts);
            this.getMenuList().add(menu);
            this.orderedList.add(menu);
            return;
        }
        if (localName.equals("zip")) {
            ZipBeanImpl zip = new ZipBeanImpl();
            current = this.getCurrentUNode();
            zip.setParentUNode(current);
            zip.setCurrentUNode(zip);
            this.setCurrentUNode(zip);
            zip.startElement(namespaceURI, localName, qName, atts);
            this.getZipList().add(zip);
            this.orderedList.add(zip);
            return;
        }
        if (localName.equals("jar")) {
            JarBeanImpl jar = new JarBeanImpl();
            current = this.getCurrentUNode();
            jar.setParentUNode(current);
            jar.setCurrentUNode(jar);
            this.setCurrentUNode(jar);
            jar.startElement(namespaceURI, localName, qName, atts);
            this.getJarList().add(jar);
            this.orderedList.add(jar);
            return;
        }
        if (localName.equals("include")) {
            IncludeBeanImpl include = new IncludeBeanImpl();
            current = this.getCurrentUNode();
            include.setParentUNode(current);
            include.setCurrentUNode(include);
            this.setCurrentUNode(include);
            include.startElement(namespaceURI, localName, qName, atts);
            this.getIncludeList().add(include);
            this.orderedList.add(include);
            return;
        }
        if (localName.equals("node")) {
            NodeBeanImpl node = new NodeBeanImpl();
            current = this.getCurrentUNode();
            node.setParentUNode(current);
            node.setCurrentUNode(node);
            this.setCurrentUNode(node);
            node.startElement(namespaceURI, localName, qName, atts);
            this.getNodeList().add(node);
            this.orderedList.add(node);
            return;
        }
        if (localName.equals("type-system")) {
            TypeSystemBeanImpl typeSystem = new TypeSystemBeanImpl();
            current = this.getCurrentUNode();
            typeSystem.setParentUNode(current);
            typeSystem.setCurrentUNode(typeSystem);
            this.setCurrentUNode(typeSystem);
            typeSystem.startElement(namespaceURI, localName, qName, atts);
            this.getTypeSystemList().add(typeSystem);
            this.orderedList.add(typeSystem);
            return;
        }
        if (localName.equals("role")) {
            RoleBeanImpl role = new RoleBeanImpl();
            current = this.getCurrentUNode();
            role.setParentUNode(current);
            role.setCurrentUNode(role);
            this.setCurrentUNode(role);
            role.startElement(namespaceURI, localName, qName, atts);
            this.getRoleList().add(role);
            this.orderedList.add(role);
            return;
        }
    }

    public String idBean() {
        return "[Explorer]";
    }
}

