/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.interpreter.lib.swt;

import java.net.URL;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.api.IconProvider;
import org.objectweb.util.explorer.api.MenuItem;
import org.objectweb.util.explorer.api.MenuItemTreeView;
import org.objectweb.util.explorer.api.TreeView;
import org.objectweb.util.explorer.core.code.api.Code;
import org.objectweb.util.explorer.core.common.api.Description;
import org.objectweb.util.explorer.core.icon.api.IconDescription;
import org.objectweb.util.explorer.core.menu.api.AcceleratorDescription;
import org.objectweb.util.explorer.core.menu.api.ItemDescription;
import org.objectweb.util.explorer.core.menu.api.MenuDescription;
import org.objectweb.util.explorer.core.menu.api.MenuElement;
import org.objectweb.util.explorer.core.menu.api.MenuSeparator;
import org.objectweb.util.explorer.interpreter.api.DescriptionInterpreter;
import org.objectweb.util.explorer.interpreter.lib.AbstractDescriptionInterpreter;
import org.objectweb.util.explorer.interpreter.lib.swt.GenericAction;
import org.objectweb.util.explorer.interpreter.lib.swt.IconFileProvider;

public abstract class AbstractMenuInterpreter
extends AbstractDescriptionInterpreter {
    protected final String ICON_INTERPRETER = "icon-interpreter";
    static /* synthetic */ Class class$org$objectweb$util$explorer$api$MenuItem;

    protected Image getIcon(IconDescription iconDesc, TreeView treeView) {
        IconProvider iconProvider;
        if (iconDesc != null && (iconProvider = (IconProvider)this.getIconInterpreter().interprete(iconDesc, treeView)) != null) {
            Object object = iconProvider.newIcon(treeView.getSelectedObject());
            if (object instanceof Image) {
                return (Image)object;
            }
            if (object instanceof String) {
                return (Image)new IconFileProvider((String)object).newIcon(treeView.getSelectedObject());
            }
            if (object instanceof URL) {
                return (Image)new IconFileProvider((URL)object).newIcon(treeView.getSelectedObject());
            }
        }
        return null;
    }

    protected int getAccelerator(AcceleratorDescription accDesc) {
        int acc = 0;
        if (accDesc != null && !accDesc.isEmpty()) {
            if (accDesc.getCtrlKey()) {
                acc += 262144;
            }
            if (accDesc.getAltKey()) {
                acc += 65536;
            }
            if (accDesc.getShiftKey()) {
                acc += 131072;
            }
            acc += accDesc.getAcceleratorCharacter();
        }
        return acc;
    }

    protected String getAcceleratorName(AcceleratorDescription accDesc) {
        if (accDesc != null && !accDesc.isEmpty()) {
            return accDesc.getName();
        }
        return null;
    }

    protected void addMenuItem(Menu menu, ItemDescription itemDesc, MenuItemTreeView treeView) {
        if (itemDesc != null && !itemDesc.isEmpty()) {
            Code actionCode = this.getCodeProvider().getCode(itemDesc.getCodeDescription());
            if (actionCode != null && actionCode.isInstanceOf(class$org$objectweb$util$explorer$api$MenuItem == null ? (class$org$objectweb$util$explorer$api$MenuItem = AbstractMenuInterpreter.class$("org.objectweb.util.explorer.api.MenuItem")) : class$org$objectweb$util$explorer$api$MenuItem)) {
                MenuItem action = (MenuItem)actionCode.createInstance();
                int actionStatus = action.getStatus(treeView);
                if (actionStatus != 3) {
                    org.eclipse.swt.widgets.MenuItem menuItem = new org.eclipse.swt.widgets.MenuItem(menu, 8);
                    String acceleratorName = this.getAcceleratorName(itemDesc.getAcceleratorDescription());
                    if (acceleratorName != null && !acceleratorName.equals("")) {
                        menuItem.setText(itemDesc.getLabel() + "\t" + acceleratorName);
                        menuItem.setAccelerator(this.getAccelerator(itemDesc.getAcceleratorDescription()));
                    } else {
                        menuItem.setText(itemDesc.getLabel());
                    }
                    menuItem.addListener(13, (Listener)new GenericAction(action, treeView));
                    menuItem.setEnabled(actionStatus != 2);
                    menuItem.setImage(this.getIcon(itemDesc.getIconDescription(), treeView));
                }
            } else {
                this.getTrace().warn(itemDesc.getCodeDescription().getCode() + " is not a MenuItem instance!");
            }
        }
    }

    protected void addMenuSeparator(Menu menu) {
        org.eclipse.swt.widgets.MenuItem separator = new org.eclipse.swt.widgets.MenuItem(menu, 2);
    }

    protected Menu createMenu(MenuDescription menuDesc, MenuItemTreeView treeView) {
        Menu menu = null;
        if (menuDesc != null && !menuDesc.isEmpty()) {
            menu = this.getMenu();
            MenuElement[] menuElement = menuDesc.getAllMenuElements();
            for (int i = 0; i < menuElement.length; ++i) {
                MenuElement element = menuElement[i];
                if (element instanceof ItemDescription) {
                    this.addMenuItem(menu, (ItemDescription)element, treeView);
                    continue;
                }
                if (!(element instanceof MenuSeparator)) continue;
                this.addMenuSeparator(menu);
            }
        }
        return menu;
    }

    protected DescriptionInterpreter getIconInterpreter() {
        try {
            return (DescriptionInterpreter)this.lookupFc("icon-interpreter");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("icon-interpreter: interface not found!");
            return null;
        }
    }

    public String[] clientFc() {
        return new String[]{"code-provider", "icon-interpreter"};
    }

    public Object interprete(Description description, TreeView treeView) {
        MenuDescription menuDesc = (MenuDescription)description;
        return this.createMenu(menuDesc, (MenuItemTreeView)treeView);
    }

    public abstract Menu getMenu();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

