/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.parser.lib;

import java.net.URL;
import org.objectweb.util.explorer.ExplorerUtils;
import org.objectweb.util.explorer.core.code.api.CodeDescription;
import org.objectweb.util.explorer.core.code.lib.BasicCodeDescription;
import org.objectweb.util.explorer.core.icon.api.IconDescription;
import org.objectweb.util.explorer.core.icon.lib.BasicIconCodeDescription;
import org.objectweb.util.explorer.core.icon.lib.BasicIconDescription;
import org.objectweb.util.explorer.core.icon.lib.BasicIconFileDescription;
import org.objectweb.util.explorer.explorerConfig.Code;
import org.objectweb.util.explorer.explorerConfig.Icon;

public class ParserUtils {
    public static CodeDescription getCodeDescription(Code code) {
        BasicCodeDescription cd = new BasicCodeDescription();
        cd.setLanguage(code.getLanguage());
        cd.setCode(code.getValue());
        return cd;
    }

    public static IconDescription getIconDescription(Icon icon) {
        BasicIconDescription iconDescription = null;
        if (icon != null) {
            CodeDescription codeDesc;
            if (icon.getIconFile() != null) {
                URL url = ExplorerUtils.getURL(icon.getIconFile().getUrl());
                if (url != null) {
                    iconDescription = new BasicIconFileDescription();
                    iconDescription.setURL(url);
                }
            } else if (icon.getCode() != null && (codeDesc = ParserUtils.getCodeDescription(icon.getCode())) != null) {
                iconDescription = new BasicIconCodeDescription();
                ((BasicIconCodeDescription)iconDescription).setCode(codeDesc);
            }
        }
        return iconDescription;
    }
}

