/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.resolver.lib;

import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.core.common.api.BadParamException;
import org.objectweb.util.explorer.core.common.api.Description;
import org.objectweb.util.explorer.core.common.api.KeyProvider;
import org.objectweb.util.explorer.core.common.lib.BindingFeature;
import org.objectweb.util.explorer.core.common.lib.ClassesInheritance;
import org.objectweb.util.explorer.core.role.api.RoleManager;
import org.objectweb.util.explorer.core.role.api.RoleProvider;
import org.objectweb.util.explorer.property.api.PropertyProvider;
import org.objectweb.util.explorer.resolver.api.PropertyResolver;

public abstract class AbstractPropertyResolver
extends BindingFeature
implements PropertyResolver {
    protected String getTypeSystemId() {
        return "Java";
    }

    protected KeyProvider getKeyProvider() {
        try {
            return (KeyProvider)this.lookupFc("key-provider");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("key-provider: interface not found!");
            return null;
        }
    }

    protected PropertyProvider getPropertyProvider() {
        try {
            return (PropertyProvider)this.lookupFc("property-provider");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("property-provider: interface not found!");
            return null;
        }
    }

    protected RoleManager getRoleManager() {
        try {
            return (RoleManager)this.lookupFc("role-manager");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("role-manager: interface not found!");
            return null;
        }
    }

    protected RoleProvider getRoleProvider() {
        try {
            return (RoleProvider)this.lookupFc("role-provider");
        }
        catch (NoSuchInterfaceException e) {
            this.getTrace().warn("role-provider: interface not found!");
            return null;
        }
    }

    protected Description getDescription(Entry entry) {
        if (entry != null && entry.getValue() != null) {
            Class[] javaTypes = ClassesInheritance.getInheritedClasses(entry.getValue().getClass());
            String[] roleIds = this.getRoleProvider().getInheritedRoleIds(this.getRoleManager().getCurrentRoleIds());
            for (int i = 0; i < javaTypes.length; ++i) {
                for (int j = 0; j < roleIds.length; ++j) {
                    Description desc;
                    Object key = null;
                    try {
                        key = this.getKeyProvider().computeKey(new String[]{this.getTypeSystemId(), javaTypes[i].getName(), roleIds[j]});
                    }
                    catch (BadParamException e) {
                        this.getTrace().warn("Bad key param: " + e.getMessage());
                    }
                    if (key == null || (desc = this.getPropertyProvider().getPropertyDescription(this.getPropertyType(), key)) == null) continue;
                    return desc;
                }
            }
        }
        return null;
    }

    protected abstract String getPropertyType();

    public Description resolve(String propertyType, Entry currentEntry) {
        return this.resolve(this.getPropertyType(), currentEntry, null);
    }

    public String[] clientFc() {
        return new String[]{"property-provider", "key-provider", "role-manager", "role-provider"};
    }
}

