/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.resolver.lib;

import org.objectweb.util.explorer.api.Entry;
import org.objectweb.util.explorer.core.common.api.BadParamException;
import org.objectweb.util.explorer.core.common.api.Description;
import org.objectweb.util.explorer.core.common.lib.ClassesInheritance;
import org.objectweb.util.explorer.core.menu.api.MenuDescription;
import org.objectweb.util.explorer.core.menu.lib.BasicMenuSeparator;
import org.objectweb.util.explorer.resolver.lib.AbstractPropertyResolver;
import org.objectweb.util.explorer.resolver.lib.ExtendedMenuDescription;

public class MenuResolver
extends AbstractPropertyResolver {
    protected String getPropertyType() {
        return "menu";
    }

    protected MenuDescription mergeMenuDescription(MenuDescription source, MenuDescription target) {
        if (target != null) {
            source.addMenuElements(target.getAllMenuElements());
        }
        return source;
    }

    protected MenuDescription getMenuDesc(Object key) {
        return (MenuDescription)this.getPropertyProvider().getPropertyDescription(this.getPropertyType(), key);
    }

    protected MenuDescription getMenuDescription(Entry entry, boolean childrenMenuElement) {
        ExtendedMenuDescription menuDesc = new ExtendedMenuDescription();
        if (entry != null && entry.getValue() != null) {
            Class[] javaTypes = ClassesInheritance.getInheritedClasses(entry.getValue().getClass());
            String[] roleIds = this.getRoleProvider().getInheritedRoleIds(this.getRoleManager().getCurrentRoleIds());
            boolean isFirst = true;
            for (int i = 0; i < javaTypes.length; ++i) {
                for (int j = 0; j < roleIds.length; ++j) {
                    MenuDescription newMenuDesc;
                    Object key = null;
                    try {
                        key = this.getKeyProvider().computeKey(new String[]{this.getTypeSystemId(), javaTypes[i].getName(), roleIds[j]});
                    }
                    catch (BadParamException e) {
                        this.getTrace().warn("Bad key param: " + e.getMessage());
                    }
                    if (key == null || (newMenuDesc = this.getMenuDesc(key)) == null || newMenuDesc.isEmpty()) continue;
                    if (childrenMenuElement) {
                        menuDesc.addChildrenMenuElements(newMenuDesc);
                        continue;
                    }
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        menuDesc.addMenuElement(new BasicMenuSeparator());
                    }
                    menuDesc.addMenuElements(newMenuDesc, i == 0);
                }
            }
        }
        return menuDesc;
    }

    protected MenuDescription getMenuDescription(Entry currentEntry, Entry parentEntry) {
        MenuDescription currentMenu = this.getMenuDescription(currentEntry, false);
        if (parentEntry != null) {
            return this.mergeMenuDescription(currentMenu, this.getMenuDescription(parentEntry, true));
        }
        return currentMenu;
    }

    public Description resolve(String propertyType, Entry currentEntry, Entry parentEntry) {
        return this.getMenuDescription(currentEntry, parentEntry);
    }
}

