/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.objectweb.util.explorer.swing.graph.CacheBounds;
import org.objectweb.util.explorer.swing.graph.CompositeVertex;
import org.objectweb.util.explorer.swing.graph.Graph;
import org.objectweb.util.explorer.swing.graph.PrimitiveVertex;
import org.objectweb.util.explorer.swing.graph.VertexGraphicsInterface;

public class LayoutAlgorithm {
    private Vector vertecesPosition = new Vector();
    private VertexGraphicsInterface vg;
    private boolean isFirst = true;

    public LayoutAlgorithm(Vector vertecesPosition, VertexGraphicsInterface vg) {
        this.vertecesPosition = vertecesPosition;
        this.vg = vg;
    }

    private CellView getVertexView(JGraph graph, PrimitiveVertex vertex) {
        CellView[] roots = graph.getGraphLayoutCache().getRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!((PrimitiveVertex)((Object)roots[i].getCell())).getName().equals(vertex.getName())) continue;
            return roots[i];
        }
        return null;
    }

    public void refreshGraph(JGraph graph, PrimitiveVertex vertex, int x, int y) {
        Hashtable<PrimitiveVertex, AttributeMap> nested = new Hashtable<PrimitiveVertex, AttributeMap>();
        AttributeMap vAttributes = vertex.getAttributes();
        Dimension size = vertex.getSize();
        GraphConstants.setBounds((Map)vAttributes, (Rectangle2D)new Rectangle(x, y, size.width, size.height));
        nested.put(vertex, vAttributes);
        graph.getGraphLayoutCache().edit(nested, null, null, null);
    }

    public void resizeComposite(JGraph graph, CompositeVertex vertex, Point origin, int width, int height) {
        if (vertex != null) {
            vertex.setSize(new Dimension(width, height));
            Hashtable<CompositeVertex, AttributeMap> nested = new Hashtable<CompositeVertex, AttributeMap>();
            AttributeMap vAttributes = vertex.getAttributes();
            Dimension size = vertex.getSize();
            GraphConstants.setBounds((Map)vAttributes, (Rectangle2D)new Rectangle(origin.x, origin.y, width, height));
            nested.put(vertex, vAttributes);
            graph.getGraphLayoutCache().edit(nested, null, null, null);
        }
    }

    private int getLineWidth(Vector line) {
        int width = 0;
        for (int i = 0; i < line.size(); ++i) {
            PrimitiveVertex vertex = (PrimitiveVertex)((Object)line.get(i));
            if (vertex == null) continue;
            width += vertex.getSize().width;
        }
        return width;
    }

    private int getColumnHeight(int columnIndex) {
        int height = 0;
        for (int i = 0; i < this.vertecesPosition.size(); ++i) {
            PrimitiveVertex vertex;
            Vector column = (Vector)this.vertecesPosition.get(i);
            if (column.size() <= columnIndex || (vertex = (PrimitiveVertex)((Object)column.get(columnIndex))) == null) continue;
            height += vertex.getSize().height;
        }
        return height;
    }

    private int getNbColumn() {
        int nb = 0;
        for (int i = 0; i < this.vertecesPosition.size(); ++i) {
            Vector line = (Vector)this.vertecesPosition.get(i);
            int lineSize = 0;
            for (int j = 0; j < line.size(); ++j) {
                if (line.get(j) == null) continue;
                ++lineSize;
            }
            if (lineSize <= nb) continue;
            nb = lineSize;
        }
        return nb;
    }

    private int getNbLine() {
        return this.vertecesPosition.size();
    }

    private int getGraphWidth() {
        int width = 0;
        for (int i = 0; i < this.vertecesPosition.size(); ++i) {
            Vector line = (Vector)this.vertecesPosition.get(i);
            if (this.getLineWidth(line) <= width) continue;
            width = this.getLineWidth(line);
        }
        return width;
    }

    private int getGraphHeight() {
        int height = 0;
        for (int i = 0; i < this.getNbColumn(); ++i) {
            if (this.getColumnHeight(i) <= height) continue;
            height = this.getColumnHeight(i);
        }
        return height;
    }

    public void applyLayout(Graph graph, Point compositeOrigin, Dimension compositeSize, CompositeVertex composite) {
        int nbColumn;
        int currentX = compositeOrigin.x + VertexGraphicsInterface.FIRST_VETEX_LOCATION.x;
        int currentY = compositeOrigin.y + VertexGraphicsInterface.FIRST_VETEX_LOCATION.y;
        int w = this.getGraphWidth();
        int h = this.getGraphHeight();
        int nbLine = this.getNbLine() - 1;
        if (nbLine == 0) {
            ++nbLine;
        }
        if ((nbColumn = this.getNbColumn() - 1) == 0) {
            ++nbColumn;
        }
        int intervalX = (compositeSize.width - this.getGraphWidth() - VertexGraphicsInterface.FIRST_VETEX_LOCATION.x * 2) / nbColumn - 10;
        int intervalY = (compositeSize.height - this.getGraphHeight() - VertexGraphicsInterface.FIRST_VETEX_LOCATION.y * 3) / nbLine;
        if (intervalX < 45) {
            if (intervalX < 0) {
                intervalX = 0;
            }
            int newWidth = compositeSize.width + nbColumn * (45 - intervalX);
            if (composite != null) {
                if (!CacheBounds.isCached(graph.mainViewedComponent, composite)) {
                    this.resizeComposite(graph, composite, compositeOrigin, newWidth, compositeSize.height);
                    this.applyLayout(graph, compositeOrigin, compositeSize, composite);
                }
            } else {
                compositeSize.width = newWidth;
                this.applyLayout(graph, compositeOrigin, compositeSize, composite);
            }
        } else if (intervalY < 45) {
            if (intervalY < 0) {
                intervalY = 0;
            }
            int newHeight = compositeSize.height + nbLine * (45 - intervalY);
            if (composite != null) {
                if (!CacheBounds.isCached(graph.mainViewedComponent, composite)) {
                    this.resizeComposite(graph, composite, compositeOrigin, compositeSize.width, newHeight);
                    this.applyLayout(graph, compositeOrigin, compositeSize, composite);
                }
            } else {
                compositeSize.height = newHeight;
                this.applyLayout(graph, compositeOrigin, compositeSize, composite);
            }
        } else {
            this.isFirst = false;
            this.resizeComposite(graph, composite, compositeOrigin, compositeSize.width, compositeSize.height);
            for (int i = 0; i < this.vertecesPosition.size(); ++i) {
                int precedentWidth = 0;
                currentX = compositeOrigin.x + VertexGraphicsInterface.FIRST_VETEX_LOCATION.x;
                Vector courantLine = (Vector)this.vertecesPosition.get(i);
                int maxVertexHeight = 0;
                for (int j = 0; j < courantLine.size(); ++j) {
                    PrimitiveVertex currentVertex = (PrimitiveVertex)((Object)courantLine.get(j));
                    Dimension vertexSize = new Dimension(0, 0);
                    if (currentVertex != null) {
                        vertexSize = currentVertex.getSize();
                        if (!CacheBounds.isCached(graph.mainViewedComponent, currentVertex)) {
                            this.refreshGraph(graph, currentVertex, currentX, currentY);
                        }
                        if (maxVertexHeight < vertexSize.height) {
                            maxVertexHeight = vertexSize.height;
                        }
                    } else {
                        vertexSize = this.vg.getDefaultSize();
                    }
                    precedentWidth = (int)vertexSize.getWidth();
                    currentX = currentX + precedentWidth + intervalX;
                }
                currentY = currentY + maxVertexHeight + intervalY;
            }
        }
    }
}

