/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.graph;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.EdgeView;
import org.objectweb.util.explorer.swing.graph.MyPort;
import org.objectweb.util.explorer.swing.graph.MyPortView;

public class MyBindingView
extends EdgeView {
    private static int portCourantPosition = 0;
    protected static MyEdgeRenderer renderer = new MyEdgeRenderer();

    public MyBindingView(JGraph graph, CellMapper cm, Object cell) {
        super(cell, graph, cm);
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public static class MyEdgeRenderer
    extends EdgeRenderer {
        public Rectangle2D getPaintBounds(EdgeView view) {
            Rectangle r = super.getPaintBounds(view).getBounds();
            return new Rectangle(r.x - 40, r.y - 40, r.width + 80, r.height + 80);
        }

        public void paint(Graphics g) {
            MyPortView sourceView = (MyPortView)this.view.getSource();
            MyPortView targetView = (MyPortView)this.view.getTarget();
            MyPort source = (MyPort)((Object)sourceView.getCell());
            MyPort target = (MyPort)((Object)targetView.getCell());
            Graphics2D g2 = (Graphics2D)g;
            int c = 0;
            int j = 0;
            g2.setStroke(new BasicStroke(this.lineWidth, c, j));
            this.translateGraphics(g);
            g.setColor(this.getForeground());
            if (this.view.lineShape != null) {
                Shape s = this.view.lineShape;
                g2.draw(this.view.lineShape);
            }
            String label = this.graph.convertValueToString((Object)this.view);
            g2.setStroke(new BasicStroke(1.0f));
            g.setFont(this.getFont());
            String targetName = target.getName();
            g.drawString(source.getName(), (int)sourceView.getLocation(this.view).getX(), (int)sourceView.getLocation(this.view).getY());
            g.drawString(targetName, (int)targetView.getLocation(this.view).getX() - targetName.length() * 6, (int)targetView.getLocation(this.view).getY());
        }
    }
}

