/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.objectweb.util.explorer.swing.graph.CompositeVertex;
import org.objectweb.util.explorer.swing.graph.CurrentDynamicTree;
import org.objectweb.util.explorer.swing.graph.Graph;
import org.objectweb.util.explorer.swing.graph.MyPort;
import org.objectweb.util.explorer.swing.graph.PortGraphicsInterface;
import org.objectweb.util.explorer.swing.graph.PrimitiveVertex;
import org.objectweb.util.explorer.swing.graph.VertexGraphicsInterface;

public class MyPortView
extends PortView {
    private PortGraphicsInterface pg = Graph.getPortGraphics();
    private VertexGraphicsInterface vg = Graph.getVertexGraphics();
    protected static MyPortRenderer renderer = new MyPortRenderer();

    public MyPortView(JGraph graph, CellMapper cm, Object cell) {
        super(cell, graph, cm);
    }

    public Point2D getLocation(EdgeView edge) {
        Port modelAnchor = null;
        if (this.cell instanceof Port) {
            modelAnchor = ((Port)this.cell).getAnchor();
        }
        MyPort port = (MyPort)((Object)this.cell);
        PrimitiveVertex vertex = (PrimitiveVertex)((Object)((MyPort)((Object)this.cell)).getParent());
        PortView anchor = (PortView)this.mapper.getMapping((Object)modelAnchor, false);
        Point pos = null;
        boolean isAbsolute = GraphConstants.isAbsolute((Map)this.allAttributes);
        Point2D offset = GraphConstants.getOffset((Map)this.allAttributes);
        VertexView vertexView = (VertexView)this.getParentView();
        if (vertexView != null && edge != null) {
            MyPort p = (MyPort)((Object)this.getCell());
            String portType = p.getType();
            if (portType.equals("server") || portType.equals("facet") || portType.equals("consumer")) {
                pos = new Point((int)this.getBounds().getX(), (int)this.getBounds().getCenterY());
            } else if (portType.equals("client") || portType.equals("collection") || portType.equals("receptacle") || portType.equals("publisher") || portType.equals("emitter")) {
                pos = new Point((int)this.getBounds().getX() + (int)this.getBounds().getWidth(), (int)this.getBounds().getCenterY());
            } else if (portType.equals("controler")) {
                pos = new Point((int)this.getBounds().getCenterX(), (int)this.getBounds().getY());
            }
        }
        return pos;
    }

    public Rectangle2D getBounds() {
        int nbControllerPorts;
        int nbClientPorts;
        int nbServerPorts;
        Rectangle parentBounds = super.getParentView().getBounds().getBounds();
        String portType = ((MyPort)((Object)this.getCell())).getType();
        boolean isGenerated = ((MyPort)((Object)this.getCell())).isGenerated();
        PrimitiveVertex vertex = (PrimitiveVertex)((Object)((MyPort)((Object)this.getCell())).getParent());
        Dimension vertexSize = new Dimension(parentBounds.width, parentBounds.height);
        Rectangle bounds = new Rectangle();
        bounds.height = this.pg.getPortSize((String)portType, (boolean)false).height;
        bounds.width = this.pg.getPortSize((String)portType, (boolean)false).width;
        if (vertex instanceof CompositeVertex && ((CompositeVertex)vertex).isOpen()) {
            bounds.height = this.pg.getPortSize((String)portType, (boolean)true).height;
            bounds.width = this.pg.getPortSize((String)portType, (boolean)true).width;
            nbServerPorts = ((CompositeVertex)vertex).getListInternalServerPorts().size();
            nbClientPorts = ((CompositeVertex)vertex).getListInternalClientPorts().size();
            nbControllerPorts = ((CompositeVertex)vertex).getListInternalControllerPorts().size();
        } else {
            nbServerPorts = vertex.getListServerPorts().size();
            nbClientPorts = vertex.getListClientPorts().size();
            nbControllerPorts = vertex.getListControllerPorts().size();
        }
        if (portType.equals("server") || portType.equals("facet") || portType.equals("consumer")) {
            int interval = (vertexSize.height - 25) / nbServerPorts;
            bounds.x = !isGenerated ? parentBounds.x - bounds.width : parentBounds.x + vertexSize.width - bounds.width - 5;
            bounds.y = 25 + parentBounds.y + interval * (((MyPort)((Object)this.getCell())).getNumber() - 1);
        } else if (portType.equals("client") || portType.equals("collection") || portType.equals("receptacle") || portType.equals("publisher") || portType.equals("emitter")) {
            int interval = (vertexSize.height - 25) / nbClientPorts;
            bounds.x = !isGenerated ? parentBounds.x + vertexSize.width : parentBounds.x + 5;
            bounds.y = 25 + parentBounds.y + interval * (((MyPort)((Object)this.getCell())).getNumber() - 1);
        } else if (portType.equals("controler")) {
            int interval = vertexSize.width / nbControllerPorts;
            bounds.x = parentBounds.x + interval * (((MyPort)((Object)this.getCell())).getNumber() - 1) + this.pg.getPortSize((String)portType, (boolean)false).width;
            bounds.y = parentBounds.y - bounds.height;
        }
        return bounds;
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext context) {
        return new CellHandle(){

            public void paint(Graphics g) {
            }

            public void overlay(Graphics g) {
            }

            public void mouseMoved(MouseEvent event) {
            }

            public void mousePressed(MouseEvent event) {
                JPopupMenu menu;
                MyPort v = (MyPort)((Object)MyPortView.this.getCell());
                Object component = v.getItf();
                CurrentDynamicTree.refreshGUI(component);
                if (SwingUtilities.isRightMouseButton(event) && (menu = CurrentDynamicTree.getJPopupMenu(component)) != null) {
                    menu.show((Component)MyPortView.this.graph, event.getX(), event.getY());
                }
            }

            public void mouseDragged(MouseEvent event) {
            }

            public void mouseReleased(MouseEvent event) {
            }
        };
    }

    public static class MyPortRenderer
    extends PortRenderer {
        public void paint(Graphics g) {
            PortGraphicsInterface pg = Graph.getPortGraphics();
            MyPort port = (MyPort)((Object)this.view.getCell());
            PrimitiveVertex vertex = (PrimitiveVertex)((Object)port.getParent());
            String portType = port.getType();
            Rectangle bounds = g.getClipBounds();
            boolean isInternal = false;
            if (vertex instanceof CompositeVertex && ((CompositeVertex)vertex).isOpen()) {
                isInternal = true;
            } else {
                bounds.height = pg.getPortSize((String)portType, (boolean)isInternal).height;
                bounds.width = pg.getPortSize((String)portType, (boolean)isInternal).width;
            }
            g.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
            if (!portType.equals("controler") || vertex.getControllerDisplay()) {
                pg.drawPort(g, port.getName(), portType, isInternal);
            }
        }
    }
}

