/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.gui.lib;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.objectweb.util.explorer.swing.gui.api.ValidateReport;
import org.objectweb.util.explorer.swing.gui.lib.AbstractElementBox;
import org.objectweb.util.explorer.swing.gui.lib.DefaultValidateReport;

public class BooleanBox
extends AbstractElementBox {
    protected ButtonGroup group_ = null;

    public BooleanBox(String label) {
        this(label, "True", "False", true);
    }

    public BooleanBox(String label, String trueLabel, String falseLabel, boolean defaultValue) {
        this.add(Box.createHorizontalGlue());
        JLabel fieldLabel = new JLabel(label + ": ", 4);
        fieldLabel.setAlignmentX(1.0f);
        fieldLabel.setAlignmentY(0.5f);
        this.add(fieldLabel);
        this.add(Box.createHorizontalStrut(5));
        JRadioButton trueButton = new JRadioButton(trueLabel);
        trueButton.setActionCommand("true");
        if (defaultValue) {
            trueButton.setSelected(true);
        }
        trueButton.setPreferredSize(new Dimension(110, 20));
        trueButton.setMaximumSize(new Dimension(110, 20));
        this.add(trueButton);
        this.add(Box.createHorizontalStrut(5));
        JRadioButton falseButton = new JRadioButton(falseLabel);
        falseButton.setActionCommand("false");
        if (!defaultValue) {
            falseButton.setSelected(true);
        }
        falseButton.setPreferredSize(new Dimension(110, 20));
        falseButton.setMaximumSize(new Dimension(110, 20));
        this.add(falseButton);
        this.group_ = new ButtonGroup();
        this.group_.add(trueButton);
        this.group_.add(falseButton);
    }

    public ValidateReport validateBox() {
        return new DefaultValidateReport();
    }

    public Box getBox() {
        return this;
    }

    public boolean getValue() {
        return this.group_.getSelection().getActionCommand().equals("true");
    }
}

