/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.explorer.swing.gui.lib;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.objectweb.util.explorer.swing.gui.api.DialogAction;
import org.objectweb.util.explorer.swing.gui.api.DialogBox;
import org.objectweb.util.explorer.swing.gui.api.ElementBox;
import org.objectweb.util.explorer.swing.gui.api.ValidateReport;
import org.objectweb.util.explorer.swing.gui.lib.DefaultValidateReport;

public class DefaultDialogBox
extends JDialog
implements DialogBox {
    protected boolean firstShowInvocation_ = true;
    protected Action validateAction_;
    protected Action cancelAction_;
    protected DialogAction validateDialogAction_;
    protected DialogAction cancelDialogAction_;
    protected Box compositeBox_;
    protected List elements_ = new Vector();

    public DefaultDialogBox() {
        this("");
    }

    public DefaultDialogBox(String title) {
        this.setModal(true);
        this.setTitle(title);
        this.getContentPane().add(this.createMainBox());
    }

    protected Box createCompositeBox() {
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalStrut(10));
        this.compositeBox_ = Box.createVerticalBox();
        this.compositeBox_.add(Box.createVerticalStrut(10));
        b.add(this.compositeBox_);
        b.add(Box.createHorizontalStrut(10));
        return b;
    }

    protected Box createMainBox() {
        Box mainBox = Box.createVerticalBox();
        mainBox.add(this.createCompositeBox());
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        this.validateAction_ = new DefaultOKAction();
        buttonBox.add(new JButton(this.validateAction_));
        buttonBox.add(Box.createHorizontalStrut(10));
        this.cancelAction_ = new DefaultCancelAction();
        buttonBox.add(new JButton(this.cancelAction_));
        buttonBox.add(Box.createHorizontalGlue());
        mainBox.add(buttonBox);
        mainBox.add(Box.createVerticalStrut(10));
        return mainBox;
    }

    public void addElementBox(ElementBox box) {
        this.elements_.add(box);
        this.compositeBox_.add(box.getBox());
        this.compositeBox_.add(Box.createVerticalStrut(10));
    }

    public JDialog getJDialog() {
        return this;
    }

    public void show() {
        Iterator it = this.elements_.iterator();
        while (it.hasNext()) {
            ElementBox element = (ElementBox)it.next();
            element.preInitialize();
        }
        this.pack();
        if (this.firstShowInvocation_) {
            this.firstShowInvocation_ = false;
            this.setDefaultCloseOperation(1);
            this.setResizable(false);
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        }
        super.show();
    }

    public void hide() {
        Iterator it = this.elements_.iterator();
        while (it.hasNext()) {
            ElementBox element = (ElementBox)it.next();
            element.postInitialize();
        }
        super.hide();
    }

    public void setValidateAction(DialogAction action) {
        this.validateDialogAction_ = action;
    }

    public void setValidateLabel(String label) {
        this.validateAction_.putValue("Name", label);
    }

    public void setCancelAction(DialogAction action) {
        this.cancelDialogAction_ = action;
    }

    public void setCancelLabel(String label) {
        this.cancelAction_.putValue("Name", label);
    }

    public ValidateReport validateDialog() {
        Iterator it = this.elements_.iterator();
        while (it.hasNext()) {
            ElementBox element = (ElementBox)it.next();
            ValidateReport report = element.validateBox();
            if (report.getResult()) continue;
            return report;
        }
        return new DefaultValidateReport();
    }

    protected class DefaultCancelAction
    extends AbstractAction {
        protected DefaultCancelAction() {
            super("Cancel", null);
        }

        public void actionPerformed(ActionEvent ae) {
            boolean exception = false;
            if (DefaultDialogBox.this.cancelDialogAction_ != null) {
                try {
                    DefaultDialogBox.this.cancelDialogAction_.executeAction();
                }
                catch (Exception e) {
                    exception = true;
                    JOptionPane.showMessageDialog(null, e.getMessage(), ae.getActionCommand(), 0);
                }
            } else {
                DefaultDialogBox.this.hide();
            }
        }
    }

    protected class DefaultOKAction
    extends AbstractAction {
        protected DefaultOKAction() {
            super("OK", null);
        }

        public void actionPerformed(ActionEvent ae) {
            ValidateReport report = DefaultDialogBox.this.validateDialog();
            if (report.getResult()) {
                boolean exception = false;
                if (DefaultDialogBox.this.validateDialogAction_ != null) {
                    try {
                        DefaultDialogBox.this.validateDialogAction_.executeAction();
                    }
                    catch (Exception e) {
                        exception = true;
                        JOptionPane.showMessageDialog(null, e.getClass().getName() + ":\n" + e.getMessage(), "Exception (" + ae.getActionCommand() + ")", 0);
                    }
                }
                if (!exception) {
                    DefaultDialogBox.this.hide();
                }
            } else {
                JOptionPane.showMessageDialog(null, report.getMessage(), "Params error !", 0);
            }
        }
    }
}

